/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.UnsynchronizedBufferedInputStream;
import com.ibm.team.repository.common.utils.UnsynchronizedBufferedOutputStream;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayInputStream;
import com.ibm.team.repository.common.utils.UnsynchronizedByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public abstract class TemporaryOutputStream
extends FilterOutputStream
implements DisposableInputStreamProvider {
    private static final int MAXIMUM_INMEMORY_SIZE = 262144;
    protected boolean closed;

    private TemporaryOutputStream(OutputStream out) {
        super(out);
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    public void dispose() throws IOException {
    }

    public static TemporaryOutputStream getTemporaryOutputStream(long expectedSize) throws IOException {
        return TemporaryOutputStream.getTemporaryOutputStream(expectedSize, null);
    }

    private static TemporaryOutputStream getTemporaryOutputStream(long expectedSize, String fileExtension) throws IOException {
        if (expectedSize > 262144L) {
            AutoDeletingFile f = new AutoDeletingFile(File.createTempFile("content", TemporaryOutputStream.asFileExtension(fileExtension)).getAbsoluteFile());
            return new TemporaryFileOutputStream(f);
        }
        return new TemporaryMemoryOutputStream(new UnsynchronizedByteArrayOutputStream((int)expectedSize){

            protected void reallocate(int size) {
                throw new IllegalArgumentException("Trying to write more than promised");
            }
        });
    }

    private static String asFileExtension(String fileExtension) {
        if (fileExtension == null) {
            return null;
        }
        if (fileExtension.startsWith(".")) {
            return fileExtension;
        }
        return "." + fileExtension;
    }

    public static TemporaryOutputStream getEstimatedSizeTemporaryOutputStream(long sizeEstimate) throws IOException {
        if (sizeEstimate <= 262144L) {
            if (sizeEstimate < 0L) {
                sizeEstimate = 32L;
            }
            return new DynamicTemporaryOutputStream((int)sizeEstimate);
        }
        return TemporaryOutputStream.getTemporaryOutputStream(524288L);
    }

    public static DisposableInputStreamProvider createLocalBuffer(IInputStreamProvider stream, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        return TemporaryOutputStream.createLocalBuffer(stream.getInputStream((IProgressMonitor)progress.newChild(50)), (IProgressMonitor)progress.newChild(50));
    }

    public static DisposableInputStreamProvider createLocalBuffer(InputStream inputStream, IProgressMonitor monitor) throws IOException {
        return TemporaryOutputStream.createLocalBuffer(inputStream, null, false, monitor);
    }

    public static DisposableInputStreamProvider createLocalBuffer(InputStream inputStream, String extension, boolean alwaysCacheOnDisk, IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            TemporaryOutputStream temporaryOutputStream;
            byte[] nextRead = new byte[262144];
            int bytesRead = 0;
            while (bytesRead < 262144) {
                TemporaryOutputStream.checkCanceled(monitor);
                int thisRead = inputStream.read(nextRead, bytesRead, 262144 - bytesRead);
                if (thisRead == -1) break;
                bytesRead += thisRead;
            }
            TemporaryOutputStream tos = bytesRead == 262144 || alwaysCacheOnDisk ? TemporaryOutputStream.getTemporaryOutputStream(524288L, extension) : TemporaryOutputStream.getTemporaryOutputStream(Math.max(bytesRead, 0), extension);
            try {
                progress.worked(50);
                while (bytesRead >= 0) {
                    TemporaryOutputStream.checkCanceled(monitor);
                    if (bytesRead > 0) {
                        tos.write(nextRead, 0, bytesRead);
                    }
                    bytesRead = inputStream.read(nextRead);
                    progress.setWorkRemaining(100);
                    progress.worked(50);
                }
                temporaryOutputStream = tos;
            }
            catch (Throwable throwable) {
                tos.close();
                throw throwable;
            }
            tos.close();
            return temporaryOutputStream;
        }
        finally {
            inputStream.close();
        }
    }

    private static void checkCanceled(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.getServerString("TemporaryOutputStream.OperationCancelled"));
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    /* synthetic */ TemporaryOutputStream(OutputStream outputStream, TemporaryOutputStream temporaryOutputStream) {
        this(outputStream);
    }

    private static class AutoDeletingFile {
        private static final DeleteFilesHook hook = new DeleteFilesHook();
        private File f;

        static {
            Runtime.getRuntime().addShutdownHook(hook);
        }

        public AutoDeletingFile(File file) {
            this.f = file;
            hook.autoDelete(this.f);
        }

        protected void finalize() throws Throwable {
            if (this.f != null && (this.f.delete() || !this.f.exists())) {
                hook.deleted(this.f);
            }
            super.finalize();
        }

        public File getFile() {
            return this.f;
        }

        public boolean delete() {
            File file = this.f;
            boolean result = file.delete();
            if (result || !file.exists()) {
                hook.deleted(file);
                this.f = null;
            }
            return result;
        }

        private static class DeleteFilesHook
        extends Thread {
            private final Map<File, File> filesToDelete = new ConcurrentHashMap<File, File>();

            private DeleteFilesHook() {
            }

            public void run() {
                while (!this.filesToDelete.isEmpty()) {
                    Iterator<File> it = this.filesToDelete.keySet().iterator();
                    while (it.hasNext()) {
                        File f = it.next();
                        f.delete();
                        it.remove();
                    }
                }
            }

            public void autoDelete(File f) {
                this.filesToDelete.put(f, f);
            }

            public void deleted(File f) {
                this.filesToDelete.remove(f);
            }
        }
    }

    private static class DynamicTemporaryOutputStream
    extends TemporaryOutputStream {
        private AutoDeletingFile f;
        private Map<InputStream, InputStream> openStreams;

        public DynamicTemporaryOutputStream(int sizeEstimate) throws IOException {
            super(new UnsynchronizedByteArrayOutputStream(sizeEstimate){

                protected void reallocate(int size) {
                    super.reallocate(Math.min(size, 262144));
                }
            }, null);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            UnsynchronizedByteArrayOutputStream bout;
            if (this.f == null && (bout = (UnsynchronizedByteArrayOutputStream)this.out).size() + len > 262144) {
                this.f = new AutoDeletingFile(File.createTempFile("content", null).getAbsoluteFile());
                this.openStreams = new ConcurrentHashMap<InputStream, InputStream>();
                this.out = new UnsynchronizedBufferedOutputStream(new FileOutputStream(this.f.getFile()));
                bout.writeTo(this.out);
            }
            this.out.write(b, off, len);
        }

        public void write(int b) throws IOException {
            UnsynchronizedByteArrayOutputStream bout;
            if (this.f == null && (bout = (UnsynchronizedByteArrayOutputStream)this.out).size() == 262144) {
                this.f = new AutoDeletingFile(File.createTempFile("content", null).getAbsoluteFile());
                this.openStreams = new ConcurrentHashMap<InputStream, InputStream>();
                this.out = new UnsynchronizedBufferedOutputStream(new FileOutputStream(this.f.getFile()));
                bout.writeTo(this.out);
            }
            this.out.write(b);
        }

        public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
            if (!this.closed) {
                throw new IOException("The output stream has not been closed yet");
            }
            AutoDeletingFile file = this.f;
            if (this.f == null) {
                UnsynchronizedByteArrayOutputStream bout = (UnsynchronizedByteArrayOutputStream)this.out;
                return new UnsynchronizedByteArrayInputStream(bout.getBuffer(), 0, bout.size());
            }
            TemporaryInputStream in = new TemporaryInputStream(file, this.openStreams);
            return in;
        }

        public void dispose() throws IOException {
            this.close();
            AutoDeletingFile file = this.f;
            if (file != null) {
                while (!this.openStreams.isEmpty()) {
                    Iterator<InputStream> it = this.openStreams.keySet().iterator();
                    while (it.hasNext()) {
                        InputStream in = it.next();
                        in.close();
                        it.remove();
                    }
                }
                file.delete();
                this.f = null;
            }
        }
    }

    private static class TemporaryFileOutputStream
    extends TemporaryOutputStream
    implements IAdaptable {
        private AutoDeletingFile f;
        private final Map<InputStream, InputStream> openStreams;

        public TemporaryFileOutputStream(AutoDeletingFile f) throws FileNotFoundException {
            super(new UnsynchronizedBufferedOutputStream(new FileOutputStream(f.getFile())), null);
            this.f = f;
            this.openStreams = new ConcurrentHashMap<InputStream, InputStream>();
        }

        public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
            if (!this.closed) {
                throw new IOException("The output stream has not been closed yet");
            }
            TemporaryInputStream in = new TemporaryInputStream(this.f, this.openStreams);
            return in;
        }

        public void dispose() throws IOException {
            this.close();
            AutoDeletingFile file = this.f;
            if (file != null) {
                while (!this.openStreams.isEmpty()) {
                    Iterator<InputStream> it = this.openStreams.keySet().iterator();
                    while (it.hasNext()) {
                        InputStream in = it.next();
                        in.close();
                        it.remove();
                    }
                }
                file.delete();
                this.f = null;
            }
        }

        public Object getAdapter(Class adapter) {
            AutoDeletingFile file;
            if (adapter == File.class && (file = this.f) != null) {
                return file.getFile();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TemporaryInputStream
    extends UnsynchronizedBufferedInputStream {
        private AutoDeletingFile f;
        private final Map<InputStream, InputStream> openStreams;

        public TemporaryInputStream(AutoDeletingFile f, Map<InputStream, InputStream> openStreams) throws FileNotFoundException {
            super(new FileInputStream(f.getFile()));
            openStreams.put(this, this);
            this.openStreams = openStreams;
            this.f = f;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.openStreams.remove(this);
            if (this.f != null) {
                this.f = null;
            }
        }
    }

    private static class TemporaryMemoryOutputStream
    extends TemporaryOutputStream {
        public TemporaryMemoryOutputStream(UnsynchronizedByteArrayOutputStream out) {
            super(out, null);
        }

        public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
            if (!this.closed) {
                throw new IOException("The output stream has not been closed yet");
            }
            UnsynchronizedByteArrayOutputStream bout = (UnsynchronizedByteArrayOutputStream)this.out;
            return new UnsynchronizedByteArrayInputStream(bout.getBuffer(), 0, bout.size());
        }
    }
}

