/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import com.ibm.team.repository.common.utils.HashComputingInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class HashCode {
    long hash = 0L;

    public static Checksum createChecksum(InputStream in, long size, IProgressMonitor monitor) throws IOException {
        SubMonitor mon = null;
        FilterInputStream wrapper = null;
        try {
            mon = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
            wrapper = new HashComputingInputStream(in);
            byte[] readInto = new byte[4000];
            int read = 0;
            int total = 0;
            try {
                while (-1 != (read = wrapper.read(readInto))) {
                    total += read;
                    mon.worked(1);
                    if (!mon.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
            finally {
                wrapper.close();
            }
            Checksum checksum = ((HashComputingInputStream)wrapper).getChecksum();
            return checksum;
        }
        finally {
            if (mon != null) {
                mon.done();
            }
            if (wrapper == null) {
                in.close();
            } else {
                wrapper.close();
            }
        }
    }

    public static HashCode createHashCode(InputStream in, long size, IProgressMonitor monitor) throws IOException {
        return new HashCode(HashCode.createChecksum(in, size, monitor));
    }

    public static HashCode createHashCode(InputStream in) throws IOException {
        HashComputingInputStream wrapper = new HashComputingInputStream(in);
        byte[] readInto = new byte[4000];
        int read = 0;
        int total = 0;
        try {
            while (-1 != (read = wrapper.read(readInto))) {
                total += read;
            }
        }
        finally {
            wrapper.close();
        }
        return new HashCode(wrapper.getHash());
    }

    public static Checksum newChecksum() {
        return new Adler32();
    }

    public HashCode(long h) {
        this.hash = h;
    }

    public HashCode(Checksum sum) {
        this.hash = sum.getValue();
    }

    public boolean equalsHash(long otherHash) {
        return this.hash == otherHash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HashCode)) {
            return false;
        }
        HashCode other = (HashCode)o;
        return other.hash == this.hash;
    }

    public String toString() {
        return "HashCode(0x" + Long.toHexString(this.hash) + ")";
    }

    public long getValue() {
        return this.hash;
    }

    public static void writeOnto(HashCode h, DataOutputStream dos) throws IOException {
        if (h == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeLong(h.hash);
        }
    }

    public static HashCode readFrom(DataInputStream dis) throws IOException {
        boolean present = dis.readBoolean();
        if (present) {
            long hash = dis.readLong();
            return new HashCode(hash);
        }
        return null;
    }
}

