/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.internal.util.InternalTeamPlatform;
import com.ibm.team.repository.common.transport.internal.Activator;
import com.ibm.team.repository.common.util.ExtensionRegistryReaderListener;
import com.ibm.team.repository.common.util.IExtensionRegistryReader;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensionRegistryReader<T>
implements IExtensionRegistryReader<T> {
    private static IExtensionRegistryProvider EXTENSION_REGISTRY_PROVIDER;
    private static final Log LOGGER;
    private static final List<IConfigurationElement> NO_CONFIGURATION_ELEMENTS;
    private String pluginId;
    private String extensionPointId;
    private Map<IConfigurationElement, T> descriptorByConfigurationElement;
    private Map<String, List<IConfigurationElement>> configurationElementByBundleSymbolicName;
    private Map<Object, Set<IConfigurationElement>> orphanMap;
    private List<ExtensionRegistryReaderListener<T>> extensionRegistryReaderListeners;
    private IRegistryChangeListener registryChangeListener;
    private BundleListener bundleListener;
    private boolean started;
    private final Object startLock = new Object();
    private final Object eventLock = new Object();
    private final ReadWriteLock listenerLock = new ReentrantReadWriteLock();

    static {
        LOGGER = LogFactory.getLog(ExtensionRegistryReader.class);
        NO_CONFIGURATION_ELEMENTS = Collections.unmodifiableList(new ArrayList(0));
    }

    public static void setExtensionRegistryProvider(IExtensionRegistryProvider provider) {
        EXTENSION_REGISTRY_PROVIDER = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IExtensionRegistryProvider getExtensionRegistryProvider() {
        Class<ExtensionRegistryReader> clazz = ExtensionRegistryReader.class;
        synchronized (ExtensionRegistryReader.class) {
            if (EXTENSION_REGISTRY_PROVIDER == null) {
                EXTENSION_REGISTRY_PROVIDER = ExtensionRegistryReader.createDefaultExtensionRegistryProvider();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return EXTENSION_REGISTRY_PROVIDER;
        }
    }

    private static IExtensionRegistryProvider createDefaultExtensionRegistryProvider() {
        return new IExtensionRegistryProvider(){

            @Override
            public IExtensionRegistry getRegistry() {
                return RegistryFactory.getRegistry();
            }
        };
    }

    protected ExtensionRegistryReader(String pluginId, String extensionPointId) {
        this.setPluginId(pluginId);
        this.setExtensionPointId(extensionPointId);
        this.setDescriptorByConfigurationElement(this.createDescriptorByConfigurationElementMap());
        this.setConfigurationElementByBundleSymbolicName(this.createConfigurationElementByBundleSymbolicNameMap());
        this.setOrphanMap(this.createOrphanMap());
        this.setExtensionRegistryReaderListeners(this.createExtensionRegistryReaderListenersList());
        this.setRegistryChangeListener(this.createRegistryChangeListener());
        this.setBundleListener(this.createBundleListener());
        this.setStarted(false);
        this.initialize();
        this.earlyStart();
    }

    private ArrayList<ExtensionRegistryReaderListener<T>> createExtensionRegistryReaderListenersList() {
        return new ArrayList<ExtensionRegistryReaderListener<T>>(3);
    }

    private Map<Object, Set<IConfigurationElement>> createOrphanMap() {
        int size = this.estimateHashedCollectionSize(5);
        HashMap<Object, Set<IConfigurationElement>> map = new HashMap<Object, Set<IConfigurationElement>>(size);
        return map;
    }

    private Map<String, List<IConfigurationElement>> createConfigurationElementByBundleSymbolicNameMap() {
        int size = this.estimateHashedCollectionSize(75);
        HashMap<String, List<IConfigurationElement>> map = new HashMap<String, List<IConfigurationElement>>(size);
        return map;
    }

    private Map<IConfigurationElement, T> createDescriptorByConfigurationElementMap() {
        int size = this.estimateHashedCollectionSize(75);
        HashMap map = new HashMap(size);
        return map;
    }

    private void addContributedExtensions() {
        List<IConfigurationElement> elements = this.getRegisteredConfigurationElements();
        for (IConfigurationElement element : elements) {
            this.handleExtensionAddedToRegistry(element);
        }
    }

    @Override
    public final void addListener(ExtensionRegistryReaderListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        List<ExtensionRegistryReaderListener<T>> listeners = this.getExtensionRegistryReaderListeners();
        Lock writeLock = this.listenerLock.writeLock();
        writeLock.lock();
        try {
            boolean exists = listeners.contains(listener);
            if (exists) {
                return;
            }
            listeners.add(listener);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphan(IConfigurationElement element) {
        Map<Object, Set<IConfigurationElement>> map = this.getOrphanMap();
        Object key = this.getOrphanKey(element);
        Map<Object, Set<IConfigurationElement>> map2 = map;
        synchronized (map2) {
            Set<IConfigurationElement> orphans = this.getOrphans(key);
            if (orphans == null) {
                int size = this.estimateHashedCollectionSize(5);
                orphans = new HashSet<IConfigurationElement>(size);
                map.put(key, orphans);
            }
            orphans.add(element);
        }
    }

    private final void addRegistryChangeListener(IRegistryChangeListener listener, String filter) {
        IExtensionRegistry registry = this.getRegistry();
        if (registry == null) {
            return;
        }
        registry.addRegistryChangeListener(listener, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicHandleExtensionAdded(IConfigurationElement element) {
        Object lock;
        Object object = lock = this.getEventLock();
        synchronized (object) {
            this.storeConfigurationElementByBundleSymbolicName(element);
            try {
                T descriptor = this.handleExtensionAdded(element);
                this.storeDescriptorByConfigurationElement(element, descriptor);
                this.notifyListenersOfExtensionAdded(element, descriptor);
            }
            catch (Throwable exception) {
                this.logFailedToHandleExtensionAddedToRegistry(element, exception);
            }
        }
    }

    protected final void basicPrintOn(StringBuffer buffer) {
        String value = super.toString();
        int index = value.lastIndexOf(46);
        value = value.substring(index + 1);
        buffer.append(value);
    }

    private void bundleChanged(BundleEvent event) {
        int type = event.getType();
        if (type != 2 && type != 256) {
            return;
        }
        Bundle bundle = event.getBundle();
        List<IConfigurationElement> elements = this.getConfigurationElements(bundle, true);
        if (elements == null) {
            return;
        }
        String bundleSymbolicName = bundle.getSymbolicName();
        List<T> descriptors = this.getDescriptors(elements);
        switch (type) {
            case 2: {
                this.handleBundleWithExtensionsStarted(bundleSymbolicName, elements, descriptors);
                break;
            }
            case 256: {
                this.handleBundleWithExtensionsStopped(bundleSymbolicName, elements, descriptors);
                break;
            }
            default: {
                this.logError(NLS.bind("Unhandled BundleEvent type: {0}", type, new Object[0]));
            }
        }
    }

    protected void checkStarted() {
    }

    private BundleListener createBundleListener() {
        return new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent event) {
                ExtensionRegistryReader.this.bundleChanged(event);
            }
        };
    }

    private IRegistryChangeListener createRegistryChangeListener() {
        return new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                ExtensionRegistryReader.this.handleRegistryChanged(event);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConfigurationElementByBundleSymbolicName(IConfigurationElement element) {
        Map<String, List<IConfigurationElement>> map;
        String bundleSymbolicName = this.getBundleSymbolicName(element);
        Map<String, List<IConfigurationElement>> map2 = map = this.getConfigurationElementByBundleSymbolicName();
        synchronized (map2) {
            List<IConfigurationElement> elements = this.getConfigurationElements(bundleSymbolicName);
            if (elements == null) {
                return;
            }
            elements.remove(element);
            boolean empty = elements.isEmpty();
            if (!empty) {
                return;
            }
            map.remove(bundleSymbolicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDescriptorByConfigurationElement(IConfigurationElement element) {
        Map<IConfigurationElement, T> map;
        Map<IConfigurationElement, T> map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            map.remove(element);
        }
    }

    private final void earlyStart() {
        if (!InternalTeamPlatform.getDefault().asBundle()) {
            this.start();
        }
    }

    protected final int estimateHashedCollectionSize(int capacity) {
        if (capacity <= 0) {
            return 0;
        }
        int size = capacity * 4 / 3 + 1;
        return size;
    }

    private BundleContext getBundleContext() {
        return Activator.getBundleContext();
    }

    private BundleListener getBundleListener() {
        return this.bundleListener;
    }

    private String getBundleSymbolicName(IConfigurationElement element) {
        String bundleSymbolicName = element.getNamespaceIdentifier();
        return bundleSymbolicName;
    }

    private Map<String, List<IConfigurationElement>> getConfigurationElementByBundleSymbolicName() {
        return this.configurationElementByBundleSymbolicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<IConfigurationElement> getConfigurationElements() {
        ArrayList<IConfigurationElement> elements;
        Map<IConfigurationElement, T> map;
        this.checkStarted();
        Map<IConfigurationElement, T> map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            Set<IConfigurationElement> set = map.keySet();
            elements = new ArrayList<IConfigurationElement>(set);
        }
        return elements;
    }

    private List<IConfigurationElement> getConfigurationElements(Bundle bundle, boolean copy) {
        String bundleSymbolicName = bundle.getSymbolicName();
        List<IConfigurationElement> elements = this.getConfigurationElements(bundleSymbolicName, copy);
        return elements;
    }

    private List<IConfigurationElement> getConfigurationElements(String bundleSymbolicName) {
        List<IConfigurationElement> elements = this.getConfigurationElements(bundleSymbolicName, false);
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IConfigurationElement> getConfigurationElements(String bundleSymbolicName, boolean copy) {
        ArrayList elements;
        Map<String, List<IConfigurationElement>> map;
        Map<String, List<IConfigurationElement>> map2 = map = this.getConfigurationElementByBundleSymbolicName();
        synchronized (map2) {
            elements = map.get(bundleSymbolicName);
            if (copy) {
                elements = elements != null ? new ArrayList(elements) : null;
            }
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T getDescriptor(IConfigurationElement element) {
        T descriptor;
        Map<IConfigurationElement, T> map;
        this.checkStarted();
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        Map<IConfigurationElement, T> map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            descriptor = map.get(element);
        }
        return descriptor;
    }

    private Map<IConfigurationElement, T> getDescriptorByConfigurationElement() {
        return this.descriptorByConfigurationElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getDescriptors() {
        ArrayList<T> descriptors;
        Map<IConfigurationElement, T> map;
        this.checkStarted();
        Map<IConfigurationElement, T> map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            Collection<T> keys = map.values();
            descriptors = new ArrayList<T>(keys);
        }
        return descriptors;
    }

    private List<T> getDescriptors(List<IConfigurationElement> elements) {
        int size = elements.size();
        ArrayList<T> descriptors = new ArrayList<T>(size);
        for (IConfigurationElement element : elements) {
            T descriptor = this.getDescriptor(element);
            if (descriptor == null) continue;
            descriptors.add(descriptor);
        }
        descriptors.trimToSize();
        return descriptors;
    }

    private Object getEventLock() {
        return this.eventLock;
    }

    private IExtensionDelta[] getExtensionDeltas(IRegistryChangeEvent event) {
        String pluginId = this.getPluginId();
        String extensionPointId = this.getExtensionPointId();
        IExtensionDelta[] deltas = event.getExtensionDeltas(pluginId, extensionPointId);
        return deltas;
    }

    private String getExtensionPointId() {
        return this.extensionPointId;
    }

    private List<ExtensionRegistryReaderListener<T>> getExtensionRegistryReaderListeners() {
        return this.extensionRegistryReaderListeners;
    }

    protected Object getOrphanKey(IConfigurationElement element) {
        throw new RuntimeException("Subclass responsibility");
    }

    private Map<Object, Set<IConfigurationElement>> getOrphanMap() {
        return this.orphanMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<IConfigurationElement> getOrphans(Object key) {
        Set<IConfigurationElement> orphans;
        Map<Object, Set<IConfigurationElement>> map;
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        Map<Object, Set<IConfigurationElement>> map2 = map = this.getOrphanMap();
        synchronized (map2) {
            orphans = map.get(key);
        }
        return orphans;
    }

    private String getPluginId() {
        return this.pluginId;
    }

    private List<IConfigurationElement> getRegisteredConfigurationElements() {
        IExtensionRegistry useRegistry = this.getRegistry();
        if (useRegistry == null) {
            return NO_CONFIGURATION_ELEMENTS;
        }
        String pluginId = this.getPluginId();
        String extensionPointId = this.getExtensionPointId();
        IExtensionPoint point = useRegistry.getExtensionPoint(pluginId, extensionPointId);
        List<IConfigurationElement> elements = this.getRegisteredConfigurationElements(point);
        return elements;
    }

    private List<IConfigurationElement> getRegisteredConfigurationElements(IExtensionPoint point) {
        if (point == null) {
            return NO_CONFIGURATION_ELEMENTS;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        if (elements == null) {
            return NO_CONFIGURATION_ELEMENTS;
        }
        List<IConfigurationElement> list = Arrays.asList(elements);
        return list;
    }

    private IExtensionRegistry getRegistry() {
        IExtensionRegistryProvider provider = ExtensionRegistryReader.getExtensionRegistryProvider();
        IExtensionRegistry registry = provider.getRegistry();
        return registry;
    }

    private IRegistryChangeListener getRegistryChangeListener() {
        return this.registryChangeListener;
    }

    private Object getStartLock() {
        return this.startLock;
    }

    protected void handleBundleStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<T> descriptors) throws Exception {
    }

    protected void handleBundleStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<T> descriptors) throws Exception {
    }

    private void handleBundleWithExtensionsStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<T> descriptors) {
        try {
            try {
                this.handleBundleStarted(bundleSymbolicName, elements, descriptors);
            }
            catch (Throwable exception) {
                this.logException(exception);
                this.notifyListenersOfBundleStarted(bundleSymbolicName, elements, descriptors);
            }
        }
        finally {
            this.notifyListenersOfBundleStarted(bundleSymbolicName, elements, descriptors);
        }
    }

    private void handleBundleWithExtensionsStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<T> descriptors) {
        try {
            try {
                this.handleBundleStopped(bundleSymbolicName, elements, descriptors);
            }
            catch (Throwable exception) {
                this.logException(exception);
                this.notifyListenersOfBundleStopped(bundleSymbolicName, elements, descriptors);
            }
        }
        finally {
            this.notifyListenersOfBundleStopped(bundleSymbolicName, elements, descriptors);
        }
    }

    protected T handleExtensionAdded(IConfigurationElement element) throws Exception {
        return null;
    }

    private void handleExtensionAddedToRegistry(IConfigurationElement element) {
        boolean orphan = this.isOrphan(element);
        if (orphan) {
            this.addOrphan(element);
            return;
        }
        this.basicHandleExtensionAdded(element);
    }

    protected void handleExtensionRemoved(IConfigurationElement element, T descriptor) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExtensionRemovedFromRegistry(IConfigurationElement element) {
        Object lock;
        Object object = lock = this.getEventLock();
        synchronized (object) {
            block8: {
                T descriptor = this.getDescriptor(element);
                try {
                    try {
                        this.handleExtensionRemoved(element, descriptor);
                        this.notifyListenersOfExtensionRemoved(element, descriptor);
                    }
                    catch (Throwable exception) {
                        this.logFailedToHandleExtensionRemovedFromRegistry(element, exception);
                        this.deleteConfigurationElementByBundleSymbolicName(element);
                        this.deleteDescriptorByConfigurationElement(element);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.deleteConfigurationElementByBundleSymbolicName(element);
                    this.deleteDescriptorByConfigurationElement(element);
                    throw throwable;
                }
                this.deleteConfigurationElementByBundleSymbolicName(element);
                this.deleteDescriptorByConfigurationElement(element);
            }
        }
    }

    private void handleRegistryChanged(int kind, IConfigurationElement element) {
        switch (kind) {
            case 1: {
                this.handleExtensionAddedToRegistry(element);
                break;
            }
            case 2: {
                this.handleExtensionRemovedFromRegistry(element);
                break;
            }
            default: {
                this.logFailedToHandleRegistryChange(kind, element);
            }
        }
    }

    private void handleRegistryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas;
        IExtensionDelta[] iExtensionDeltaArray = deltas = this.getExtensionDeltas(event);
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtensionDelta delta = iExtensionDeltaArray[n2];
            int kind = delta.getKind();
            IExtension extension = delta.getExtension();
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    this.handleRegistryChanged(kind, element);
                }
                catch (Throwable exception) {
                    this.logFailedToHandleRegistryChange(kind, element, exception);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void handleStarted() {
    }

    protected void handleStopped() {
    }

    private void hookupBundleListener() {
        BundleContext context = this.getBundleContext();
        if (context == null) {
            return;
        }
        BundleListener listener = this.getBundleListener();
        context.addBundleListener(listener);
    }

    protected void initialize() {
    }

    protected boolean isOrphan(IConfigurationElement element) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isStarted() {
        Object lock;
        Object object = lock = this.getStartLock();
        synchronized (object) {
            return this.started;
        }
    }

    @Override
    public Iterator<T> iterator() {
        List<T> list = this.getDescriptors();
        Iterator<T> iterator = list.iterator();
        return iterator;
    }

    protected final void logError(String message) {
        this.logError(message, null);
    }

    protected final void logError(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        if (message == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        if (exception == null) {
            LOGGER.error((Object)message);
        } else {
            LOGGER.error((Object)message, exception);
        }
    }

    protected final void logException(Throwable exception) {
        this.logError(null, exception);
    }

    private void logFailedToHandleExtensionAddedToRegistry(IConfigurationElement element, Throwable exception) {
        String pluginId = this.getPluginId();
        String extensionPointId = this.getExtensionPointId();
        IExtension extension = element.getDeclaringExtension();
        String uniqueId = extension.getExtensionPointUniqueIdentifier();
        String pattern = Messages.getServerString("ExtensionRegistryReader.ErrorExtensionAdd");
        String message = NLS.bind(pattern, this, pluginId, extensionPointId, uniqueId);
        this.logError(message, exception);
    }

    private void logFailedToHandleExtensionRemovedFromRegistry(IConfigurationElement element, Throwable exception) {
        String pluginId = this.getPluginId();
        String extensionPointId = this.getExtensionPointId();
        IExtension extension = element.getDeclaringExtension();
        String uniqueId = extension.getExtensionPointUniqueIdentifier();
        String pattern = Messages.getServerString("ExtensionRegistryReader.ErrorExtensionRemove");
        String message = NLS.bind(pattern, this, pluginId, extensionPointId, uniqueId);
        this.logError(message, exception);
    }

    private void logFailedToHandleRegistryChange(int kind, IConfigurationElement element) {
        this.logFailedToHandleRegistryChange(kind, element, null);
    }

    private void logFailedToHandleRegistryChange(int kind, IConfigurationElement element, Throwable exception) {
        String pattern = this.patternForKind(kind);
        String pluginId = this.getPluginId();
        String extensionPointId = this.getExtensionPointId();
        IExtension extension = element.getDeclaringExtension();
        String uniqueId = extension.getExtensionPointUniqueIdentifier();
        String message = NLS.bind(pattern, this, pluginId, extensionPointId, uniqueId);
        this.logError(message, exception);
    }

    private void notifyListenersOfBundleStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<T> descriptors) {
        List<ExtensionRegistryReaderListener<T>> listeners = this.getExtensionRegistryReaderListeners();
        Lock readLock = this.listenerLock.readLock();
        readLock.lock();
        try {
            for (ExtensionRegistryReaderListener<T> listener : listeners) {
                try {
                    listener.handleBundleStarted(bundleSymbolicName, elements, descriptors);
                }
                catch (Throwable exception) {
                    this.logException(exception);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void notifyListenersOfBundleStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<T> descriptors) {
        List<ExtensionRegistryReaderListener<T>> listeners = this.getExtensionRegistryReaderListeners();
        Lock readLock = this.listenerLock.readLock();
        readLock.lock();
        try {
            for (ExtensionRegistryReaderListener<T> listener : listeners) {
                try {
                    listener.handleBundleStopped(bundleSymbolicName, elements, descriptors);
                }
                catch (Throwable exception) {
                    this.logException(exception);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void notifyListenersOfExtensionAdded(IConfigurationElement element, T descriptor) {
        List<ExtensionRegistryReaderListener<T>> listeners = this.getExtensionRegistryReaderListeners();
        Lock readLock = this.listenerLock.readLock();
        readLock.lock();
        try {
            for (ExtensionRegistryReaderListener<T> listener : listeners) {
                try {
                    listener.handleExtensionAdded(element, descriptor);
                }
                catch (Throwable exception) {
                    this.logException(exception);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void notifyListenersOfExtensionRemoved(IConfigurationElement element, T descriptor) {
        List<ExtensionRegistryReaderListener<T>> listeners = this.getExtensionRegistryReaderListeners();
        Lock readLock = this.listenerLock.readLock();
        readLock.lock();
        try {
            for (ExtensionRegistryReaderListener<T> listener : listeners) {
                try {
                    listener.handleExtensionRemoved(element, descriptor);
                }
                catch (Throwable exception) {
                    this.logException(exception);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void printExtensionPointIdOn(StringBuffer buffer) {
        String value = this.getExtensionPointId();
        this.printOn(buffer, "extensionPointId", value);
    }

    private void printNullOn(StringBuffer buffer, String field) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        String pattern = ", %s=null";
        String message = String.format(pattern, field);
        buffer.append(message);
    }

    private void printObjectOn(StringBuffer buffer, String field, Object value) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        String pattern = ", %s=<%s>";
        String message = String.format(pattern, field, value);
        buffer.append(message);
    }

    protected void printOn(StringBuffer buffer) {
        this.basicPrintOn(buffer);
        this.printPluginIdOn(buffer);
        this.printExtensionPointIdOn(buffer);
        this.printStartedOn(buffer);
    }

    protected final void printOn(StringBuffer buffer, String field, boolean value) {
        Boolean wrapper = value ? Boolean.TRUE : Boolean.FALSE;
        this.printOn(buffer, field, wrapper);
    }

    protected final void printOn(StringBuffer buffer, String field, Object value) {
        if (value == null) {
            this.printNullOn(buffer, field);
        } else {
            this.printObjectOn(buffer, field, value);
        }
    }

    protected final void printOn(StringBuffer buffer, String key, String value) {
        if (value == null) {
            this.printNullOn(buffer, key);
        } else {
            this.printStringOnBuffer(buffer, key, value);
        }
    }

    private void printPluginIdOn(StringBuffer buffer) {
        String value = this.getPluginId();
        this.printOn(buffer, "pluginId", value);
    }

    private void printStartedOn(StringBuffer buffer) {
        boolean started = this.isStarted();
        this.printOn(buffer, "started", started);
    }

    private void printStringOnBuffer(StringBuffer buffer, String key, String value) {
        String pattern = ", %s=\"%s\"";
        String message = String.format(pattern, key, value);
        buffer.append(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processOrphans(Object key) {
        Map<Object, Set<IConfigurationElement>> map;
        Map<Object, Set<IConfigurationElement>> map2 = map = this.getOrphanMap();
        synchronized (map2) {
            Set<IConfigurationElement> orphans = this.getOrphans(key);
            if (orphans == null) {
                return;
            }
            for (IConfigurationElement orphan : orphans) {
                this.basicHandleExtensionAdded(orphan);
            }
            map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContributedExtensions() {
        HashMap copy;
        HashMap map;
        HashMap hashMap = map = (HashMap)this.getDescriptorByConfigurationElement();
        synchronized (hashMap) {
            copy = map != null ? new HashMap(map) : null;
        }
        Set elements = copy.keySet();
        for (IConfigurationElement element : elements) {
            this.handleExtensionRemovedFromRegistry(element);
        }
        HashMap hashMap2 = map;
        synchronized (hashMap2) {
            map.clear();
        }
    }

    @Override
    public final void removeListener(ExtensionRegistryReaderListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        List<ExtensionRegistryReaderListener<T>> listeners = this.getExtensionRegistryReaderListeners();
        Lock writeLock = this.listenerLock.writeLock();
        writeLock.lock();
        try {
            listeners.remove(listener);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void removeRegistryChangeListener(IRegistryChangeListener listener) {
        IExtensionRegistry registry = this.getRegistry();
        if (registry == null) {
            return;
        }
        registry.removeRegistryChangeListener(listener);
    }

    private void setBundleListener(BundleListener bundleListener) {
        this.bundleListener = bundleListener;
    }

    private void setConfigurationElementByBundleSymbolicName(Map<String, List<IConfigurationElement>> configurationElementsByBundleSymbolicName) {
        this.configurationElementByBundleSymbolicName = configurationElementsByBundleSymbolicName;
    }

    private void setDescriptorByConfigurationElement(Map<IConfigurationElement, T> descriptorByConfigurationElement) {
        this.descriptorByConfigurationElement = descriptorByConfigurationElement;
    }

    private void setExtensionPointId(String extensionPointId) {
        if (extensionPointId == null) {
            throw new IllegalArgumentException("extensionPointId must not be null");
        }
        this.extensionPointId = extensionPointId;
    }

    private void setExtensionRegistryReaderListeners(List<ExtensionRegistryReaderListener<T>> listeners) {
        this.extensionRegistryReaderListeners = listeners;
    }

    private void setOrphanMap(Map<Object, Set<IConfigurationElement>> orphanMap) {
        this.orphanMap = orphanMap;
    }

    private void setPluginId(String pluginId) {
        if (pluginId == null) {
            throw new IllegalArgumentException("pluginId must not be null");
        }
        this.pluginId = pluginId;
    }

    private void setRegistryChangeListener(IRegistryChangeListener registryChangeListener) {
        this.registryChangeListener = registryChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStarted(boolean started) {
        Object lock;
        Object object = lock = this.getStartLock();
        synchronized (object) {
            this.started = started;
        }
    }

    @Override
    public int size() {
        Map<IConfigurationElement, T> map = this.getDescriptorByConfigurationElement();
        int size = map.size();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Object lock = this.getStartLock();
        IRegistryChangeListener listener = this.getRegistryChangeListener();
        String pluginId = this.getPluginId();
        Object object = lock;
        synchronized (object) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setStarted(true);
            this.addRegistryChangeListener(listener, pluginId);
            this.addContributedExtensions();
            this.hookupBundleListener();
            this.handleStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        Object lock = this.getStartLock();
        IRegistryChangeListener listener = this.getRegistryChangeListener();
        Object object = lock;
        synchronized (object) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.unhookBundleListener();
            this.removeContributedExtensions();
            this.removeRegistryChangeListener(listener);
            this.setStarted(false);
            this.handleStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeConfigurationElementByBundleSymbolicName(IConfigurationElement element) {
        Map<String, List<IConfigurationElement>> map;
        String bundleSymbolicName = this.getBundleSymbolicName(element);
        Map<String, List<IConfigurationElement>> map2 = map = this.getConfigurationElementByBundleSymbolicName();
        synchronized (map2) {
            boolean exists;
            List<IConfigurationElement> elements = this.getConfigurationElements(bundleSymbolicName);
            if (elements == null) {
                elements = new ArrayList<IConfigurationElement>(10);
                map.put(bundleSymbolicName, elements);
            }
            if (exists = elements.contains(element)) {
                return;
            }
            elements.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDescriptorByConfigurationElement(IConfigurationElement element, T descriptor) {
        Map<IConfigurationElement, T> map;
        if (descriptor == null) {
            return;
        }
        Map<IConfigurationElement, T> map2 = map = this.getDescriptorByConfigurationElement();
        synchronized (map2) {
            map.put(element, descriptor);
        }
    }

    private String patternForKind(int kind) {
        String value;
        switch (kind) {
            case 1: {
                value = Messages.getServerString("ExtensionRegistryReader.ErrorExtensionAddedChange");
                break;
            }
            case 2: {
                value = Messages.getServerString("ExtensionRegistryReader.ErrorExtensionRemovedChange");
                break;
            }
            default: {
                value = Messages.getServerString("ExtensionRegistryReader.ErrorExtensionUnknownChange");
            }
        }
        return value;
    }

    public final String toString() {
        String value;
        StringBuffer buffer = new StringBuffer(100);
        try {
            this.printOn(buffer);
            value = buffer.toString();
        }
        catch (Throwable exception) {
            this.logException(exception);
            value = super.toString();
        }
        return value;
    }

    private void unhookBundleListener() {
        BundleContext context = this.getBundleContext();
        if (context == null) {
            return;
        }
        BundleListener listener = this.getBundleListener();
        context.removeBundleListener(listener);
    }

    public static interface IExtensionRegistryProvider {
        public IExtensionRegistry getRegistry();
    }
}

