/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.transport.ComponentConfiguration;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTeamService
implements ITeamService {
    private final Class serviceClass;
    private final ClassLoader serviceClassLoader;
    private final String version;
    private Map<String, Method> methodMap;
    private final List<ComponentConfiguration> componentConfigurations;

    protected AbstractTeamService(Class serviceClass, ClassLoader serviceClassLoader, String version, List<ComponentConfiguration> componentConfigurations) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("serviceClass must not be null");
        }
        if (serviceClassLoader == null) {
            ClassLoader classLoader;
            Thread current = Thread.currentThread();
            serviceClassLoader = classLoader = current.getContextClassLoader();
        }
        this.serviceClass = serviceClass;
        this.serviceClassLoader = serviceClassLoader;
        this.version = version;
        this.componentConfigurations = componentConfigurations;
        this.setMethodMap(this.buildMethodMap());
    }

    private Map<String, Method> buildMethodMap() {
        Class serviceInterfaceClass = this.getServiceClass();
        Method[] methods = serviceInterfaceClass.getMethods();
        int size = this.estimateHashedCollectionSize(methods.length);
        HashMap<String, Method> methodMap = new HashMap<String, Method>(size);
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass != Object.class) {
                String name = method.getName();
                methodMap.put(name, method);
            }
            ++n2;
        }
        return methodMap;
    }

    private int estimateHashedCollectionSize(int capacity) {
        if (capacity <= 0) {
            return 0;
        }
        int size = capacity * 4 / 3 + 1;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Method getMethod(String methodName) {
        Method method;
        Map<String, Method> map;
        Map<String, Method> map2 = map = this.getMethodMap();
        synchronized (map2) {
            method = map.get(methodName);
        }
        return method;
    }

    private Map<String, Method> getMethodMap() {
        return this.methodMap;
    }

    @Override
    public Class getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public List<ComponentConfiguration> getComponentConfigurations() {
        return this.componentConfigurations;
    }

    public Object invokeService(String methodName, Object[] parameters) throws Exception {
        Method method;
        if (methodName == null) {
            throw new IllegalArgumentException("method name may not be null");
        }
        if (parameters == null) {
            parameters = new Object[]{};
        }
        if ((method = this.getMethod(methodName)) == null) {
            String msg = NLS.bind("service class: {0}: method: {1}: not supported", this.getServiceClass().getName(), methodName);
            throw new UnsupportedOperationException(msg);
        }
        Class<?>[] definedParameterTypes = method.getParameterTypes();
        if (definedParameterTypes == null) {
            definedParameterTypes = new Class[]{};
        }
        if (definedParameterTypes.length != parameters.length) {
            throw new UnsupportedOperationException("wrong number of parameters");
        }
        int i = 0;
        while (i < definedParameterTypes.length) {
            if (!definedParameterTypes[i].isAssignableFrom(parameters[i].getClass())) {
                throw new UnsupportedOperationException("wrong types of parameters");
            }
            ++i;
        }
        Object result = method.invoke(this.getImplementation(), parameters);
        return result;
    }

    private void setMethodMap(Map<String, Method> methodMap) {
        this.methodMap = methodMap;
    }

    protected Object thrownAwayResult(Class clazz) {
        if (clazz == Byte.TYPE) {
            return new Byte(0);
        }
        if (clazz == Short.TYPE) {
            return new Short(0);
        }
        if (clazz == Integer.TYPE) {
            return new Integer(0);
        }
        if (clazz == Long.TYPE) {
            return new Long(0L);
        }
        if (clazz == Float.TYPE) {
            return new Float(0.0f);
        }
        if (clazz == Double.TYPE) {
            return new Double(0.0);
        }
        if (clazz == Character.TYPE) {
            return new Character('\u0000');
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        return null;
    }
}

