/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.util.AbstractComponentChildElementDescriptor;
import com.ibm.team.repository.common.internal.util.IServiceElementDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;

class ServiceElementDescriptor
extends AbstractComponentChildElementDescriptor
implements IServiceElementDescriptor {
    private String kindAttribute;

    ServiceElementDescriptor(IConfigurationElement element) {
        super(element, "service");
    }

    protected void checkElement() {
        super.checkElement();
        this.checkKindAttribute();
    }

    private void checkKindAttribute() {
        String value = this.getKindAttribute();
        String[] values = new String[]{"RPC", "MODELLED_REST", "RAW_HTTP", "CONTENT"};
        this.checkAttributeIsLegal(value, "kind", true, values);
    }

    public String getKindAttribute() {
        return this.kindAttribute;
    }

    protected void initialize() {
        super.initialize();
        this.setKindAttribute(this.getAttribute("kind"));
    }

    private void printKindAttributeOn(StringBuffer buffer) {
        String value = this.getKindAttribute();
        this.printOn(buffer, "kind", value);
    }

    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        this.printKindAttributeOn(buffer);
    }

    private void setKindAttribute(String kind) {
        this.kindAttribute = kind;
    }
}

