/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.nls.Messages;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class SafeSimpleDataFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = -8991926238993383097L;
    private static final String RFC3339_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'";
    private static final String FORMAT2 = "yyyy-MM-dd'T'HH:mm:ss'.'SSS";
    private static final String FORMAT3 = "yyyy-MM-dd' 'HH:mm:ss'.'SSS";
    private static final String FORMAT4 = "yyyy-MM-dd'T'HH:mm:ss'.'SSSZ";
    private static final SimpleTimeZone _gmtTimeZoneInternal = new SimpleTimeZone(0, "GMT");
    public static final SimpleDateFormat[] DATE_FORMATS = new SimpleDateFormat[]{new SafeSimpleDataFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'"), new SafeSimpleDataFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS"), new SafeSimpleDataFormat("yyyy-MM-dd' 'HH:mm:ss'.'SSS"), new SafeSimpleDataFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ")};

    protected SafeSimpleDataFormat(String pattern) {
        super(pattern, Locale.ENGLISH);
        this.setTimeZone(_gmtTimeZoneInternal);
    }

    public synchronized Date parse(String source) throws ParseException {
        return new java.sql.Date(super.parse(source).getTime());
    }

    public synchronized StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return super.format((Date)new java.sql.Date(date.getTime()), toAppendTo, fieldPosition);
    }

    public static Date convertStringToDate(String dateAsString) {
        ParseException parseException = null;
        SimpleDateFormat[] simpleDateFormatArray = DATE_FORMATS;
        int n = DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleDateFormat dateFormat = simpleDateFormatArray[n2];
            try {
                return new java.sql.Date(dateFormat.parse(dateAsString).getTime());
            }
            catch (ParseException e) {
                parseException = e;
                ++n2;
            }
        }
        if (parseException != null) {
            throw new RuntimeException(parseException);
        }
        throw new RuntimeException(String.valueOf(Messages.getServerString("SafeSimpleDataFormat.ErrorDateParsing")) + dateAsString);
    }
}

