/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.ItemType;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemStore {
    private final boolean useItemId;
    private final boolean useWeakReferences;
    private final Map<IItemType, Map<UUID, ItemDescriptor>> store;
    private final Object lock;
    private final ReferenceQueue referenceQueue;
    private static final Map<IItemType, Class> proxyClasses = new HashMap<IItemType, Class>();

    public ItemStore(boolean useItemId, boolean useWeakReferences) {
        this.useItemId = useItemId;
        this.useWeakReferences = useWeakReferences;
        this.store = new HashMap<IItemType, Map<UUID, ItemDescriptor>>();
        this.lock = new Object();
        this.referenceQueue = new ReferenceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IItem getItem(IItemHandle itemHandle) {
        Object object = this.lock;
        synchronized (object) {
            this.cleanStore();
            ItemDescriptor itemDescriptor = this.getStore(itemHandle.getItemType()).get(this.getKey(itemHandle));
            if (itemDescriptor != null) {
                return itemDescriptor.getItem();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IItem> getItems(IItemType itemType) {
        Object object = this.lock;
        synchronized (object) {
            this.cleanStore();
            Collection<ItemDescriptor> descriptors = this.getStore(itemType).values();
            ArrayList<IItem> items = new ArrayList<IItem>(descriptors.size());
            for (ItemDescriptor itemDescriptor : descriptors) {
                IItem item;
                if (itemDescriptor == null || (item = itemDescriptor.getItem()) == null) continue;
                items.add(item);
            }
            return Collections.unmodifiableList(items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IItem putItem(IItem item, boolean ignoreStateOrderLogic) {
        Object object = this.lock;
        synchronized (object) {
            this.cleanStore();
            IItemType itemType = item.getItemType();
            UUID key = this.getKey(item);
            IItem storedItem = null;
            ItemDescriptor oldItemDescriptor = this.getStore(itemType).get(key);
            if (oldItemDescriptor != null) {
                storedItem = oldItemDescriptor.getItem();
            }
            boolean newItem = false;
            if (storedItem == null) {
                storedItem = ItemStore.createProxy(item);
                newItem = true;
            }
            Reference newItemDescriptor = this.useWeakReferences ? new WeakItemDescriptor(storedItem) : new SoftItemDescriptor(storedItem);
            this.getStore(itemType).put(key, (ItemDescriptor)((Object)newItemDescriptor));
            if (newItem) {
                this.notifyIncrease(itemType, newItemDescriptor.getSize(), 1L);
                if (this.useItemId) {
                    this.notifyItemChanged(storedItem, null, item);
                }
                return storedItem;
            }
            ItemInvocationHandler invocationHandler = ItemStore.getInvocationHandler(storedItem);
            if (invocationHandler == null) {
                throw new IllegalStateException("stored item must be a proxy");
            }
            IItem storedState = invocationHandler.getDelegate();
            Set storedProperties = ItemStore.getProperties(storedState);
            Set properties = ItemStore.getProperties(item);
            boolean sameState = this.sameState(storedState, item);
            boolean olderState = !ignoreStateOrderLogic && this.olderState(storedState, item);
            boolean biggerOrEqualProperties = ItemStore.contains(properties, storedProperties);
            boolean smallerOrEqualProperties = ItemStore.contains(storedProperties, properties);
            if (biggerOrEqualProperties) {
                if (olderState) {
                    return smallerOrEqualProperties ? storedItem : null;
                }
                if (!sameState || !smallerOrEqualProperties) {
                    invocationHandler.setDelegate(item);
                    long diff = newItemDescriptor.getSize() - oldItemDescriptor.getSize();
                    if (diff > 0L) {
                        this.notifyIncrease(itemType, diff, 1L);
                    } else if (diff < 0L) {
                        this.notifyDecrease(itemType, -diff, 1L);
                    }
                    if (this.useItemId) {
                        this.notifyItemChanged(storedItem, storedState, item);
                    }
                }
                return storedItem;
            }
            if (smallerOrEqualProperties) {
                return sameState || olderState ? storedItem : null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IItem> putItems(List<IItem> items, boolean ignoreStateOrderLogic) {
        Object object = this.lock;
        synchronized (object) {
            this.cleanStore();
            ArrayList<IItem> storedItems = new ArrayList<IItem>(items);
            int index = 0;
            for (IItem item : items) {
                if (item == null) {
                    storedItems.set(index, null);
                } else {
                    storedItems.set(index, this.putItem(item, ignoreStateOrderLogic));
                }
                ++index;
            }
            return storedItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(IItemHandle itemHandle) {
        Object object = this.lock;
        synchronized (object) {
            this.cleanStore();
            ItemDescriptor itemDescriptor = this.getStore(itemHandle.getItemType()).remove(this.getKey(itemHandle));
            if (itemDescriptor != null) {
                this.notifyDecrease(itemDescriptor.getItemType(), itemDescriptor.getSize(), 1L);
                IItem item = itemDescriptor.getItem();
                if (item != null) {
                    ItemInvocationHandler invocationHandler = ItemStore.getInvocationHandler(item);
                    if (invocationHandler == null) {
                        throw new IllegalStateException("stored item must be a proxy");
                    }
                    if (this.useItemId) {
                        this.notifyItemChanged(item, invocationHandler.getDelegate(), null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItems(List<IItemHandle> itemHandles) {
        Object object = this.lock;
        synchronized (object) {
            this.cleanStore();
            for (IItemHandle itemHandle : itemHandles) {
                if (itemHandle == null) continue;
                this.removeItem(itemHandle);
            }
        }
    }

    public static Set getProperties(IItem item) {
        IItem storedItem = item;
        if (storedItem == null) {
            return null;
        }
        ItemInvocationHandler invocationHandler = ItemStore.getInvocationHandler(storedItem);
        if (invocationHandler != null) {
            storedItem = invocationHandler.getDelegate();
        }
        if (storedItem.isComplete()) {
            return null;
        }
        HashSet<String> properties = new HashSet<String>();
        for (String propertyName : ((ItemType)storedItem.getItemType()).propertyNames()) {
            if (!storedItem.isPropertySet(propertyName)) continue;
            properties.add(propertyName);
        }
        return properties;
    }

    public static IItem getImmutableItem(IItem item) {
        ItemInvocationHandler invocationHandler = ItemStore.getInvocationHandler(item);
        if (invocationHandler == null) {
            return null;
        }
        return invocationHandler.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getProperties(IItemHandle itemHandle) {
        Object object = this.lock;
        synchronized (object) {
            ItemDescriptor itemDescriptor = this.getStore(itemHandle.getItemType()).get(this.getKey(itemHandle));
            if (itemDescriptor != null) {
                return ItemStore.getProperties(itemDescriptor.getItem());
            }
            return null;
        }
    }

    protected boolean usesItemId() {
        return this.useItemId;
    }

    protected abstract void notifyItemChanged(IItem var1, IItem var2, IItem var3);

    protected abstract void notifyIncrease(IItemType var1, long var2, long var4);

    protected abstract void notifyDecrease(IItemType var1, long var2, long var4);

    protected abstract boolean statisticsEnabled();

    protected static boolean contains(Set containerProperties, Set containedProperties) {
        if (containerProperties == containedProperties) {
            return true;
        }
        if (containerProperties == null) {
            return true;
        }
        if (containedProperties == null) {
            return false;
        }
        return containerProperties.containsAll(containedProperties);
    }

    protected static Set addAll(Set container, Set contained) {
        if (container == null) {
            return null;
        }
        if (contained == null) {
            return null;
        }
        container.addAll(contained);
        return container;
    }

    private void cleanStore() {
        ItemDescriptor itemDescriptor;
        while ((itemDescriptor = (ItemDescriptor)((Object)this.referenceQueue.poll())) != null) {
            IItemType itemType = itemDescriptor.getItemType();
            UUID key = itemDescriptor.getKey();
            ItemDescriptor currentDescriptor = this.getStore(itemType).get(key);
            if (currentDescriptor == null || currentDescriptor.getItem() != null) continue;
            this.getStore(itemType).remove(key);
            this.notifyDecrease(itemType, currentDescriptor.getSize(), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IItem createProxy(IItem item) {
        if (ItemStore.getInvocationHandler(item) != null) {
            return item;
        }
        IItemType itemType = item.getItemType();
        Class<?> proxyClass = null;
        Map<IItemType, Class> map = proxyClasses;
        synchronized (map) {
            proxyClass = proxyClasses.get(itemType);
            if (proxyClass == null) {
                HashSet allInterfaces = new HashSet();
                Class<?> itemClass = item.getClass();
                while (itemClass != null) {
                    Class<?>[] interfaces = itemClass.getInterfaces();
                    int i = 0;
                    while (i < interfaces.length) {
                        allInterfaces.add(interfaces[i]);
                        ++i;
                    }
                    itemClass = itemClass.getSuperclass();
                }
                proxyClass = Proxy.getProxyClass(item.getClass().getClassLoader(), allInterfaces.toArray(new Class[allInterfaces.size()]));
                proxyClasses.put(itemType, proxyClass);
            }
        }
        try {
            return (IItem)proxyClass.getConstructor(InvocationHandler.class).newInstance(new ItemInvocationHandler(item));
        }
        catch (Exception exception) {
            throw new IllegalStateException("could not create stored item proxy");
        }
    }

    private static ItemInvocationHandler getInvocationHandler(IItem item) {
        if (item instanceof Proxy) {
            return (ItemInvocationHandler)Proxy.getInvocationHandler(item);
        }
        return null;
    }

    private UUID getKey(IItemHandle itemHandle) {
        return this.useItemId ? itemHandle.getItemId() : itemHandle.getStateId();
    }

    private boolean sameState(IItem beforeState, IItem afterState) {
        if (this.useItemId) {
            return beforeState.sameStateId(afterState);
        }
        return true;
    }

    private boolean olderState(IItem beforeState, IItem afterState) {
        if (this.useItemId && beforeState instanceof Auditable) {
            Auditable beforeAuditable = (Auditable)beforeState;
            UUID beforePredecessorStateId = beforeAuditable.getPredecessor();
            if (afterState.getStateId().equals(beforePredecessorStateId)) {
                return true;
            }
        }
        return false;
    }

    private Map<UUID, ItemDescriptor> getStore(IItemType itemType) {
        Map<UUID, ItemDescriptor> map = this.store.get(itemType);
        if (map == null) {
            map = new HashMap<UUID, ItemDescriptor>();
            this.store.put(itemType, map);
        }
        return map;
    }

    private long getSize(IItem item) {
        if (this.statisticsEnabled()) {
            return item.size();
        }
        return 0L;
    }

    private static interface ItemDescriptor {
        public IItem getItem();

        public IItemType getItemType();

        public UUID getKey();

        public long getSize();
    }

    private static class ItemInvocationHandler
    implements InvocationHandler {
        public static Method EQUALS_METHOD;
        public static Method HASH_CODE_METHOD;
        public static Method TO_STRING_METHOD;
        private static final Log log;
        private IItem delegate;

        static {
            log = LogFactory.getLog(ItemInvocationHandler.class);
            try {
                EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
                HASH_CODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
                TO_STRING_METHOD = Object.class.getMethod("toString", new Class[0]);
            }
            catch (SecurityException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        public ItemInvocationHandler(IItem delegate) {
            this.delegate = delegate;
        }

        public IItem getDelegate() {
            return this.delegate;
        }

        public void setDelegate(IItem delegate) {
            this.delegate = delegate;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(EQUALS_METHOD)) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.equals(HASH_CODE_METHOD)) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.equals(TO_STRING_METHOD)) {
                return "Proxy of " + this.delegate.toString();
            }
            try {
                return method.invoke((Object)this.delegate, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    throw cause;
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SoftItemDescriptor
    extends SoftReference<IItem>
    implements ItemDescriptor {
        private final IItemType itemType;
        private final UUID key;
        private final long size;

        public SoftItemDescriptor(IItem item) {
            super(item, ItemStore.this.referenceQueue);
            this.itemType = item.getItemType();
            this.key = ItemStore.this.getKey(item);
            this.size = ItemStore.this.getSize(item);
        }

        @Override
        public IItem getItem() {
            return (IItem)this.get();
        }

        @Override
        public IItemType getItemType() {
            return this.itemType;
        }

        @Override
        public UUID getKey() {
            return this.key;
        }

        @Override
        public long getSize() {
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakItemDescriptor
    extends WeakReference<IItem>
    implements ItemDescriptor {
        private final IItemType itemType;
        private final UUID key;
        private final long size;

        public WeakItemDescriptor(IItem item) {
            super(item, ItemStore.this.referenceQueue);
            this.itemType = item.getItemType();
            this.key = ItemStore.this.getKey(item);
            this.size = ItemStore.this.getSize(item);
        }

        @Override
        public IItem getItem() {
            return (IItem)this.get();
        }

        @Override
        public IItemType getItemType() {
            return this.itemType;
        }

        @Override
        public UUID getKey() {
            return this.key;
        }

        @Override
        public long getSize() {
            return this.size;
        }
    }
}

