/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.internal.util.StandaloneAdapterRegistry;
import com.ibm.team.repository.common.internal.util.StandaloneExtensionRegistry;
import com.ibm.team.repository.common.internal.util.StandaloneFileLocator;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.util.ExtensionReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.IRegistryProvider;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalTeamPlatform {
    private static final InternalTeamPlatform singleton = new InternalTeamPlatform();
    private static final Log logger = LogFactory.getLog(singleton.getClass());
    private static final URL[] EMPTY_URLS = new URL[0];
    private static final String URI = "uri";
    private static final String CLASS = "class";
    private static final String ECORE = "org.eclipse.emf.ecore";
    private static final String PACKAGE = "package";
    private static final String GEN_PACKAGE = "generated_package";
    private static final String EINSTANCE = "eINSTANCE";
    private static final String BUNDLE = "bundle";
    private static final String PATH = "path";
    private StandaloneExtensionRegistry standaloneRegistry;
    private StandaloneFileLocator standaloneFileLocator;
    private StandaloneAdapterRegistry standaloneAdapterRegistry;
    private boolean started = false;
    private boolean asBundle = false;
    private boolean stopped = false;

    private InternalTeamPlatform() {
    }

    public static InternalTeamPlatform getDefault() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean asBundle) {
        InternalTeamPlatform internalTeamPlatform = this;
        synchronized (internalTeamPlatform) {
            if (this.started && asBundle != this.asBundle) {
                throw new IllegalStateException("Already started from a different context. Current context = " + (asBundle ? BUNDLE : "plain java"));
            }
            if (this.started) {
                return;
            }
            this.started = true;
            this.asBundle = asBundle;
            this.initializeDebugOptions();
            if (!asBundle) {
                this.initializeRegistry();
                this.initializeGeneratedPackages();
                this.initializeFileLocator();
                this.initializeAdapterRegistry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        InternalTeamPlatform internalTeamPlatform = this;
        synchronized (internalTeamPlatform) {
            if (this.stopped) {
                throw new IllegalStateException("Already stopped");
            }
            if (!this.asBundle) {
                try {
                    RegistryFactory.setDefaultRegistryProvider(null);
                }
                catch (CoreException coreException) {}
            }
            this.started = false;
            this.asBundle = false;
            this.stopped = true;
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean asBundle() {
        return this.asBundle;
    }

    public IExtensionRegistry getRegistry() {
        if (this.asBundle) {
            return RegistryFactory.getRegistry();
        }
        return this.standaloneRegistry.getRegistry();
    }

    public URL find(String bundleSymbolicName, IPath path, Map<String, String> override) {
        if (this.asBundle) {
            Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
            if (bundle == null) {
                String msg = Messages.getServerString("InternalTeamPlatform.ErrorLocatingBundle");
                InternalTeamPlatform.logWarning(msg, bundleSymbolicName, path);
                return null;
            }
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, override);
            if (url != null) {
                return url;
            }
            String msg = Messages.getServerString("InternalTeamPlatform.ErrorLocatingPath");
            InternalTeamPlatform.logWarning(msg, bundleSymbolicName, path);
            return url;
        }
        return this.standaloneFileLocator.find(bundleSymbolicName, path, override, null);
    }

    public URL[] findAll(String bundleSymbolicName, IPath path, Map<String, String> override) {
        if (this.asBundle) {
            Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
            if (bundle == null) {
                String msg = Messages.getServerString("InternalTeamPlatform.ErrorLocatingBundle");
                InternalTeamPlatform.logWarning(msg, bundleSymbolicName, path);
                return EMPTY_URLS;
            }
            return FileLocator.findEntries((Bundle)bundle, (IPath)path, override);
        }
        ArrayList<URL> multiple = new ArrayList<URL>();
        this.standaloneFileLocator.find(bundleSymbolicName, path, override, multiple);
        return multiple.toArray(new URL[multiple.size()]);
    }

    private static void logWarning(String prefix, String bundleSymbolicName, IPath path) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        String msg = InternalTeamPlatform.messageForFind(prefix, bundleSymbolicName, path);
        IllegalArgumentException e = new IllegalArgumentException(msg);
        logger.debug((Object)e.getMessage(), (Throwable)e);
    }

    private static String messageForFind(String prefix, String bundleSymbolicName, IPath path) {
        String msg = String.format("%s\n  %s: %s\n  %s: %s", prefix, BUNDLE, bundleSymbolicName, PATH, path);
        return msg;
    }

    public IAdapterManager getAdapterManager() {
        if (this.asBundle) {
            return Platform.getAdapterManager();
        }
        return AdapterManager.getDefault();
    }

    private void initializeDebugOptions() {
        String value = null;
        value = this.asBundle ? Platform.getDebugOption((String)"com.ibm.team.repository.client/traceNoCancelableServerCall") : System.getProperty("com.ibm.team.repository.client.traceNoCancelableServerCall");
        boolean TRACE_NON_CANCELABLE_SERVER_CALLS = value != null && value.equalsIgnoreCase("true");
        TeamServiceCallContextImpl.setLogNonCancelableServiceCalls(TRACE_NON_CANCELABLE_SERVER_CALLS);
    }

    private void initializeRegistry() {
        this.standaloneRegistry = new StandaloneExtensionRegistry();
        try {
            RegistryFactory.setDefaultRegistryProvider((IRegistryProvider)this.standaloneRegistry);
        }
        catch (CoreException coreException) {}
    }

    private void initializeFileLocator() {
        this.standaloneFileLocator = new StandaloneFileLocator();
    }

    private void initializeAdapterRegistry() {
        this.standaloneAdapterRegistry = new StandaloneAdapterRegistry();
        this.standaloneAdapterRegistry.start();
    }

    private void initializeGeneratedPackages() {
        ExtensionReader extensionReader = new ExtensionReader(ECORE, GEN_PACKAGE){

            protected boolean handleExtensionAdded(IConfigurationElement element) {
                if (element.getName().equals(InternalTeamPlatform.PACKAGE)) {
                    String packageURI = element.getAttribute(InternalTeamPlatform.URI);
                    String className = element.getAttribute(InternalTeamPlatform.CLASS);
                    if (packageURI != null && className != null) {
                        if (EPackage.Registry.INSTANCE.get((Object)packageURI) != null) {
                            return true;
                        }
                        EPackage ePackage = null;
                        try {
                            Class<?> javaClass = this.getClass().getClassLoader().loadClass(className);
                            Field field = javaClass.getField(InternalTeamPlatform.EINSTANCE);
                            ePackage = (EPackage)field.get(null);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (NoSuchFieldException noSuchFieldException) {}
                        if (ePackage != null) {
                            EPackage.Registry.INSTANCE.put((Object)packageURI, ePackage);
                        }
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean handleExtensionRemoved(IConfigurationElement element) {
                EPackage.Registry map = EPackage.Registry.INSTANCE;
                String key = element.getAttribute(InternalTeamPlatform.URI);
                Object value = null;
                EPackage.Registry registry = map;
                synchronized (registry) {
                    value = map.remove(key);
                }
                boolean valid = value != null;
                return valid;
            }
        };
        extensionReader.earlyStart();
    }
}

