/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.FunctionType;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.NumericScalarFunction;
import com.ibm.team.repository.common.internal.queryast.QueryDataElement;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryModelField;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.query.ast.IInListValueSource;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericField;
import com.ibm.team.repository.common.query.ast.INumericScalarFunction;
import com.ibm.team.repository.common.query.ast.IPredicate;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericField
extends AbstractQueryModelField
implements INumericField {
    private ElementType type;

    public NumericField(IQueryPath aModel, String aName, String classname) {
        this.name(aName);
        this.parent(aModel);
        if (Integer.class.getName().equals(classname)) {
            this.type = ElementType.INT_LITERAL;
        } else if (Long.class.getName().equals(classname)) {
            this.type = ElementType.LONG_LITERAL;
        } else if (BigDecimal.class.getName().equals(classname)) {
            this.type = ElementType.BIG_DECIMAL_LITERAL;
        } else {
            throw new IllegalArgumentException("Unsupported numeric type: " + classname);
        }
    }

    @Override
    public ElementType getFieldType() {
        return this.type;
    }

    @Override
    public IPredicate _in(Number[] numbers) {
        this.checkInPredicateValueArray(numbers);
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(field);
        Number[] numberArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            Number number = numberArray[n2];
            Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(number);
            inList.getValues().add((Object)literal);
            ++n2;
        }
        return inList;
    }

    @Override
    public IPredicate _in(INumeric[] numericArray) {
        this.checkInPredicateValueArray(numericArray);
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(field);
        INumeric[] iNumericArray = numericArray;
        int n = numericArray.length;
        int n2 = 0;
        while (n2 < n) {
            INumeric numeric = iNumericArray[n2];
            this.checkInPredicateNullValue(numeric);
            FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(numeric);
            inList.getValues().add((Object)filterElement);
            ++n2;
        }
        return inList;
    }

    @Override
    public IPredicate _inLargeList(IInListValueSource<Integer> inputSource) {
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(field);
        inList.setInputValueSource(inputSource);
        return inList;
    }

    @Override
    public INumericScalarFunction _abs() {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.ABS_LITERAL);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _mod(INumeric numeric) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.MOD_LITERAL);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(numeric);
        numericScalarFunction.getArgs().add((Object)queryDataElement);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _mod(Integer number) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.MOD_LITERAL);
        Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(number);
        numericScalarFunction.getArgs().add((Object)literal);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _sqrt() {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.SQRT_LITERAL);
        return numericScalarFunction;
    }

    private NumericScalarFunction createNumericScalarFunction(FunctionType functionType) {
        NumericScalarFunction numericScalarFunction = QueryastFactory.eINSTANCE.createNumericScalarFunction(functionType);
        FeaturePath astField = QueryastFactory.eINSTANCE.createFeaturePath(this);
        numericScalarFunction.getArgs().add((Object)astField);
        return numericScalarFunction;
    }

    @Override
    public IPredicate _eq(Number numberToCompare) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, numberToCompare);
    }

    @Override
    public IPredicate _eq(INumeric numeric) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, numeric);
    }

    @Override
    public IPredicate _notEq(Number numberToCompare) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, numberToCompare);
    }

    @Override
    public IPredicate _notEq(INumeric numeric) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, numeric);
    }

    @Override
    public IPredicate _gt(Number numberToCompare) {
        return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, numberToCompare);
    }

    @Override
    public IPredicate _gt(INumeric numeric) {
        return this.createBasicComparison(ComparisonOp.GREATER_THAN_LITERAL, numeric);
    }

    @Override
    public IPredicate _gtOrEq(Number numberToCompare) {
        return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, numberToCompare);
    }

    @Override
    public IPredicate _gtOrEq(INumeric numeric) {
        return this.createBasicComparison(ComparisonOp.GT_OR_EQ_LITERAL, numeric);
    }

    @Override
    public IPredicate _lt(Number numberToCompare) {
        return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, numberToCompare);
    }

    @Override
    public IPredicate _lt(INumeric numeric) {
        return this.createBasicComparison(ComparisonOp.LESS_THAN_LITERAL, numeric);
    }

    @Override
    public IPredicate _ltOrEq(Number numberToCompare) {
        return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, numberToCompare);
    }

    @Override
    public IPredicate _ltOrEq(INumeric numeric) {
        return this.createBasicComparison(ComparisonOp.LT_OR_EQ_LITERAL, numeric);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, Number number) {
        FeaturePath lhsField = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)lhsField, number);
    }

    private IPredicate createBasicComparison(ComparisonOp comparisonOp, INumeric numeric) {
        FeaturePath lhsField = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(comparisonOp, (FilterElement)lhsField, numeric);
    }
}

