/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.queryast.impl;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.queryast.AggregateFunction;
import com.ibm.team.repository.common.internal.queryast.AggregateFunctionType;
import com.ibm.team.repository.common.internal.queryast.AstQuery;
import com.ibm.team.repository.common.internal.queryast.BasicComparison;
import com.ibm.team.repository.common.internal.queryast.BasicComparisonStateExtension;
import com.ibm.team.repository.common.internal.queryast.BinaryConditionalExpression;
import com.ibm.team.repository.common.internal.queryast.BinaryOp;
import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.Count;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.Exists;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.FunctionType;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.InListStateExtension;
import com.ibm.team.repository.common.internal.queryast.InputArg;
import com.ibm.team.repository.common.internal.queryast.IsEmpty;
import com.ibm.team.repository.common.internal.queryast.IsMemberOf;
import com.ibm.team.repository.common.internal.queryast.IsMissing;
import com.ibm.team.repository.common.internal.queryast.IsNull;
import com.ibm.team.repository.common.internal.queryast.IsNullStateExtension;
import com.ibm.team.repository.common.internal.queryast.IsTypeOf;
import com.ibm.team.repository.common.internal.queryast.ItemTypePseudoVariable;
import com.ibm.team.repository.common.internal.queryast.Like;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.Not;
import com.ibm.team.repository.common.internal.queryast.NumericScalarFunction;
import com.ibm.team.repository.common.internal.queryast.OrderBy;
import com.ibm.team.repository.common.internal.queryast.Parens;
import com.ibm.team.repository.common.internal.queryast.Predicate;
import com.ibm.team.repository.common.internal.queryast.QueryDataElement;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.queryast.QueryastPackage;
import com.ibm.team.repository.common.internal.queryast.ScalarFunction;
import com.ibm.team.repository.common.internal.queryast.StringScalarFunction;
import com.ibm.team.repository.common.internal.queryast.impl.AggregateFunctionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.AstQueryImpl;
import com.ibm.team.repository.common.internal.queryast.impl.BasicComparisonImpl;
import com.ibm.team.repository.common.internal.queryast.impl.BasicComparisonStateExtensionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.BinaryConditionalExpressionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.CountImpl;
import com.ibm.team.repository.common.internal.queryast.impl.ExistsImpl;
import com.ibm.team.repository.common.internal.queryast.impl.FeaturePathImpl;
import com.ibm.team.repository.common.internal.queryast.impl.InListImpl;
import com.ibm.team.repository.common.internal.queryast.impl.InListStateExtensionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.InputArgEntryImpl;
import com.ibm.team.repository.common.internal.queryast.impl.InputArgImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsEmptyImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsMemberOfImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsMissingImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsNullImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsNullStateExtensionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IsTypeOfImpl;
import com.ibm.team.repository.common.internal.queryast.impl.ItemTypePseudoVariableImpl;
import com.ibm.team.repository.common.internal.queryast.impl.LikeImpl;
import com.ibm.team.repository.common.internal.queryast.impl.LiteralImpl;
import com.ibm.team.repository.common.internal.queryast.impl.NotImpl;
import com.ibm.team.repository.common.internal.queryast.impl.NumericScalarFunctionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.OrderByImpl;
import com.ibm.team.repository.common.internal.queryast.impl.ParensImpl;
import com.ibm.team.repository.common.internal.queryast.impl.ScalarFunctionImpl;
import com.ibm.team.repository.common.internal.queryast.impl.StringScalarFunctionImpl;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryModelField;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryPathModel;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.internal.util.SafeSimpleDataFormat;
import com.ibm.team.repository.common.query.ast.IEnum;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IFilterElement;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class QueryastFactoryImpl
extends EFactoryImpl
implements QueryastFactory {
    public static QueryastFactory init() {
        try {
            QueryastFactory theQueryastFactory = (QueryastFactory)EPackage.Registry.INSTANCE.getEFactory("com.ibm.team.repository.query");
            if (theQueryastFactory != null) {
                return theQueryastFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new QueryastFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createAstQuery();
            }
            case 1: {
                return this.createBasicComparisonStateExtension();
            }
            case 2: {
                return this.createInListStateExtension();
            }
            case 4: {
                return this.createAggregateFunction();
            }
            case 5: {
                return this.createCount();
            }
            case 6: {
                return this.createFeaturePath();
            }
            case 7: {
                return this.createInputArg();
            }
            case 8: {
                return this.createLiteral();
            }
            case 9: {
                return this.createOrderBy();
            }
            case 10: {
                return this.createScalarFunction();
            }
            case 11: {
                return this.createNumericScalarFunction();
            }
            case 12: {
                return this.createStringScalarFunction();
            }
            case 14: {
                return (EObject)this.createInputArgEntry();
            }
            case 15: {
                return this.createBasicComparison();
            }
            case 16: {
                return this.createBinaryConditionalExpression();
            }
            case 19: {
                return this.createNot();
            }
            case 20: {
                return this.createParens();
            }
            case 21: {
                return this.createInList();
            }
            case 22: {
                return this.createIsEmpty();
            }
            case 23: {
                return this.createIsMemberOf();
            }
            case 24: {
                return this.createIsNull();
            }
            case 25: {
                return this.createIsNullStateExtension();
            }
            case 26: {
                return this.createIsTypeOf();
            }
            case 27: {
                return this.createLike();
            }
            case 31: {
                return this.createIsMissing();
            }
            case 33: {
                return this.createItemTypePseudoVariable();
            }
            case 34: {
                return this.createExists();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 35: {
                return this.createElementTypeFromString(eDataType, initialValue);
            }
            case 36: {
                return this.createComparisonOpFromString(eDataType, initialValue);
            }
            case 37: {
                return this.createBinaryOpFromString(eDataType, initialValue);
            }
            case 38: {
                return this.createFunctionTypeFromString(eDataType, initialValue);
            }
            case 39: {
                return this.createAggregateFunctionTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 35: {
                return this.convertElementTypeToString(eDataType, instanceValue);
            }
            case 36: {
                return this.convertComparisonOpToString(eDataType, instanceValue);
            }
            case 37: {
                return this.convertBinaryOpToString(eDataType, instanceValue);
            }
            case 38: {
                return this.convertFunctionTypeToString(eDataType, instanceValue);
            }
            case 39: {
                return this.convertAggregateFunctionTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public AstQuery createAstQuery() {
        AstQueryImpl astQuery = new AstQueryImpl();
        return astQuery;
    }

    public AggregateFunction createAggregateFunction() {
        AggregateFunctionImpl aggregateFunction = new AggregateFunctionImpl();
        return aggregateFunction;
    }

    public AggregateFunction createAggregateFunction(AggregateFunctionType aggregateFunctionType) {
        AggregateFunction aggregateFunction = this.createAggregateFunction();
        aggregateFunction.setFunction(aggregateFunctionType);
        return aggregateFunction;
    }

    public Count createCount() {
        CountImpl count = new CountImpl();
        count.setFunction(AggregateFunctionType.COUNT_LITERAL);
        return count;
    }

    public FeaturePath createFeaturePath() {
        FeaturePathImpl featurePath = new FeaturePathImpl();
        return featurePath;
    }

    public Count createCount(FeaturePath astField) {
        Count count = this.createCount();
        count.setField(astField);
        count.setFunction(AggregateFunctionType.COUNT_LITERAL);
        return count;
    }

    public Count createCountDistinct(FeaturePath astField, boolean isDistinct) {
        Count count = this.createCount();
        count.setField(astField);
        count.setFunction(AggregateFunctionType.COUNT_LITERAL);
        count.setDistinct(isDistinct);
        return count;
    }

    public FeaturePath createFeaturePath(IField field) {
        AbstractQueryModelField abstractQueryModelField = (AbstractQueryModelField)field;
        FeaturePath astField = this.createFeaturePath(abstractQueryModelField);
        astField.setKind(abstractQueryModelField.getFieldType());
        this.setRoot(astField, abstractQueryModelField);
        return astField;
    }

    private void setRoot(FeaturePath astField, AbstractQueryModelField abstractQueryModelField) {
        AbstractQueryPathModel.Implementation rootImpl = AbstractQueryPathModel.getImplementation(abstractQueryModelField.getRoot());
        astField.setPathRootItemType(rootImpl.getItemType());
    }

    public FeaturePath createFeaturePath(IQueryModel model) {
        AbstractQueryPathModel.Implementation path = AbstractQueryPathModel.getImplementation(model);
        FeaturePath featurePath = this.createFeaturePath();
        featurePath.setPath(path.toPathString());
        featurePath.setKind(ElementType.REFERENCE_LITERAL);
        this.setRoot(featurePath, model);
        return featurePath;
    }

    private void setRoot(FeaturePath astFeature, IQueryModel model) {
        AbstractQueryPathModel.Implementation implementation = AbstractQueryPathModel.getImplementation(model);
        AbstractQueryPathModel.Implementation rootImpl = AbstractQueryPathModel.getImplementation(implementation.getRoot());
        astFeature.setPathRootItemType(rootImpl.getItemType());
    }

    private FeaturePath createFeaturePath(AbstractQueryModelField queryModelField) {
        FeaturePath featurePath = this.createFeaturePath();
        featurePath.setPath(queryModelField.toPathString());
        return featurePath;
    }

    public FilterElement createFilterElement(IFilterElement filterElement) {
        if (filterElement instanceof IField) {
            return this.createFeaturePath((IField)filterElement);
        }
        return (FilterElement)EcoreUtil.copy((EObject)((EObject)filterElement));
    }

    public QueryDataElement createQueryDataElement(IFilterElement filterElement) {
        if (filterElement instanceof IField) {
            return this.createFeaturePath((IField)filterElement);
        }
        return (QueryDataElement)EcoreUtil.copy((EObject)((EObject)filterElement));
    }

    public InputArg createInputArg() {
        InputArgImpl inputArg = new InputArgImpl();
        return inputArg;
    }

    public Literal createLiteral() {
        LiteralImpl literal = new LiteralImpl();
        return literal;
    }

    public Literal createDateTimeLiteral(Date date) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.DATE_TIME_LITERAL);
        literal.setStringValue(SafeSimpleDataFormat.DATE_FORMATS[0].format(date));
        return literal;
    }

    public Literal createStringLiteral(String stringValue) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.STRING_LITERAL);
        literal.setStringValue(stringValue);
        return literal;
    }

    public Literal createNumericLiteral(Number number) {
        Literal literal = this.createLiteral();
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            literal.setKind(ElementType.INT_LITERAL);
        } else if (number instanceof Long) {
            literal.setKind(ElementType.LONG_LITERAL);
        } else if (number instanceof Float || number instanceof Double || number instanceof BigDecimal) {
            literal.setKind(ElementType.BIG_DECIMAL_LITERAL);
        } else {
            throw new IllegalArgumentException("Unsupported literal type: " + number.getClass());
        }
        literal.setStringValue(String.valueOf(number));
        return literal;
    }

    public Literal createUUIDLiteral(UUID uuid) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.UUID_LITERAL);
        literal.setStringValue(uuid.getUuidValue());
        return literal;
    }

    public Literal createBooleanLiteral(Boolean bool) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.BOOLEAN_LITERAL);
        literal.setStringValue(bool != false ? "1" : "0");
        return literal;
    }

    public Literal createItemTypeLiteral(IItemType type) {
        Literal literal = this.createLiteral();
        literal.setKind(ElementType.ITEM_TYPE_LITERAL);
        literal.setStringValue(ItemUtil.itemType2String(type));
        return literal;
    }

    public OrderBy createOrderBy() {
        OrderByImpl orderBy = new OrderByImpl();
        return orderBy;
    }

    public ScalarFunction createScalarFunction() {
        ScalarFunctionImpl scalarFunction = new ScalarFunctionImpl();
        return scalarFunction;
    }

    public NumericScalarFunction createNumericScalarFunction() {
        NumericScalarFunctionImpl numericScalarFunction = new NumericScalarFunctionImpl();
        return numericScalarFunction;
    }

    public NumericScalarFunction createNumericScalarFunction(FunctionType functionType) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction();
        numericScalarFunction.setFunction(functionType);
        return numericScalarFunction;
    }

    public StringScalarFunction createStringScalarFunction() {
        StringScalarFunctionImpl stringScalarFunction = new StringScalarFunctionImpl();
        return stringScalarFunction;
    }

    public StringScalarFunction createStringScalarFunction(FunctionType functionType) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction();
        stringScalarFunction.setFunction(functionType);
        return stringScalarFunction;
    }

    public Map.Entry createInputArgEntry() {
        InputArgEntryImpl inputArgEntry = new InputArgEntryImpl();
        return inputArgEntry;
    }

    public BinaryConditionalExpression createBinaryConditionalExpression() {
        BinaryConditionalExpressionImpl binaryConditionalExpression = new BinaryConditionalExpressionImpl();
        return binaryConditionalExpression;
    }

    public BinaryConditionalExpression createBinaryConditionalExpression(Predicate lhs, BinaryOp binaryOp, Predicate rhs) {
        BinaryConditionalExpression binaryConditionalExpression = this.createBinaryConditionalExpression();
        binaryConditionalExpression.setLhs(lhs);
        binaryConditionalExpression.setRhs(rhs);
        binaryConditionalExpression.setOperator(binaryOp);
        return binaryConditionalExpression;
    }

    public BasicComparison createBasicComparison() {
        BasicComparisonImpl basicComparison = new BasicComparisonImpl();
        return basicComparison;
    }

    public BasicComparisonStateExtension createBasicComparisonStateExtension() {
        BasicComparisonStateExtensionImpl basicComparison = new BasicComparisonStateExtensionImpl();
        return basicComparison;
    }

    private IPredicate createComparisonPredicate(ComparisonOp comparisonOp, FilterElement lhsElement, FilterElement rhsElement) {
        BasicComparison basicComparison = this.createBasicComparison();
        basicComparison.setOperator(comparisonOp);
        basicComparison.setLhs(lhsElement);
        basicComparison.setRhs(rhsElement);
        return basicComparison;
    }

    public IPredicate createBasicComparisonStateExtension(ComparisonOp comparisonOp, FilterElement aKey, FilterElement lhsElement, FilterElement rhsElement) {
        BasicComparisonStateExtension basicComparison = this.createBasicComparisonStateExtension();
        basicComparison.setOperator(comparisonOp);
        basicComparison.setKey(aKey);
        basicComparison.setLhs(lhsElement);
        basicComparison.setRhs(rhsElement);
        return basicComparison;
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filter, IFilterElement rhsElement) {
        FilterElement rhsFilterElement = this.createFilterElement(rhsElement);
        return this.createComparisonPredicate(comparisonOp, filter, rhsFilterElement);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filter, Date dateToCompare) {
        Literal rhsLiteral = this.createDateTimeLiteral(dateToCompare);
        return this.createBasicComparison(comparisonOp, filter, rhsLiteral);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filter, Number number) {
        Literal rhsLiteral = this.createNumericLiteral(number);
        return this.createComparisonPredicate(comparisonOp, filter, rhsLiteral);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filter, String stringToCompare) {
        Literal rhsLiteral = this.createStringLiteral(stringToCompare);
        return this.createComparisonPredicate(comparisonOp, filter, rhsLiteral);
    }

    public IPredicate createBasicComparisonStateExtension(ComparisonOp comparisonOp, FilterElement aKey, FilterElement filter, String stringToCompare) {
        Literal rhsLiteral = this.createStringLiteral(stringToCompare);
        return this.createBasicComparisonStateExtension(comparisonOp, aKey, filter, rhsLiteral);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filter, UUID uuidToCompare) {
        Literal rhsLiteral = this.createUUIDLiteral(uuidToCompare);
        return this.createComparisonPredicate(comparisonOp, filter, rhsLiteral);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filter, IEnum enumVal) {
        FilterElement rhsFilterElement = this.createFilterElement(enumVal);
        return this.createComparisonPredicate(comparisonOp, filter, rhsFilterElement);
    }

    public IPredicate createBasicComparison(ComparisonOp comparisonOp, FilterElement filter, Boolean boolVal) {
        Literal rhsLiteral = this.createBooleanLiteral(boolVal);
        return this.createComparisonPredicate(comparisonOp, filter, rhsLiteral);
    }

    public Not createNot() {
        NotImpl not = new NotImpl();
        return not;
    }

    public Not createNot(Predicate predicate) {
        Not not = this.createNot();
        not.setPredicate(predicate);
        return not;
    }

    public Parens createParens() {
        ParensImpl parens = new ParensImpl();
        return parens;
    }

    public Parens createParens(Predicate predicate) {
        Parens parens = this.createParens();
        parens.setPredicate(predicate);
        return parens;
    }

    public InList createInList() {
        InListImpl inList = new InListImpl();
        return inList;
    }

    public InListStateExtension createInListStateExtension() {
        InListStateExtensionImpl inList = new InListStateExtensionImpl();
        return inList;
    }

    public IsEmpty createIsEmpty() {
        IsEmptyImpl isEmpty = new IsEmptyImpl();
        return isEmpty;
    }

    public IsMemberOf createIsMemberOf() {
        IsMemberOfImpl isMemberOf = new IsMemberOfImpl();
        return isMemberOf;
    }

    public IsNull createIsNull() {
        IsNullImpl isNull = new IsNullImpl();
        return isNull;
    }

    public IsNullStateExtension createIsNullStateExtension() {
        IsNullStateExtensionImpl isNull = new IsNullStateExtensionImpl();
        return isNull;
    }

    public IsTypeOf createIsTypeOf() {
        IsTypeOfImpl isTypeOf = new IsTypeOfImpl();
        return isTypeOf;
    }

    public Like createLike() {
        LikeImpl like = new LikeImpl();
        return like;
    }

    public IsMissing createIsMissing() {
        IsMissingImpl isMissing = new IsMissingImpl();
        return isMissing;
    }

    public ItemTypePseudoVariable createItemTypePseudoVariable() {
        ItemTypePseudoVariableImpl itemTypePseudoVariable = new ItemTypePseudoVariableImpl();
        return itemTypePseudoVariable;
    }

    public Exists createExists() {
        ExistsImpl exists = new ExistsImpl();
        return exists;
    }

    public ElementType createElementTypeFromString(EDataType eDataType, String initialValue) {
        ElementType result = ElementType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertElementTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ComparisonOp createComparisonOpFromString(EDataType eDataType, String initialValue) {
        ComparisonOp result = ComparisonOp.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertComparisonOpToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public BinaryOp createBinaryOpFromString(EDataType eDataType, String initialValue) {
        BinaryOp result = BinaryOp.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertBinaryOpToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public FunctionType createFunctionTypeFromString(EDataType eDataType, String initialValue) {
        FunctionType result = FunctionType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFunctionTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public AggregateFunctionType createAggregateFunctionTypeFromString(EDataType eDataType, String initialValue) {
        AggregateFunctionType result = AggregateFunctionType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertAggregateFunctionTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public QueryastPackage getQueryastPackage() {
        return (QueryastPackage)this.getEPackage();
    }

    @Deprecated
    public static QueryastPackage getPackage() {
        return QueryastPackage.eINSTANCE;
    }
}

