/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.queryast.impl;

import com.ibm.team.repository.common.internal.queryast.OrderBy;
import com.ibm.team.repository.common.internal.queryast.SelectionElement;
import com.ibm.team.repository.common.internal.queryast.impl.AstQueryImpl;
import com.ibm.team.repository.common.internal.queryast.impl.FeaturePathImpl;
import com.ibm.team.repository.common.internal.queryast.impl.IQueryStringTransform;
import java.util.Iterator;

public class AstQueryStringTransform
implements IQueryStringTransform {
    static final String ERROR_OCCURRED_CREATING_PRINT_STRING = "<error occurred here>";
    private AstQueryImpl fAstQuery;

    public AstQueryStringTransform(AstQueryImpl astQuery) {
        this.query(astQuery);
    }

    private void query(AstQueryImpl q) {
        this.fAstQuery = q;
    }

    private AstQueryImpl query() {
        return this.fAstQuery;
    }

    public String toJavaString() {
        StringBuffer b = new StringBuffer();
        try {
            this.addCreateRoot(b);
            this.addCreateQuery(b);
            if (this.query().isDistinct()) {
                b.append("\nq.distinct();");
            }
            this.addCreateSelectList(b);
            this.addCreateFilter(b);
            this.addCreateOrderBys(b);
            this.addCreateGroupBys(b);
        }
        catch (Exception exception) {
            b.append(ERROR_OCCURRED_CREATING_PRINT_STRING);
        }
        return b.toString();
    }

    public String toDynamicJavaString() {
        StringBuffer b = new StringBuffer();
        try {
            this.addCreateDynamicRoot(b);
            this.addCreateDynamicQuery(b);
            if (this.query().isDistinct()) {
                b.append("\nq.distinct();");
            }
            this.addCreateDynamicSelectList(b);
            this.addCreateDynamicFilter(b);
            this.addCreateDynamicOrderBys(b);
            this.addCreateDynamicGroupBys(b);
        }
        catch (Exception exception) {
            b.append(ERROR_OCCURRED_CREATING_PRINT_STRING);
        }
        return b.toString();
    }

    private void addCreateOrderBys(StringBuffer b) {
        for (OrderBy each : this.query().getOrderBys()) {
            if (each.isUsingLocale()) {
                if (each.isAsc()) {
                    b.append("\nq.orderByAscUsingLocale(");
                } else {
                    b.append("\nq.orderByDscUsingLocale(");
                }
            } else if (each.isAsc()) {
                b.append("\nq.orderByAsc(");
            } else {
                b.append("\nq.orderByDsc(");
            }
            each.getField().toJavaStringOn(b);
            b.append(");");
        }
    }

    private void addCreateDynamicOrderBys(StringBuffer b) {
        for (OrderBy each : this.query().getOrderBys()) {
            if (each.isUsingLocale()) {
                if (each.isAsc()) {
                    b.append("\nq.orderByAscUsingLocale(");
                } else {
                    b.append("\nq.orderByDscUsingLocale(");
                }
            } else if (each.isAsc()) {
                b.append("\nq.orderByAsc(");
            } else {
                b.append("\nq.orderByDsc(");
            }
            each.getField().toDynamicJavaStringOn(b);
            b.append(");");
        }
    }

    private void addCreateGroupBys(StringBuffer b) {
        Iterator it = this.query().getGroupBys().iterator();
        while (it.hasNext()) {
            b.append("\nq.groupBy(");
            ((SelectionElement)it.next()).toJavaStringOn(b);
            b.append(");");
        }
        if (this.query().getHaving() != null) {
            b.append("\nq.having(");
            this.query().getHaving().toJavaStringOn(b);
            b.append(");");
        }
    }

    private void addCreateDynamicGroupBys(StringBuffer b) {
        Iterator it = this.query().getGroupBys().iterator();
        while (it.hasNext()) {
            b.append("\nq.groupBy(");
            ((SelectionElement)it.next()).toDynamicJavaStringOn(b);
            b.append(");");
        }
        if (this.query().getHaving() != null) {
            b.append("\nq.having(");
            this.query().getHaving().toDynamicJavaStringOn(b);
            b.append(");");
        }
    }

    private void addCreateSelectList(StringBuffer b) {
        Iterator it = this.query().getSelectList().iterator();
        while (it.hasNext()) {
            b.append("\nq.select(");
            ((SelectionElement)it.next()).toJavaStringOn(b);
            b.append(");");
        }
    }

    private void addCreateDynamicSelectList(StringBuffer b) {
        Iterator it = this.query().getSelectList().iterator();
        while (it.hasNext()) {
            b.append("\nq.select(");
            ((SelectionElement)it.next()).toDynamicJavaStringOn(b);
            b.append(");");
        }
    }

    private void addCreateFilter(StringBuffer b) {
        if (this.query().getFilter() == null) {
            return;
        }
        b.append("\nq.filter(");
        this.query().getFilter().toJavaStringOn(b);
        b.append(");");
    }

    private void addCreateDynamicFilter(StringBuffer b) {
        if (this.query().getFilter() == null) {
            return;
        }
        b.append("\nq.filter(");
        this.query().getFilter().toDynamicJavaStringOn(b);
        b.append(");");
    }

    private void addCreateQuery(StringBuffer b) {
        b.append("\nAstQuery q = (AstQuery) ");
        if (this.query().getSelectList().isEmpty()) {
            b.append("IItem");
        } else {
            b.append("IData");
        }
        b.append("Query.FACTORY.newInstance(r");
        if (this.query().getTargetPath() != null) {
            b.append(".");
            ((FeaturePathImpl)this.query().getTargetPath()).toJavaString(b, null);
        }
        b.append(");");
    }

    private void addCreateDynamicQuery(StringBuffer b) {
        if (this.query().getSelectList().isEmpty()) {
            b.append("\nIItemQuery q = IItemQuery");
        } else {
            b.append("\nIDataQuery q = IDataQuery");
        }
        b.append(".FACTORY.newInstance(");
        if (this.query().getSelectList().isEmpty()) {
            b.append("(IDynamicItemQueryModel) ");
        }
        b.append("d");
        if (this.query().getTargetPath() != null) {
            b.append(".");
            ((FeaturePathImpl)this.query().getTargetPath()).toDynamicJavaStringOn(b, null);
        }
        b.append(");");
    }

    private void addCreateRoot(StringBuffer b) {
        String qm = "QueryModel";
        String aRootName = this.query().getRootItemType().getName();
        b.append("\n").append(aRootName).append(qm).append(" r = ").append(aRootName).append(qm).append(".ROOT").append(";");
    }

    private void addCreateDynamicRoot(StringBuffer b) {
        b.append("IDynamicQueryModel d = ItemUtil.itemTypeFor(").append("\"").append(this.query().getRootItemType().getName()).append("\"").append(", ").append("\"").append(this.query().getRootNsURI()).append("\"").append(").getQueryModel();");
    }
}

