/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class UUID
implements Comparable {
    private static char[] LASTCHAR_DIGITS = new char[]{'A', 'Q', 'g', 'w'};
    private long msb;
    private long lsb;
    private static final char[] BASE64_DIGITS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private static final char UUID_STARTS_WITH;
    private static final int UUID_CHAR_LENGTH;
    private static final char MAX_UUID_CHAR;
    private static final int[] DIGIT_MAP;
    private static final int[] LASTCHAR_DIGIT_MAP;

    static {
        UUID.sortCharArray(BASE64_DIGITS);
        UUID.sortCharArray(LASTCHAR_DIGITS);
        UUID_STARTS_WITH = (char)95;
        UUID_CHAR_LENGTH = 23;
        MAX_UUID_CHAR = (char)128;
        DIGIT_MAP = UUID.computeInverseMap(BASE64_DIGITS);
        LASTCHAR_DIGIT_MAP = UUID.computeInverseMap(LASTCHAR_DIGITS);
    }

    public static UUID generate() {
        return UUID.createFrom(EcoreUtil.generateUUID().toCharArray());
    }

    public static UUID valueOf(String uuidValue) {
        if (uuidValue == null) {
            throw new IllegalArgumentException("null UUID");
        }
        char[] trimmedValue = uuidValue.trim().toCharArray();
        if (!UUID.validateUUID(trimmedValue)) {
            throw new IllegalArgumentException(String.format("invalid UUID [%s]", uuidValue));
        }
        return UUID.createFrom(trimmedValue);
    }

    private static UUID createFrom(char[] trimmedValue) {
        long nextBits;
        char next;
        long msb = 0L;
        int idx = 1;
        while (idx < 11) {
            next = trimmedValue[idx];
            nextBits = DIGIT_MAP[next];
            msb <<= 6;
            msb |= nextBits;
            ++idx;
        }
        next = trimmedValue[11];
        nextBits = DIGIT_MAP[next];
        msb <<= 4;
        msb |= nextBits >> 2;
        long lsb = nextBits & 3L;
        int idx2 = 12;
        while (idx2 < 22) {
            next = trimmedValue[idx2];
            nextBits = DIGIT_MAP[next];
            lsb <<= 6;
            lsb |= nextBits;
            ++idx2;
        }
        next = trimmedValue[22];
        nextBits = LASTCHAR_DIGIT_MAP[next];
        lsb <<= 2;
        return new UUID(msb, lsb |= nextBits);
    }

    public int hashCode() {
        return (int)(this.msb ^ this.lsb ^ this.msb >> 32 ^ this.lsb >> 32);
    }

    public String getUuidValue() {
        char[] result = new char[UUID_CHAR_LENGTH];
        result[0] = 95;
        long lsb = this.lsb;
        result[22] = LASTCHAR_DIGITS[(int)(lsb & 3L)];
        lsb >>>= 2;
        int i = 21;
        while (i >= 12) {
            result[i] = BASE64_DIGITS[(int)(lsb & 0x3FL)];
            lsb >>>= 6;
            --i;
        }
        long msb = this.msb;
        result[11] = BASE64_DIGITS[(int)(lsb | (msb & 0xFL) << 2)];
        msb >>>= 4;
        int i2 = 10;
        while (i2 != 0) {
            result[i2] = BASE64_DIGITS[(int)(msb & 0x3FL)];
            msb >>>= 6;
            --i2;
        }
        return new String(result);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UUID)) {
            return false;
        }
        UUID uuid = (UUID)obj;
        return this.msb == uuid.msb && this.lsb == uuid.lsb;
    }

    public int compareTo(Object o) {
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            int result = this.unsignedCompare(this.msb, uuid.msb);
            if (result == 0) {
                return this.unsignedCompare(this.lsb, uuid.lsb);
            }
            return result;
        }
        return 1;
    }

    private int unsignedCompare(long l1, long l2) {
        if (l1 == l2) {
            return 0;
        }
        long msb1 = l1 >>> 32;
        long msb2 = l2 >>> 32;
        if (msb1 == msb2) {
            long lsb1 = l1 & 0xFFFFFFFFFFFFFFFFL;
            long lsb2 = l2 & 0xFFFFFFFFFFFFFFFFL;
            return lsb1 < lsb2 ? -1 : 1;
        }
        return msb1 < msb2 ? -1 : 1;
    }

    public String toString() {
        return String.format("[UUID %s]", this.getUuidValue());
    }

    private static boolean validateUUID(char[] possibleUUID) {
        int len = possibleUUID.length;
        if (len != UUID_CHAR_LENGTH) {
            return false;
        }
        char[] uuidChars = possibleUUID;
        if (uuidChars[0] != UUID_STARTS_WITH) {
            return false;
        }
        int i = 0;
        while (i < len) {
            char c = uuidChars[i];
            if (c > MAX_UUID_CHAR || DIGIT_MAP[c] == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private UUID(long msb, long lsb) {
        this.msb = msb;
        this.lsb = lsb;
    }

    private static int[] computeInverseMap(char[] digits) {
        int[] digitMap = new int[MAX_UUID_CHAR + '\u0001'];
        int i = 0;
        while (i < digitMap.length) {
            digitMap[i] = -1;
            ++i;
        }
        i = 0;
        while (i < digits.length) {
            char c = digits[i];
            if (c > MAX_UUID_CHAR) {
                throw new IllegalStateException();
            }
            digitMap[c] = i++;
        }
        return digitMap;
    }

    private static void sortCharArray(char[] toSort) {
        ArrayList<Character> digitList = new ArrayList<Character>();
        int i = 0;
        while (i < toSort.length) {
            char next = toSort[i];
            digitList.add(Character.valueOf(next));
            ++i;
        }
        Collections.sort(digitList);
        int idx = 0;
        for (Character next : digitList) {
            toSort[idx] = next.charValue();
            ++idx;
        }
    }
}

