/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.toolkit.mstest;

import com.ibm.team.build.internal.parser.data.JUnitParserFailureData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestCaseData;
import com.ibm.team.build.internal.parser.data.JUnitParserTestSuiteData;
import com.ibm.team.build.internal.toolkit.unit.UnitParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MSTestParser
extends UnitParser {
    private static final String TIMES_QNAME = "Times";
    private static final String TESTRUNCONFIGURATION_QNAME = "TestRunConfiguration";
    private static final String COUNTERS_QNAME = "Counters";
    private static final String TESTMETHOD_QNAME = "TestMethod";
    private static final String UNITTESTRESULT_QNAME = "UnitTestResult";
    private static final String EXECUTION_QNAME = "Execution";
    private static final String MESSAGE_QNAME = "Message";
    private static final String STACKTRACE_QNAME = "StackTrace";
    private static final String CLASSNAME_ATTNAME = "className";
    private static final String ID_ATTNAME = "id";
    private static final String NAME_ATTNAME = "name";
    private static final String ERROR_ATTNAME = "error";
    private static final String FAILED_ATTNAME = "failed";
    private static final String TIMEOUT_ATTNAME = "timeout";
    private static final String EXECUTIONID_ATTNAME = "executionId";
    private static final String TESTNAME_ATTNAME = "testName";
    private static final String START_ATTNAME = "start";
    private static final String FINISH_ATTNAME = "finish";
    private static final String STARTTIME_ATTNAME = "startTime";
    private static final String ENDTIME_ATTNAME = "endTime";
    private DateFormat fDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
    private Map<String, String> tests = new HashMap<String, String>();
    private List<JUnitParserTestCaseData> testCases = new LinkedList<JUnitParserTestCaseData>();
    private String id;
    private String fTestSuiteName;
    private int fErrors;
    private int fFailed;
    private long fTimeTaken;
    private int fOrdinal = 1;
    private JUnitParserTestSuiteData[] testSuites;
    private JUnitParserTestCaseData fCurrentTestCase;
    private JUnitParserFailureData fCurrentFailureData;
    private StringBuilder builder;

    public JUnitParserTestSuiteData[] getTestSuites() {
        return this.testSuites;
    }

    public void parse(InputStream inputStream) throws IOException, SAXException {
        this.testSuites = new JUnitParserTestSuiteData[1];
        super.parse(inputStream);
    }

    private String getTimeString(String string) {
        int dotIndex = (string = string.replace('T', ' ')).lastIndexOf(46);
        if (dotIndex == -1) {
            string = String.valueOf(string) + ".000+0000";
        } else {
            int tzIndex = string.indexOf(43, dotIndex + 1);
            if (tzIndex == -1) {
                tzIndex = string.indexOf(45, dotIndex + 1);
            }
            if (tzIndex == -1) {
                tzIndex = string.length();
                string = String.valueOf(string) + "+0000";
            }
            if (tzIndex - dotIndex > 4) {
                string = String.valueOf(string.substring(0, dotIndex + 4)) + string.substring(tzIndex);
            }
        }
        return string;
    }

    private long getDuration(Attributes attributes, String startAttributeName, String endAttributeName) {
        long end;
        long start;
        block3: {
            try {
                start = this.parseDate(attributes, startAttributeName);
                end = this.parseDate(attributes, endAttributeName);
                if (start != -1L && end != -1L) break block3;
                return 0L;
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
        return end - start;
    }

    private long parseDate(Attributes attributes, String startAttributeName) throws ParseException {
        String string = attributes.getValue(startAttributeName);
        if (string == null) {
            return -1L;
        }
        return this.fDateFormat.parse(this.getTimeString(string)).getTime();
    }

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals(TIMES_QNAME)) {
            this.fTimeTaken = this.getDuration(attributes, START_ATTNAME, FINISH_ATTNAME);
        } else if (name.equals(TESTRUNCONFIGURATION_QNAME)) {
            this.fTestSuiteName = attributes.getValue(NAME_ATTNAME);
        } else if (name.equals(COUNTERS_QNAME)) {
            this.fErrors = Integer.parseInt(attributes.getValue(ERROR_ATTNAME));
            this.fFailed = Integer.parseInt(attributes.getValue(FAILED_ATTNAME));
            this.fFailed += Integer.parseInt(attributes.getValue(TIMEOUT_ATTNAME));
        } else if (name.equals(EXECUTION_QNAME)) {
            this.id = attributes.getValue(ID_ATTNAME);
        } else if (name.equals(TESTMETHOD_QNAME)) {
            String className = attributes.getValue(CLASSNAME_ATTNAME);
            className = className.substring(0, className.indexOf(44));
            this.tests.put(this.id, className);
        } else if (name.equals(UNITTESTRESULT_QNAME)) {
            String className = this.tests.get(attributes.getValue(EXECUTIONID_ATTNAME));
            String testName = attributes.getValue(TESTNAME_ATTNAME);
            this.fCurrentTestCase = new JUnitParserTestCaseData(testName, className, this.getDuration(attributes, STARTTIME_ATTNAME, ENDTIME_ATTNAME));
            this.testCases.add(this.fCurrentTestCase);
            ++this.fOrdinal;
        } else if (name.equals(MESSAGE_QNAME) || name.equals(STACKTRACE_QNAME)) {
            this.builder = new StringBuilder();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.builder != null) {
            this.builder.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals(MESSAGE_QNAME)) {
            this.fCurrentFailureData = new JUnitParserFailureData(this.builder.toString(), "");
            this.fCurrentTestCase.setFailureData(this.fCurrentFailureData);
            this.builder = null;
        } else if (name.equals(STACKTRACE_QNAME)) {
            this.fCurrentFailureData.setStackTrace(this.builder.toString());
            this.builder = null;
        }
    }

    public void endDocument() throws SAXException {
        this.testSuites[0] = new JUnitParserTestSuiteData(this.fTestSuiteName, this.testCases.size(), this.fFailed, this.fErrors, this.fTimeTaken);
        for (JUnitParserTestCaseData testCase : this.testCases) {
            this.testSuites[0].addTestCase(testCase);
        }
        this.fOrdinal = 1;
    }
}

