/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.parser.data;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.parser.data.JdtParserProblemData;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdtParserSourceData {
    private final String fClassName;
    private final String fPackageName;
    private final String fPath;
    private List<JdtParserProblemData> fWarnings = new LinkedList<JdtParserProblemData>();
    private List<JdtParserProblemData> fErrors = new LinkedList<JdtParserProblemData>();
    private List<String> fClassfileNames = new LinkedList<String>();

    public JdtParserSourceData(String className, String packageName, String path) {
        ValidationHelper.validateNotEmpty((String)"className", (String)className);
        ValidationHelper.validateNotNull((String)"packageName", (Object)packageName);
        ValidationHelper.validateNotEmpty((String)"path", (String)path);
        this.fClassName = className;
        this.fPackageName = packageName;
        this.fPath = path;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public String getPackageName() {
        return this.fPackageName;
    }

    public String getPath() {
        return this.fPath;
    }

    public void addProblem(JdtParserProblemData problem) {
        ValidationHelper.validateNotNull((String)"problem", (Object)problem);
        if (problem.getSeverity() == JdtParserProblemData.Severity.ERROR) {
            this.fErrors.add(problem);
        } else {
            this.fWarnings.add(problem);
        }
    }

    public void addClassfileName(String classfileName) {
        ValidationHelper.validateNotNull((String)"classfileName", (Object)classfileName);
        this.fClassfileNames.add(classfileName);
    }

    public String[] getClassfileNames() {
        return this.fClassfileNames.toArray(new String[this.fClassfileNames.size()]);
    }

    public Collection<JdtParserProblemData> getWarnings() {
        return this.fWarnings;
    }

    public Collection<JdtParserProblemData> getErrors() {
        return this.fErrors;
    }

    public int getErrorCount() {
        return this.fErrors.size();
    }

    public int getWarningCount() {
        return this.fWarnings.size();
    }

    public int getProblemCount() {
        return this.fErrors.size() + this.fWarnings.size();
    }
}

