/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.ant;

import com.ibm.team.build.ant.task.AbstractFilePublisherTask;
import com.ibm.team.build.ant.task.AbstractPublisherTask;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.publishing.ContentPublisher;
import com.ibm.team.repository.common.UUID;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractContentPublisherTask
extends AbstractFilePublisherTask {
    public static final String CONTRIBUTION_STATUS = "status";
    public static final String LABEL = "label";
    public static final String CONTENT_TYPE = "contentType";
    public static final String CHARACTER_ENCODING = "characterEncoding";
    private String fLabel = null;
    private String fContentType = null;
    private String fCharacterEncoding = null;
    private String fContributionStatus = BuildStatus.OK.name();

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setContentType(String contentType) {
        this.fContentType = contentType;
    }

    public String getContentType() {
        return this.fContentType;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.fCharacterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.fCharacterEncoding;
    }

    public void setStatus(AbstractPublisherTask.BuildStatusAttribute status) {
        this.fContributionStatus = status.getValue();
    }

    protected void collectAntAttributes(List antAttributes) {
        super.collectAntAttributes(antAttributes);
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(LABEL, this.getLabel(), true));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(CONTENT_TYPE, this.getContentType(), false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(CHARACTER_ENCODING, this.getCharacterEncoding(), false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(CONTRIBUTION_STATUS, this.fContributionStatus, false));
    }

    protected void updateBuildResult() throws Exception {
        ContentPublisher contentPublisher = this.getContentPublisher();
        IBuildResultHandle resultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getBuildResultUUID()), null);
        if (this.getComponentName() != null) {
            contentPublisher.setComponentName(this.getComponentName());
        }
        IBuildResultContribution contribution = contentPublisher.publish(resultHandle, BuildStatus.valueOf((String)this.fContributionStatus), this.getTeamRepository());
        if (this.isVerbose()) {
            Object[] params = new Object[]{this.getFile().getAbsolutePath(), contribution.getExtendedContributionTypeId(), this.getBuildIdentifier()};
            this.log(NLS.bind((String)AntMessages.AbstractContentPublisherTask_PUBLISH_FILE_AS_CONTENT, (Object[])params));
        }
    }

    protected abstract ContentPublisher getContentPublisher();
}

