/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractFilePublisherTask;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.publishing.WorkItemPublisher;
import com.ibm.team.build.internal.publishing.workitem.WorkItemPublishStatus;
import com.ibm.team.build.publishing.workitem.FileTypes;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.List;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.eclipse.osgi.util.NLS;

public final class WorkItemPublisherTask
extends AbstractFilePublisherTask {
    private IWorkItemHandle[] fWorkItems = null;
    private FileTypeAttribute fInputFileType;
    private int fExpectedNumberOfWorkItems;
    public static final String INPUT_FILE_TYPE = "inputFileType";

    public FileTypeAttribute getInputFileType() {
        return this.fInputFileType;
    }

    public void setInputFileType(FileTypeAttribute inputFileType) {
        this.fInputFileType = inputFileType;
    }

    protected void updateBuildResult() throws Exception {
        WorkItemPublisher publisher = new WorkItemPublisher();
        String absolutePath = this.getFile().getAbsolutePath();
        if (this.isVerbose()) {
            this.log(NLS.bind((String)AntMessages.WorkItemPublisherTask_PUBLISHING_WORKITEM_INFO_FILE, (Object)absolutePath));
        }
        FileTypes fileType = this.mapInputFileType();
        WorkItemPublishStatus status = publisher.publish((IBuildResultHandle)this.getBuildResult(IBuildResult.PROPERTIES_COMPLETE), absolutePath, this.getTeamRepository(), fileType);
        this.fWorkItems = status.getWorkItemHandles();
        this.fExpectedNumberOfWorkItems = status.getNumberOfWorkItemsExpected();
        this.logBuildResultChanges();
        this.logUnfoundWorkItems();
    }

    private FileTypes mapInputFileType() {
        FileTypeAttribute inputFileType = this.getInputFileType();
        if (inputFileType == null) {
            return FileTypes.CHANGESET;
        }
        return FileTypes.valueOf(inputFileType.getValue());
    }

    protected void logBuildResultChanges() {
        if (this.isVerbose()) {
            this.log(NLS.bind((String)AntMessages.WorkItemPublisherTask_UPDATED_WORK_ITEMS, (Object)this.fWorkItems.length));
        }
    }

    protected void logUnfoundWorkItems() {
        if (this.fExpectedNumberOfWorkItems > this.fWorkItems.length) {
            this.log(NLS.bind((String)AntMessages.WorkItemPublisherTask_WORK_ITEMS_NOT_FOUND, (Object[])new Object[]{this.getFile().getAbsolutePath(), this.fExpectedNumberOfWorkItems, this.fWorkItems.length}), 1);
        }
    }

    protected void collectAntAttributes(List antAttributes) {
        super.collectAntAttributes(antAttributes);
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(INPUT_FILE_TYPE, this.mapInputFileType().name(), false));
    }

    public static class FileTypeAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            FileTypes[] values = FileTypes.values();
            String[] validValues = new String[values.length];
            int i = 0;
            while (i < values.length) {
                validValues[i] = values[i].name();
                ++i;
            }
            return validValues;
        }
    }
}

