/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public class WaitForTeamBuildTask
extends AbstractTeamBuildTask {
    public static final String BUILD_STATE_DELIMITER = ",";
    public static final String BUILD_REQUEST_UUID = "requestUUID";
    public static final String BUILD_RESULT_UUID = "buildResultUUID";
    public static final String STATES_TO_WAIT_FOR = "statesToWaitFor";
    public static final String BUILD_STATE_PROPERTY = "buildStateProperty";
    public static final String TIMEOUT = "timeout";
    public static final String INTERVAL = "interval";
    public static final String BUILD_STATUS_PROPERTY = "buildStatusProperty";
    private String fRequestUUID = null;
    private String fBuildResultUUID = null;
    private String fStatesToWaitFor = null;
    private String fBuildStateProperty = null;
    private String fBuildStatusProperty = null;
    private long fTimeout = Long.MAX_VALUE;
    private long fInterval = 30L;
    private BuildState[] fBuildStates = new BuildState[]{BuildState.COMPLETED, BuildState.INCOMPLETE};

    protected void collectAntAttributes(List antAttributes) {
        boolean required = this.fBuildResultUUID == null;
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(BUILD_REQUEST_UUID, this.fRequestUUID, required){

            public void validate() throws AbstractTeamBuildTask.IllegalAntAttributeException {
                super.validate();
                if (WaitForTeamBuildTask.this.fBuildResultUUID != null && WaitForTeamBuildTask.this.fRequestUUID != null) {
                    throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.WaitForTeamBuildTask_ONLY_RESULT_OR_REQUEST_UUID_ALLOWED, (Object)WaitForTeamBuildTask.BUILD_REQUEST_UUID, (Object)WaitForTeamBuildTask.BUILD_RESULT_UUID));
                }
            }
        });
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(BUILD_RESULT_UUID, this.fBuildResultUUID, !required));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(STATES_TO_WAIT_FOR, this.fStatesToWaitFor, false){

            public void validate() throws AbstractTeamBuildTask.IllegalAntAttributeException {
                super.validate();
                if (this.getValue() != null) {
                    StringTokenizer tokenizer = new StringTokenizer(this.getValue(), WaitForTeamBuildTask.BUILD_STATE_DELIMITER);
                    while (tokenizer.hasMoreElements()) {
                        String token = tokenizer.nextToken().trim();
                        try {
                            BuildState.valueOf((String)token);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.handleIllegalAttributeValue(this.getName(), token);
                        }
                    }
                }
            }
        });
        antAttributes.add(new AbstractTeamBuildTask.LongAntAttribute(TIMEOUT, this.fTimeout, false){

            public void validate() throws AbstractTeamBuildTask.IllegalAntAttributeException {
                super.validate();
                if (WaitForTeamBuildTask.this.fTimeout <= 0L) {
                    throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.WaitForTeamBuildTask_MUST_BE_GREATER_THAN_ZERO, (Object)WaitForTeamBuildTask.TIMEOUT));
                }
            }
        });
        antAttributes.add(new AbstractTeamBuildTask.LongAntAttribute(INTERVAL, this.fInterval, false){

            public void validate() throws AbstractTeamBuildTask.IllegalAntAttributeException {
                super.validate();
                if (WaitForTeamBuildTask.this.fInterval >= WaitForTeamBuildTask.this.fTimeout) {
                    throw new AbstractTeamBuildTask.IllegalAntAttributeException(AntMessages.WaitForTeamBuildTask_INTERVAL_LESS_THAN_TIMEOUT);
                }
                if (WaitForTeamBuildTask.this.fInterval <= 0L) {
                    throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.WaitForTeamBuildTask_MUST_BE_GREATER_THAN_ZERO, (Object)WaitForTeamBuildTask.INTERVAL));
                }
            }
        });
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_STATE_PROPERTY, this.fBuildStateProperty, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_STATUS_PROPERTY, this.fBuildStatusProperty, false));
    }

    protected void doExecute() throws Exception {
        String buildUUID;
        this.convertBuildStates(this.fStatesToWaitFor);
        IBuildResult buildResult = null;
        if (this.fRequestUUID != null) {
            IBuildRequestHandle buildRequestHandle = (IBuildRequestHandle)IBuildRequest.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fRequestUUID), null);
            IBuildRequest buildRequest = this.getBuildRequest(buildRequestHandle);
            buildResult = this.getBuildResult(buildRequest.getBuildResult());
        } else {
            IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fBuildResultUUID), null);
            buildResult = this.getBuildResult(buildResultHandle);
        }
        String string = buildUUID = this.fRequestUUID != null ? this.fRequestUUID : this.fBuildResultUUID;
        if (this.isVerbose()) {
            if (this.fStatesToWaitFor != null) {
                this.log(NLS.bind((String)AntMessages.WaitForTeamBuildTask_BEGIN_WAIT, (Object)buildUUID, (Object)this.fStatesToWaitFor));
            } else {
                this.log(NLS.bind((String)AntMessages.WaitForTeamBuildTask_BEGIN_WAIT, (Object)buildUUID, (Object)"COMPLETED, INCOMPLETE"));
            }
        }
        long timeWaiting = 0L;
        while (!this.isInBuildState(buildResult) && !this.hasReachedTimeout(timeWaiting)) {
            timeWaiting += this.fInterval;
            Thread.sleep(this.fInterval * 1000L);
            buildResult = this.getBuildResult((IBuildResultHandle)buildResult);
        }
        if (!this.isInBuildState(buildResult)) {
            this.log(NLS.bind((String)AntMessages.WaitForTeamBuildTask_MAX_WAIT_TIME_EXCEEDED, (Object)this.fTimeout, (Object)buildUUID), 1);
        } else if (this.fBuildStateProperty != null) {
            this.getProject().setProperty(this.fBuildStateProperty, buildResult.getState().name());
        }
        if (this.fBuildStatusProperty != null) {
            this.getProject().setProperty(this.fBuildStatusProperty, buildResult.getStatus().name());
        }
        if (this.isVerbose()) {
            Object[] params = new Object[]{buildUUID, buildResult.getState().name(), timeWaiting};
            this.log(NLS.bind((String)AntMessages.WaitForTeamBuildTask_FINISH_WAIT, (Object[])params));
        }
    }

    private boolean hasReachedTimeout(long timeWaiting) {
        return timeWaiting >= this.fTimeout;
    }

    private void convertBuildStates(String buildStates) {
        if (buildStates != null) {
            StringTokenizer tokenizer = new StringTokenizer(buildStates, BUILD_STATE_DELIMITER);
            this.fBuildStates = new BuildState[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreElements()) {
                this.fBuildStates[i++] = BuildState.valueOf((String)tokenizer.nextToken().trim());
            }
        }
    }

    private boolean isInBuildState(IBuildResult buildResult) {
        BuildState[] buildStateArray = this.fBuildStates;
        int n = this.fBuildStates.length;
        int n2 = 0;
        while (n2 < n) {
            BuildState buildState = buildStateArray[n2];
            if (buildResult.getState() == buildState) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IBuildResult getBuildResult(IBuildResultHandle buildResultHandle) throws TeamRepositoryException {
        try {
            return (IBuildResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 1, this.getProgressMonitor());
        }
        catch (ItemNotFoundException exception) {
            throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)IBuildResult.ITEM_TYPE.getName(), (Object)this.fBuildResultUUID), (Throwable)exception);
        }
    }

    private IBuildRequest getBuildRequest(IBuildRequestHandle buildRequestHandle) throws TeamRepositoryException {
        try {
            return (IBuildRequest)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildRequestHandle, 1, this.getProgressMonitor());
        }
        catch (ItemNotFoundException exception) {
            throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)IBuildRequest.ITEM_TYPE.getName(), (Object)this.fRequestUUID), (Throwable)exception);
        }
    }

    public void setRequestUUID(String requestUUID) {
        this.fRequestUUID = requestUUID;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.fBuildResultUUID = buildResultUUID;
    }

    public void setBuildStateProperty(String buildStateProperty) {
        this.fBuildStateProperty = buildStateProperty;
    }

    public void setBuildStatusProperty(String buildStatusProperty) {
        this.fBuildStatusProperty = buildStatusProperty;
    }

    public void setStatesToWaitFor(String statesToWaitFor) {
        this.fStatesToWaitFor = statesToWaitFor;
    }

    public void setTimeout(long timeout) {
        this.fTimeout = timeout;
    }

    public void setInterval(long interval) {
        this.fInterval = interval;
    }
}

