/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.scm.SourceControlUtility;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TeamLastModifiedTask
extends AbstractTeamBuildTask {
    public static final String WORKSPACE_NAME = "workspaceName";
    public static final String WORKSPACE_UUID = "workspaceUUID";
    public static final String SOURCE_DIRECTORY = "sourceDirectory";
    public static final String OUTPUT_PROPERTIES_FILE = "outputPropertiesFile";
    public static final String RAW_OUTPUT_PROPERTIES_FILE = "rawOutputPropertiesFile";
    public static final String TIMESTAMP_FORMAT = "timestampFormat";
    private String fWorkspaceName = null;
    private String fWorkspaceUUID = null;
    private File fSourceDirectory = null;
    private File fOutputPropertiesFile = null;
    private File fRawOutputPropertiesFile = null;
    private String fTimestampFormat = "yyyyMMddHHmm";

    @Override
    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(WORKSPACE_NAME, this.fWorkspaceName, false));
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(WORKSPACE_UUID, this.fWorkspaceUUID, false));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(SOURCE_DIRECTORY, this.fSourceDirectory, true, true));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(OUTPUT_PROPERTIES_FILE, this.fOutputPropertiesFile, true, false));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(RAW_OUTPUT_PROPERTIES_FILE, this.fRawOutputPropertiesFile, false, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(TIMESTAMP_FORMAT, this.fTimestampFormat, false));
    }

    @Override
    protected void doExecute() throws Exception {
        FileSystemCore.startUp();
        ITeamRepository teamRepository = this.getTeamRepository();
        IWorkspace workspace = this.getWorkspace(teamRepository);
        if (this.isVerbose()) {
            String message = NLS.bind((String)AntMessages.TeamLastModificationTask_CALCULATING_LAST_MODIFIED, (Object)this.fSourceDirectory.getAbsolutePath());
            this.log(message);
        }
        try {
            Map<String, Date> lastModifiedTimes = SourceControlUtility.getLastModifiedTimes(teamRepository, this.fSourceDirectory, (IWorkspaceHandle)workspace, this.getProgressMonitor());
            this.createPropertiesFile(lastModifiedTimes);
            if (this.fRawOutputPropertiesFile != null) {
                Map<IFolderHandle, IBaseline> lastModifiedBaselines = SourceControlUtility.getLastModifiedBaselines(teamRepository, this.fSourceDirectory, (IWorkspaceHandle)workspace, this.getProgressMonitor());
                this.createRawPropertiesFile(lastModifiedBaselines);
            }
        }
        finally {
            FileSystemCore.shutDown();
        }
    }

    private void createPropertiesFile(Map<String, Date> lastModifiedTimes) throws IOException {
        Properties properties = new Properties();
        for (String key : lastModifiedTimes.keySet()) {
            Date date = lastModifiedTimes.get(key);
            SimpleDateFormat format = new SimpleDateFormat(this.fTimestampFormat);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            properties.put(key, format.format(date.getTime()));
        }
        FileOutputStream outputStream = new FileOutputStream(this.fOutputPropertiesFile);
        try {
            properties.store(outputStream, null);
        }
        finally {
            outputStream.close();
        }
    }

    private void createRawPropertiesFile(Map<IFolderHandle, IBaseline> lastModifiedBaselines) throws IOException {
        Properties properties = new Properties();
        for (IFolderHandle key : lastModifiedBaselines.keySet()) {
            IBaselineHandle baselineHandle = (IBaselineHandle)lastModifiedBaselines.get(key);
            properties.put(key.getItemId().getUuidValue(), baselineHandle.getItemId().getUuidValue());
        }
        FileOutputStream outputStream = new FileOutputStream(this.fRawOutputPropertiesFile);
        try {
            properties.store(outputStream, null);
        }
        finally {
            outputStream.close();
        }
    }

    @Override
    protected void validateAttribute(AbstractTeamBuildTask.AntAttribute theAttribute) throws AbstractTeamBuildTask.IllegalAntAttributeException {
        if (this.isAttribute(theAttribute, WORKSPACE_NAME) || this.isAttribute(theAttribute, WORKSPACE_UUID)) {
            if (this.fWorkspaceName != null && this.fWorkspaceUUID != null) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamFetchTask_ILLEGAL_TO_SPECIFY_WORKSPACE_NAME_AND_UUID, (Object[])new String[]{WORKSPACE_NAME, WORKSPACE_UUID}));
            }
            if (this.fWorkspaceName == null && this.fWorkspaceUUID == null) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamFetchTask_WORKSPACE_REQUIRED, (Object[])new String[]{WORKSPACE_NAME, WORKSPACE_UUID}));
            }
        }
        super.validateAttribute(theAttribute);
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.fSourceDirectory = sourceDirectory;
    }

    public void setOutputPropertiesFile(File propertiesFile) {
        this.fOutputPropertiesFile = propertiesFile;
    }

    public void setRawOutputPropertiesFile(File propertiesFile) {
        this.fRawOutputPropertiesFile = propertiesFile;
    }

    public void setTimestampFormat(String format) {
        this.fTimestampFormat = format;
    }

    public void setWorkspaceName(String workspaceName) {
        this.fWorkspaceName = workspaceName;
    }

    public void setWorkspaceUUID(String workspaceUUID) {
        this.fWorkspaceUUID = workspaceUUID;
    }

    private IWorkspace getWorkspace(ITeamRepository teamRepository) throws TeamRepositoryException {
        IWorkspace workspace = null;
        UUID workspaceUuid = null;
        if (this.fWorkspaceUUID != null) {
            try {
                workspaceUuid = UUID.valueOf((String)this.fWorkspaceUUID);
            }
            catch (IllegalArgumentException exception) {
                throw new TeamBuildException(NLS.bind((String)AntMessages.TeamFetchTask_INVALID_UUID, (Object)this.fWorkspaceUUID), (Throwable)exception);
            }
            IItem item = null;
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
            try {
                item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, this.getProgressMonitor());
            }
            catch (ItemNotFoundException exception) {
                throw new TeamBuildException(NLS.bind((String)AntMessages.TeamFetchTask_MISSING_WORKSPACE, (Object)this.fWorkspaceUUID), (Throwable)exception);
            }
            if (!(item instanceof IWorkspace)) {
                throw new TeamBuildException(NLS.bind((String)AntMessages.TeamFetchTask_WRONG_TYPE, (Object)this.fWorkspaceUUID, (Object)item.getItemType().getName()));
            }
            workspace = (IWorkspace)item;
        } else if (this.fWorkspaceName != null && (workspace = SourceControlUtility.getWorkspace(teamRepository, this.fWorkspaceName)) == null) {
            throw new BuildException(NLS.bind((String)AntMessages.TeamAcceptTask_COULD_NOT_FIND_WORKSPACE, (Object)this.fWorkspaceName));
        }
        return workspace;
    }
}

