/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.scm.SourceControlUtility;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public final class TeamFetchTask
extends AbstractTeamBuildTask {
    public static final String BUILD_RESULT_UUID = "buildResultUUID";
    public static final String WORKSPACE_NAME = "workspaceName";
    public static final String WORKSPACE_UUID = "workspaceUUID";
    public static final String DESTINATION = "destination";
    private String fWorkspaceName = null;
    private String fWorkspaceUUID = null;
    private String fBuildResultUUID = null;
    private File fDestination = null;

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(WORKSPACE_NAME, this.fWorkspaceName, false));
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(WORKSPACE_UUID, this.fWorkspaceUUID, false));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(DESTINATION, this.fDestination, true, false));
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(BUILD_RESULT_UUID, this.fBuildResultUUID, false));
    }

    protected void doExecute() throws Exception {
        FileSystemCore.startUp();
        ITeamRepository teamRepository = this.getTeamRepository();
        IWorkspace workspace = this.getWorkspace(teamRepository);
        if (this.isVerbose()) {
            String message = NLS.bind((String)AntMessages.TeamFetchTask_FETCH_WORKSPACE_TO_PATH, (Object)workspace.getName(), (Object)this.fDestination.getAbsolutePath());
            this.log(message);
        }
        try {
            SourceControlUtility.updateFileCopyArea(teamRepository, (IWorkspaceHandle)workspace, this.fDestination.getAbsolutePath(), this.getProgressMonitor());
        }
        finally {
            FileSystemCore.shutDown();
        }
        if (this.fBuildResultUUID != null) {
            this.addWorkspaceContribution(workspace);
        }
    }

    protected void validateAttribute(AbstractTeamBuildTask.AntAttribute theAttribute) throws AbstractTeamBuildTask.IllegalAntAttributeException {
        if (this.isAttribute(theAttribute, WORKSPACE_NAME) || this.isAttribute(theAttribute, WORKSPACE_UUID)) {
            if (this.fWorkspaceName != null && this.fWorkspaceUUID != null) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamFetchTask_ILLEGAL_TO_SPECIFY_WORKSPACE_NAME_AND_UUID, (Object[])new String[]{WORKSPACE_NAME, WORKSPACE_UUID}));
            }
            if (this.fWorkspaceName == null && this.fWorkspaceUUID == null) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamFetchTask_WORKSPACE_REQUIRED, (Object[])new String[]{WORKSPACE_NAME, WORKSPACE_UUID}));
            }
        }
        if (this.isAttribute(theAttribute, BUILD_RESULT_UUID)) {
            try {
                this.validateIsOKToAddWorkspaceContribution();
            }
            catch (TeamRepositoryException exception) {
                throw new BuildException((Throwable)exception);
            }
        }
        super.validateAttribute(theAttribute);
    }

    private void validateIsOKToAddWorkspaceContribution() throws AbstractTeamBuildTask.IllegalAntAttributeException, TeamRepositoryException {
        if (this.fBuildResultUUID != null) {
            UUID buildResultUuid = null;
            try {
                buildResultUuid = UUID.valueOf((String)this.fBuildResultUUID);
            }
            catch (IllegalArgumentException exception) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamAcceptTask_NOT_VALID_BUILD_RESULT_ID, (Object)this.fBuildResultUUID), exception);
            }
            IItem item = null;
            IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(buildResultUuid, null);
            try {
                item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 1, this.getProgressMonitor());
            }
            catch (ItemNotFoundException exception) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamAcceptTask_BUILD_RESULT_NOT_FOUND, (Object)this.fBuildResultUUID), exception);
            }
            if (!(item instanceof IBuildResult)) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamAcceptTask_WRONG_ITEM_TYPE_BUILD_RESULT, (Object)this.fBuildResultUUID, (Object)item.getItemType().getName()));
            }
            if (this.getTeamBuildClient().getBuildResultContributions(buildResultHandle, "buildWorkspace", this.getProgressMonitor()).length > 0) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamFetchTask_MULTIPLE_WORKSPACES, (Object)this.fBuildResultUUID));
            }
        }
    }

    public void setDestination(File destination) {
        this.fDestination = destination;
    }

    public void setWorkspaceName(String workspaceName) {
        this.fWorkspaceName = workspaceName;
    }

    public void setWorkspaceUUID(String workspaceUUID) {
        this.fWorkspaceUUID = workspaceUUID;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.fBuildResultUUID = buildResultUUID;
    }

    private IWorkspace getWorkspace(ITeamRepository teamRepository) throws TeamRepositoryException {
        IWorkspace workspace = null;
        UUID workspaceUuid = null;
        if (this.fWorkspaceUUID != null) {
            try {
                workspaceUuid = UUID.valueOf((String)this.fWorkspaceUUID);
            }
            catch (IllegalArgumentException exception) {
                throw new TeamBuildException(NLS.bind((String)AntMessages.TeamFetchTask_INVALID_UUID, (Object)this.fWorkspaceUUID), (Throwable)exception);
            }
            IItem item = null;
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
            try {
                item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, this.getProgressMonitor());
            }
            catch (ItemNotFoundException exception) {
                throw new TeamBuildException(NLS.bind((String)AntMessages.TeamFetchTask_MISSING_WORKSPACE, (Object)this.fWorkspaceUUID), (Throwable)exception);
            }
            if (!(item instanceof IWorkspace)) {
                throw new TeamBuildException(NLS.bind((String)AntMessages.TeamFetchTask_WRONG_TYPE, (Object)this.fWorkspaceUUID, (Object)item.getItemType().getName()));
            }
            workspace = (IWorkspace)item;
        } else if (this.fWorkspaceName != null && (workspace = SourceControlUtility.getWorkspace(teamRepository, this.fWorkspaceName)) == null) {
            throw new BuildException(NLS.bind((String)AntMessages.TeamAcceptTask_COULD_NOT_FIND_WORKSPACE, (Object)this.fWorkspaceName));
        }
        return workspace;
    }

    private void addWorkspaceContribution(IWorkspace workspace) throws IllegalArgumentException, TeamRepositoryException {
        IBuildResultHandle resultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fBuildResultUUID), null);
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setExtendedContributionTypeId("buildWorkspace");
        contribution.setImpactsPrimaryResult(false);
        contribution.setLabel(workspace.getName());
        contribution.setExtendedContribution((IItemHandle)workspace);
        this.getTeamBuildClient().addBuildResultContribution(resultHandle, contribution, this.getProgressMonitor());
    }
}

