/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.common.ChangeSetInfo;
import com.ibm.team.build.internal.scm.AcceptReport;
import com.ibm.team.build.internal.scm.SourceControlUtility;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public final class TeamAcceptTask
extends AbstractTeamBuildTask {
    public static final String BUILD_RESULT_UUID = "buildResultUUID";
    public static final String WORKSPACE_NAME = "workspaceName";
    public static final String WORKSPACE_UUID = "workspaceUUID";
    public static final String CHANGE_SET_FILE = "changeSetFile";
    public static final String SNAPSHOT_NAME = "snapshotName";
    public static final String SNAPSHOT_UUID_PROPERTY = "snapshotUUIDProperty";
    public static final String CHANGES_ACCEPTED_PROPERTY = "changesAcceptedProperty";
    private String fWorkspaceName;
    private String fWorkspaceUUID;
    private File fChangeSetFile;
    private String fSnapshotName;
    private String fSnapshotUUIDProperty;
    private String fBuildResultUUID;
    private String fChangesAcceptedProperty;

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(WORKSPACE_NAME, this.fWorkspaceName, false));
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(WORKSPACE_UUID, this.fWorkspaceUUID, false));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(CHANGE_SET_FILE, this.fChangeSetFile, false, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(SNAPSHOT_NAME, this.fSnapshotName, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(SNAPSHOT_UUID_PROPERTY, this.fSnapshotUUIDProperty, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(CHANGES_ACCEPTED_PROPERTY, this.fChangesAcceptedProperty, false));
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(BUILD_RESULT_UUID, this.fBuildResultUUID, false));
    }

    protected void doExecute() throws Exception {
        IBaselineSet snapshot;
        int changesAccepted;
        ITeamRepository teamRepository = this.getTeamRepository();
        IWorkspace workspace = this.getWorkspace(teamRepository);
        AcceptReport acceptReport = SourceControlUtility.acceptAllIncoming(teamRepository, (IWorkspaceHandle)workspace, this.fSnapshotName, this.getProgressMonitor());
        IChangeSetHandle[] changeSetHandles = acceptReport.getAcceptChangeSets();
        if (this.isVerbose()) {
            this.log(NLS.bind((String)AntMessages.TeamAcceptTask_ACCEPTED_CHANGE_SETS, (Object)changeSetHandles.length));
            this.log(NLS.bind((String)AntMessages.TeamAcceptTask_DISCARDED_CHANGE_SETS, (Object)acceptReport.getDiscardChangeSets().length));
            this.log(NLS.bind((String)AntMessages.TeamAcceptTask_NEW_COMPONENTS, (Object)acceptReport.getComponentAdds().length));
            this.log(NLS.bind((String)AntMessages.TeamAcceptTask_DROPPED_COMPONENTS, (Object)acceptReport.getComponentRemovals().length));
            if (acceptReport.getSnapshot() != null) {
                this.log(NLS.bind((String)AntMessages.TeamAcceptTask_CREATED_SNAPSHOT, (Object)acceptReport.getSnapshot().getName()));
            }
        }
        if (this.fChangeSetFile != null) {
            ChangeSetInfo changeSetInfo = new ChangeSetInfo(changeSetHandles, (IWorkspaceHandle)workspace);
            changeSetInfo.serialize(this.fChangeSetFile);
            if (this.isVerbose()) {
                this.log(NLS.bind((String)AntMessages.TeamAcceptTask_CHANGE_SETS_SERIALIZED, (Object)this.fChangeSetFile.getAbsolutePath()));
            }
        }
        if (this.fChangesAcceptedProperty != null && (changesAccepted = this.getChangesAccepted(acceptReport)) > 0) {
            this.getProject().setProperty(this.fChangesAcceptedProperty, String.valueOf(changesAccepted));
        }
        if ((snapshot = acceptReport.getSnapshot()) != null) {
            if (this.fBuildResultUUID != null) {
                this.addSnapshotContribution(snapshot);
            }
            if (this.fSnapshotUUIDProperty != null) {
                this.getProject().setProperty(this.fSnapshotUUIDProperty, snapshot.getItemId().getUuidValue());
            }
        }
    }

    private void validateOKToAddSnapshotContribution() throws AbstractTeamBuildTask.IllegalAntAttributeException, TeamRepositoryException {
        if (this.fBuildResultUUID != null) {
            if (this.fSnapshotName == null) {
                this.log(AntMessages.TeamAcceptTask_SNAPSHOT_NAME_MUST_BE_SET, 1);
                return;
            }
            UUID buildResultUuid = null;
            try {
                buildResultUuid = UUID.valueOf((String)this.fBuildResultUUID);
            }
            catch (IllegalArgumentException exception) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamAcceptTask_NOT_VALID_BUILD_RESULT_ID, (Object)this.fBuildResultUUID), exception);
            }
            IItem item = null;
            IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(buildResultUuid, null);
            try {
                item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildResultHandle, 1, this.getProgressMonitor());
            }
            catch (ItemNotFoundException exception) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamAcceptTask_BUILD_RESULT_NOT_FOUND, (Object)this.fBuildResultUUID), exception);
            }
            if (!(item instanceof IBuildResult)) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamAcceptTask_WRONG_ITEM_TYPE_BUILD_RESULT, (Object)this.fBuildResultUUID, (Object)item.getItemType().getName()));
            }
            if (this.getTeamBuildClient().getBuildResultContributions(buildResultHandle, "buildSnapshot", this.getProgressMonitor()).length > 0) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamAcceptTask_MULTIPLE_SNAPSHOTS_NOT_ALLOWED, (Object)this.fBuildResultUUID));
            }
        }
    }

    protected void validateAttribute(AbstractTeamBuildTask.AntAttribute theAttribute) throws AbstractTeamBuildTask.IllegalAntAttributeException {
        if (this.isAttribute(theAttribute, WORKSPACE_NAME) || this.isAttribute(theAttribute, WORKSPACE_UUID)) {
            if (this.fWorkspaceName != null && this.fWorkspaceUUID != null) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamFetchTask_ILLEGAL_TO_SPECIFY_WORKSPACE_NAME_AND_UUID, (Object[])new String[]{WORKSPACE_NAME, WORKSPACE_UUID}));
            }
            if (this.fWorkspaceName == null && this.fWorkspaceUUID == null) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.TeamFetchTask_WORKSPACE_REQUIRED, (Object[])new String[]{WORKSPACE_NAME, WORKSPACE_UUID}));
            }
        }
        if (this.isAttribute(theAttribute, BUILD_RESULT_UUID)) {
            try {
                this.validateOKToAddSnapshotContribution();
            }
            catch (TeamRepositoryException exception) {
                throw new BuildException((Throwable)exception);
            }
        }
        super.validateAttribute(theAttribute);
    }

    private void addSnapshotContribution(IBaselineSet snapshot) throws IllegalArgumentException, TeamRepositoryException {
        IBuildResultHandle resultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fBuildResultUUID), null);
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setExtendedContributionTypeId("buildSnapshot");
        contribution.setImpactsPrimaryResult(false);
        contribution.setLabel(NLS.bind((String)AntMessages.TeamAcceptTask_SNAPSHOT_CONTRIBUTION_LABEL, (Object)snapshot.getName()));
        contribution.setExtendedContribution((IItemHandle)snapshot);
        this.getTeamBuildClient().addBuildResultContribution(resultHandle, contribution, this.getProgressMonitor());
    }

    public void setWorkspaceName(String workspaceName) {
        this.fWorkspaceName = workspaceName;
    }

    public void setChangeSetFile(File changeSetFile) {
        this.fChangeSetFile = changeSetFile;
    }

    public void setSnapshotName(String snapshotName) {
        this.fSnapshotName = snapshotName;
    }

    public void setSnapshotUUIDProperty(String antProperty) {
        this.fSnapshotUUIDProperty = antProperty;
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.fBuildResultUUID = buildResultUUID;
    }

    public void setChangesAcceptedProperty(String changesAcceptedProperty) {
        this.fChangesAcceptedProperty = changesAcceptedProperty;
    }

    public void setWorkspaceUUID(String workspaceUUID) {
        this.fWorkspaceUUID = workspaceUUID;
    }

    private IWorkspace getWorkspace(ITeamRepository teamRepository) throws TeamRepositoryException {
        IWorkspace workspace = null;
        UUID workspaceUuid = null;
        if (this.fWorkspaceUUID != null) {
            try {
                workspaceUuid = UUID.valueOf((String)this.fWorkspaceUUID);
            }
            catch (IllegalArgumentException exception) {
                throw new TeamBuildException(NLS.bind((String)AntMessages.TeamFetchTask_INVALID_UUID, (Object)this.fWorkspaceUUID), (Throwable)exception);
            }
            IItem item = null;
            IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
            try {
                item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, this.getProgressMonitor());
            }
            catch (ItemNotFoundException exception) {
                throw new TeamBuildException(NLS.bind((String)AntMessages.TeamFetchTask_MISSING_WORKSPACE, (Object)this.fWorkspaceUUID), (Throwable)exception);
            }
            if (!(item instanceof IWorkspace)) {
                throw new TeamBuildException(NLS.bind((String)AntMessages.TeamFetchTask_WRONG_TYPE, (Object)this.fWorkspaceUUID, (Object)item.getItemType().getName()));
            }
            workspace = (IWorkspace)item;
        } else if (this.fWorkspaceName != null && (workspace = SourceControlUtility.getWorkspace(teamRepository, this.fWorkspaceName)) == null) {
            throw new BuildException(NLS.bind((String)AntMessages.TeamAcceptTask_COULD_NOT_FIND_WORKSPACE, (Object)this.fWorkspaceName));
        }
        return workspace;
    }

    private int getChangesAccepted(AcceptReport report) {
        int changes = report.getAcceptChangeSets().length;
        changes += report.getDiscardChangeSets().length;
        changes += report.getComponentAdds().length;
        return changes += report.getComponentRemovals().length;
    }
}

