/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.listener.TeamBuildListener;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StartBuildTask
extends AbstractTeamBuildTask {
    public static final String BUILD_DEFINITION_ID = "buildDefinitionId";
    public static final String ENGINE_ID = "engineId";
    public static final String BUILD_REQUEST_UUID = "requestUUID";
    public static final String BUILD_RESULT_UUID_PROPERTY = "resultUUIDProperty";
    public static final String BUILD_RESULT_UUID_FILE = "resultUUIDFile";
    public static final String AUTO_COMPLETE = "autoComplete";
    public static final String BUILD_LABEL = "label";
    private String fRequestUUID = null;
    private String fResultUUIDProperty = null;
    private File fResultUUIDFile = null;
    private String fBuildDefinitionId = null;
    private String fEngineId = null;
    private String fLabel = null;
    private String fResultUUID = null;
    private boolean fAutoComplete = true;

    public StartBuildTask() {
        this.setFailOnError(true);
    }

    @Override
    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_RESULT_UUID_PROPERTY, this.fResultUUIDProperty, true));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(BUILD_RESULT_UUID_FILE, this.fResultUUIDFile, false, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_LABEL, this.fLabel, false));
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(BUILD_REQUEST_UUID, this.fRequestUUID, false));
        antAttributes.add(new AbstractTeamBuildTask.BooleanAntAttribute(AUTO_COMPLETE, this.fAutoComplete, false));
        boolean required = this.fRequestUUID == null;
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_DEFINITION_ID, this.fBuildDefinitionId, required));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(ENGINE_ID, this.fEngineId, required));
    }

    @Override
    protected void validateAttribute(AbstractTeamBuildTask.AntAttribute theAttribute) throws AbstractTeamBuildTask.IllegalAntAttributeException {
        super.validateAttribute(theAttribute);
        if (this.isAttribute(theAttribute, BUILD_REQUEST_UUID) && theAttribute.getValue() != null && (this.fBuildDefinitionId != null || this.fEngineId != null)) {
            throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.StartBuildTask_BUILD_DEFINITION_AND_ENGINE_ID_PROPERTIES_NOT_APPLICABLE, (Object[])new Object[]{BUILD_DEFINITION_ID, ENGINE_ID, BUILD_REQUEST_UUID}));
        }
    }

    @Override
    protected void doExecute() throws Exception {
        this.verifyTeamBuildListenerIsActive();
        IBuildRequest buildRequest = this.getBuildRequest();
        this.setBuildLabel(buildRequest, this.fLabel);
        this.setResultUUIDProperty(buildRequest, this.fResultUUIDProperty);
        this.writeResultUUIDFile(buildRequest, this.fResultUUIDFile);
        this.createAntProperties(buildRequest);
        TeamBuildListener.startBuild(buildRequest.getBuildResult(), this.getTeamRepository());
    }

    private void verifyTeamBuildListenerIsActive() throws BuildException {
        Vector buildListeners = this.getProject().getBuildListeners();
        for (BuildListener buildListener : buildListeners) {
            if (!(buildListener instanceof TeamBuildListener)) continue;
            return;
        }
        if (this.fAutoComplete) {
            throw new BuildException(NLS.bind((String)AntMessages.StartBuildTask_LISTENER_REQUIRED_FOR_AUTO_COMPLETE, (Object)TeamBuildListener.class.getName(), (Object)AUTO_COMPLETE));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBuildRequest getBuildRequest() throws TeamRepositoryException, BuildException {
        IBuildRequest buildRequest;
        if (this.fRequestUUID != null) {
            IBuildRequestHandle buildRequestHandle = (IBuildRequestHandle)IBuildRequest.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fRequestUUID), null);
            try {
                this.getTeamBuildRequestClient().startBuild(buildRequestHandle, IBuildResult.PROPERTIES_REQUIRED, null);
                buildRequest = (IBuildRequest)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildRequestHandle, 1, this.getProgressMonitor());
                if (!this.isVerbose()) return buildRequest;
                this.log(NLS.bind((String)AntMessages.StartBuildTask_START_BUILD_FOR_EXISTING_REQUEST, (Object)buildRequest.getBuildDefinitionInstance().getBuildDefinitionId()));
                return buildRequest;
            }
            catch (ItemNotFoundException e) {
                throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)BUILD_REQUEST_UUID, (Object)this.fRequestUUID), (Throwable)e);
            }
        } else {
            IBuildDefinition buildDefinition = this.getBuildDefinition(this.fBuildDefinitionId);
            IBuildEngine buildEngine = this.getBuildEngine(this.fEngineId);
            buildRequest = this.getTeamBuildRequestClient().requestAndStartBuild((IBuildDefinitionHandle)buildDefinition, (IBuildEngineHandle)buildEngine, this.getProgressMonitor());
            if (!this.isVerbose()) return buildRequest;
            this.log(NLS.bind((String)AntMessages.StartBuildTask_START_BUILD_FOR_NEW_REQUEST, (Object)buildRequest.getBuildDefinitionInstance().getBuildDefinitionId()));
        }
        return buildRequest;
    }

    private void setBuildLabel(IBuildRequest buildRequest, String buildLabel) throws TeamRepositoryException {
        if (buildLabel != null) {
            IBuildResult buildResult = (IBuildResult)this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)buildRequest.getBuildResult(), 1, Arrays.asList(IBuildResult.PROPERTIES_VIEW_ITEM), this.getProgressMonitor());
            buildResult = (IBuildResult)buildResult.getWorkingCopy();
            buildResult.setLabel(buildLabel);
            this.getTeamBuildClient().save(buildResult, this.getProgressMonitor());
        }
    }

    private void createAntProperties(IBuildRequest buildRequest) throws TeamRepositoryException {
        IBuildEngineHandle handler = buildRequest.getHandler();
        IBuildEngine buildEngine = (IBuildEngine)this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)handler, 0, Collections.singleton(IBuildEngine.PROPERTY_ID), null);
        Map<String, String> collectedProperties = this.collectProperties(new HashMap<String, String>(), buildEngine.getProperties());
        IBuildDefinitionInstance typeInstance = buildRequest.getBuildDefinitionInstance();
        if (typeInstance != null) {
            collectedProperties = this.collectProperties(collectedProperties, typeInstance.getProperties());
        }
        this.createAntProperties(collectedProperties);
    }

    private void createAntProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propertyValue = this.getProject().getProperty(entry.getKey());
            if (entry.getValue().equals(propertyValue)) continue;
            this.getProject().setProperty(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> collectProperties(Map<String, String> collectedProperties, List buildProperties) {
        for (IBuildProperty buildProperty : buildProperties) {
            collectedProperties.put(buildProperty.getName(), buildProperty.getValue());
        }
        return collectedProperties;
    }

    private void setResultUUIDProperty(IBuildRequest buildRequest, String antPropety) {
        this.fResultUUID = buildRequest.getBuildResult().getItemId().getUuidValue();
        if (antPropety != null) {
            this.getProject().setProperty(antPropety, this.fResultUUID);
        }
    }

    private void writeResultUUIDFile(IBuildRequest buildRequest, File propertyFile) throws IOException {
        String resultUUID = buildRequest.getBuildResult().getItemId().getUuidValue();
        if (propertyFile != null) {
            this.createPropertiesFile(this.fResultUUIDFile, this.fResultUUIDProperty, resultUUID);
            if (this.isVerbose()) {
                this.log(NLS.bind((String)AntMessages._WRITE_BUILD_PROPERTY, (Object[])new String[]{BUILD_RESULT_UUID_PROPERTY, resultUUID, this.fResultUUIDFile.getAbsolutePath()}));
            }
        }
    }

    private IBuildDefinition getBuildDefinition(String buildDefinitionId) throws TeamRepositoryException, BuildException {
        IBuildDefinition buildDefinition = this.getTeamBuildClient().getBuildDefinition(buildDefinitionId, this.getProgressMonitor());
        if (buildDefinition == null) {
            throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)BUILD_DEFINITION_ID, (Object)buildDefinitionId));
        }
        return buildDefinition;
    }

    private IBuildEngine getBuildEngine(String engineId) throws TeamRepositoryException {
        IBuildEngine buildEngine = this.getTeamBuildClient().getBuildEngine(engineId, this.getProgressMonitor());
        if (buildEngine == null) {
            throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)ENGINE_ID, (Object)engineId));
        }
        return buildEngine;
    }

    public void setBuildDefinitionId(String buildDefinitionId) {
        this.fBuildDefinitionId = buildDefinitionId;
    }

    public void setEngineId(String engineId) {
        this.fEngineId = engineId;
    }

    public void setRequestUUID(String requestUUID) {
        this.fRequestUUID = requestUUID;
    }

    public void setResultUUIDProperty(String resultUUIDProperty) {
        this.fResultUUIDProperty = resultUUIDProperty;
    }

    public void setResultUUIDFile(File resultUUIDFile) {
        this.fResultUUIDFile = resultUUIDFile;
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.fAutoComplete = autoComplete;
    }
}

