/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public final class RequestBuildTask
extends AbstractTeamBuildTask {
    public static final String BUILD_DEFINITION_ID = "buildDefinitionId";
    public static final String BUILD_REQUEST_UUID_PROPERTY = "requestUUIDProperty";
    public static final String BUILD_OVERRIDE_PROPERTIES_FILE_PROPERTY = "overridePropertiesFile";
    public static final String BUILD_DELETE_PROPERTIES_FILE_PROPERTY = "deletePropertiesFile";
    private String fBuildDefinitionId = null;
    private String fRequestUUIDProperty = null;
    private File fOverrideProperties = null;
    private File fDeleteProperties = null;

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_DEFINITION_ID, this.fBuildDefinitionId, true));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_REQUEST_UUID_PROPERTY, this.fRequestUUIDProperty, false));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(BUILD_OVERRIDE_PROPERTIES_FILE_PROPERTY, this.fOverrideProperties, false, false));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(BUILD_DELETE_PROPERTIES_FILE_PROPERTY, this.fDeleteProperties, false, false));
    }

    protected void doExecute() throws Exception {
        IBuildDefinition buildDefinition = this.getBuildDefinition(this.fBuildDefinitionId);
        IBuildRequest buildRequest = this.getTeamBuildRequestClient().requestBuild((IBuildDefinitionHandle)buildDefinition, this.getProperties(this.fOverrideProperties), this.getProperties(this.fDeleteProperties), true, this.getProgressMonitor());
        if (buildRequest != null) {
            this.setRequestUUIDProperty(buildRequest, this.fRequestUUIDProperty);
            if (this.isVerbose()) {
                this.log(NLS.bind((String)AntMessages.RequestBuildTask_SUCCESSFULLY_REQUEST_BUILD, (Object)this.fBuildDefinitionId));
            }
        } else {
            String message = NLS.bind((String)AntMessages.RequestBuildTask_UNABLE_TO_REQUEST_BUILD, (Object)this.fBuildDefinitionId);
            if (this.shouldFailOnError()) {
                throw new BuildException(message);
            }
            this.log(message, 1);
        }
    }

    private IBuildProperty[] getProperties(File propertiesFile) throws IOException {
        IBuildProperty[] buildProperties = null;
        if (propertiesFile != null) {
            Properties properties = new Properties();
            FileInputStream inputStream = new FileInputStream(propertiesFile);
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
            if (properties.size() > 0) {
                buildProperties = new IBuildProperty[properties.size()];
                Enumeration<Object> keys = properties.keys();
                int i = 0;
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    buildProperties[i] = BuildItemFactory.createBuildProperty();
                    buildProperties[i].setName(key);
                    buildProperties[i].setValue(properties.getProperty(key));
                    ++i;
                }
            }
        }
        return buildProperties;
    }

    private IBuildDefinition getBuildDefinition(String buildDefinitionId) throws TeamRepositoryException, BuildException {
        IBuildDefinition buildDefinition = this.getTeamBuildClient().getBuildDefinition(buildDefinitionId, this.getProgressMonitor());
        if (buildDefinition == null) {
            throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)BUILD_DEFINITION_ID, (Object)buildDefinitionId));
        }
        return buildDefinition;
    }

    private void setRequestUUIDProperty(IBuildRequest buildRequest, String antPropety) {
        if (antPropety != null) {
            this.getProject().setProperty(antPropety, buildRequest.getItemId().getUuidValue());
        }
    }

    public void setBuildDefinitionId(String buildDefinitionId) {
        this.fBuildDefinitionId = buildDefinitionId;
    }

    public void setRequestUUIDProperty(String requestUUIDProperty) {
        this.fRequestUUIDProperty = requestUUIDProperty;
    }

    public void setOverridePropertiesFile(File overrideProperties) {
        this.fOverrideProperties = overrideProperties;
    }

    public void setDeletePropertiesFile(File deleteProperties) {
        this.fDeleteProperties = deleteProperties;
    }
}

