/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.internal.ant.AntMessages;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.osgi.util.NLS;

public class PluginOrganizerTask
extends Task {
    public static final String SOURCE_DIRECTORY = "sourceDirectory";
    public static final String TARGET_DIRECTORY = "targetDirectory";
    private File fSourceDirectory;
    private File fTargetDirectory;

    public void execute() throws BuildException {
        File[] directoriesToMove;
        if (this.fSourceDirectory == null) {
            throw new BuildException(AntMessages.PluginOrganizerTask_SOURCE_DIRECTORY_REQUIRED);
        }
        if (this.fTargetDirectory == null) {
            throw new BuildException(AntMessages.PluginOrganizerTask_TARGET_DIRECTORY_REQUIRED);
        }
        if (!this.fSourceDirectory.exists()) {
            throw new BuildException(NLS.bind((String)AntMessages.PluginOrganizerTask_SOURCE_DIRECTORY_MISSING, (Object)this.fSourceDirectory.getAbsolutePath()));
        }
        if (!this.fSourceDirectory.isDirectory()) {
            throw new BuildException(NLS.bind((String)AntMessages.PluginOrganizerTask_SOURCE_DIRECTORY_NOT_A_DIRECTORY, (Object)this.fSourceDirectory.getAbsolutePath()));
        }
        File pluginsDir = new File(this.fTargetDirectory, "plugins");
        File featuresDir = new File(this.fTargetDirectory, "features");
        pluginsDir.mkdirs();
        featuresDir.mkdirs();
        File[] fileArray = directoriesToMove = this.fSourceDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int n = directoriesToMove.length;
        int n2 = 0;
        while (n2 < n) {
            File directory = fileArray[n2];
            this.moveDirectory(directory, pluginsDir, featuresDir);
            ++n2;
        }
    }

    private void moveDirectory(File directory, File pluginsDir, File featuresDir) {
        if (this.isFeature(directory)) {
            directory.renameTo(new File(featuresDir, directory.getName()));
        } else if (this.isPlugin(directory)) {
            directory.renameTo(new File(pluginsDir, directory.getName()));
        }
    }

    private boolean isFeature(File directory) {
        File[] featureFiles = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase("feature.xml");
            }
        });
        return featureFiles != null && featureFiles.length != 0;
    }

    private boolean isPlugin(File directory) {
        File[] manifestFiles;
        File[] pluginFiles = directory.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase("plugin.xml");
            }
        });
        if (pluginFiles != null && pluginFiles.length > 0) {
            return true;
        }
        File[] metaInfDirectory = directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().equalsIgnoreCase("META-INF");
            }
        });
        return metaInfDirectory != null && metaInfDirectory.length > 0 && (manifestFiles = metaInfDirectory[0].listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.equalsIgnoreCase("manifest.mf");
            }
        })) != null && manifestFiles.length > 0;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.fSourceDirectory = sourceDirectory;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.fTargetDirectory = targetDirectory;
    }
}

