/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractFilePublisherTask;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.publishing.JdtCompileLogPublisher;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public final class JdtCompileLogPublisherTask
extends AbstractFilePublisherTask {
    public static final String COMPONENT_MAP = "componentMap";
    public static final String PDE_BUILD = "pdeBuild";
    private File fComponentMap = null;
    private boolean fPdeBuild = false;

    protected File getComponentMap() {
        return this.fComponentMap;
    }

    public void setPdeBuild(boolean pdeBuild) {
        this.fPdeBuild = pdeBuild;
    }

    public void setComponentMap(File componentMap) {
        this.fComponentMap = componentMap;
    }

    protected void collectAntAttributes(List antAttributes) {
        super.collectAntAttributes(antAttributes);
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(COMPONENT_MAP, this.fComponentMap, false, true));
        antAttributes.add(new AbstractTeamBuildTask.BooleanAntAttribute(PDE_BUILD, this.fPdeBuild, false));
    }

    protected void validateAttribute(AbstractTeamBuildTask.AntAttribute theAttribute) throws AbstractTeamBuildTask.IllegalAntAttributeException {
        if (this.isAttribute(theAttribute, COMPONENT_MAP)) {
            if (this.getComponentMap() != null && this.getComponentName() != null) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages._COMPONENT_NAME_AND_MAP_SET, (Object[])new String[]{"jdtCompileLogPublisher", "componentName", COMPONENT_MAP}));
            }
        } else {
            super.validateAttribute(theAttribute);
        }
    }

    protected void updateBuildResult() throws Exception {
        JdtCompileLogPublisher publisher = new JdtCompileLogPublisher();
        publisher.setPdeBuild(this.fPdeBuild);
        if (this.getComponentName() != null) {
            publisher.setComponentName(this.getComponentName());
        } else if (this.getComponentMap() != null) {
            publisher.setComponentMap(this.getComponentMap());
        }
        IBuildResult buildResult = this.getBuildResult(IBuildResult.PROPERTIES_COMPLETE);
        String absolutePath = this.getFile().getAbsolutePath();
        if (this.isVerbose()) {
            this.log(NLS.bind((String)AntMessages.JdtCompileLogPublisherTask_PUBLISHING_COMPILE_LOG, (Object)absolutePath));
        }
        Collection publishedResults = publisher.publish(buildResult, absolutePath, this.getTeamRepository(), this.getProgressMonitor());
        if (this.isVerbose()) {
            this.log(NLS.bind((String)AntMessages.JdtCompileLogPublisherTask_COMPILE_CONTRIBUTIONS_PUBLISHED, (Object)publishedResults.size(), (Object)this.getBuildIdentifier()));
        }
    }
}

