/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractFilePublisherTask;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.publishing.JUnitLogPublisher;
import java.io.File;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public final class JUnitLogPublisherTask
extends AbstractFilePublisherTask {
    public static final String COMPONENT_MAP = "componentMap";
    public static final String MAY_FAIL_PATTERN = "mayFailPattern";
    private File fComponentMap = null;
    private String fMayFailPattern = null;

    protected void collectAntAttributes(List antAttributes) {
        super.collectAntAttributes(antAttributes);
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(COMPONENT_MAP, this.fComponentMap, false, true));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(MAY_FAIL_PATTERN, this.getMayFailPattern(), false));
    }

    protected void validateAttribute(AbstractTeamBuildTask.AntAttribute theAttribute) throws AbstractTeamBuildTask.IllegalAntAttributeException {
        if (this.isAttribute(theAttribute, COMPONENT_MAP)) {
            if (this.getComponentMap() != null && this.getComponentName() != null) {
                throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages._COMPONENT_NAME_AND_MAP_SET, (Object[])new String[]{"junitLogPublisher", "componentName", COMPONENT_MAP}));
            }
        } else {
            super.validateAttribute(theAttribute);
        }
    }

    protected void updateBuildResult() throws Exception {
        JUnitLogPublisher publisher = new JUnitLogPublisher();
        if (this.getComponentName() != null) {
            publisher.setComponentName(this.getComponentName());
        } else if (this.getComponentMap() != null) {
            publisher.setComponentMap(this.getComponentMap());
        }
        IBuildResult buildResult = this.getBuildResult(IBuildResult.PROPERTIES_COMPLETE);
        String absolutePath = this.getFile().getAbsolutePath();
        if (this.isVerbose()) {
            this.log(NLS.bind((String)AntMessages.JUnitLogPublisherTask_PUBLISHING_JUNIT_LOG, (Object)absolutePath));
        }
        String[] publishErrors = publisher.publish(buildResult, absolutePath, this.getMayFailPattern(), this.getTeamRepository(), this.getProgressMonitor());
        if (this.isVerbose()) {
            this.log(NLS.bind((String)AntMessages.JUnitLogPublisherTask_JUNIT_CONTRIBUTIONS_PUBLISHED, (Object)publisher.getPublishedContributions().length, (Object)this.getBuildIdentifier()));
        }
        if (publishErrors.length > 0) {
            this.log(NLS.bind((String)AntMessages.JUnitLogPublisherTask_NON_FATAL_PUBLISHER_ERRORS, (Object)this.getFile().getAbsolutePath()), 1);
            String[] stringArray = publishErrors;
            int n = publishErrors.length;
            int n2 = 0;
            while (n2 < n) {
                String publishError = stringArray[n2];
                this.log("\t" + publishError, 1);
                ++n2;
            }
        }
    }

    protected File getComponentMap() {
        return this.fComponentMap;
    }

    protected String getMayFailPattern() {
        return this.fMayFailPattern;
    }

    public void setComponentMap(File componentMap) {
        this.fComponentMap = componentMap;
    }

    public void setMayFailPattern(String mayFailPattern) {
        this.fMayFailPattern = mayFailPattern;
    }
}

