/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public final class GetNextBuildRequestTask
extends AbstractTeamBuildTask {
    public static final String ENGINE_ID = "engineId";
    public static final String BUILD_REQUEST_UUID_PROPERTY = "requestUUIDProperty";
    public static final String BUILD_REQUEST_UUID_FILE = "requestUUIDFile";
    public static final String BUILD_DEFINITION_ID_PROPERTY = "buildDefinitionIdProperty";
    public static final String BUILD_DEFINITION_ID = "buildDefinitionId";
    private String fEngineId = null;
    private String fRequestUUIDProperty = null;
    private File fRequestUUIDFile = null;
    private String fBuildDefinitionIdProperty = null;
    private String fBuildDefinitionId = null;

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(ENGINE_ID, this.fEngineId, true));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_REQUEST_UUID_PROPERTY, this.fRequestUUIDProperty, true));
        antAttributes.add(new AbstractTeamBuildTask.FileAntAttribute(BUILD_REQUEST_UUID_FILE, this.fRequestUUIDFile, false, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_DEFINITION_ID_PROPERTY, this.fBuildDefinitionIdProperty, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_DEFINITION_ID, this.fBuildDefinitionId, false));
    }

    protected void validateAttribute(AbstractTeamBuildTask.AntAttribute theAttribute) throws AbstractTeamBuildTask.IllegalAntAttributeException {
        super.validateAttribute(theAttribute);
        if (this.isAttribute(theAttribute, BUILD_DEFINITION_ID_PROPERTY) && theAttribute.getValue() != null && this.fBuildDefinitionId != null) {
            throw new AbstractTeamBuildTask.IllegalAntAttributeException(NLS.bind((String)AntMessages.GetNextBuildRequestTask_BUILD_DEFINITION_ID_PROPERTY_NOT_APPLICABLE, (Object[])new Object[]{BUILD_DEFINITION_ID_PROPERTY, BUILD_DEFINITION_ID}));
        }
    }

    protected void doExecute() throws Exception {
        IBuildEngine buildEngine = this.getBuildEngine(this.fEngineId);
        IBuildRequest buildRequest = null;
        buildRequest = this.fBuildDefinitionId != null ? this.getTeamBuildRequestClient().getNextRequest(this.fBuildDefinitionId, (IBuildEngineHandle)buildEngine, IBuildRequest.PROPERTIES_COMPLETE, this.getProgressMonitor()) : this.getTeamBuildRequestClient().getNextRequest((IBuildEngineHandle)buildEngine, IBuildRequest.PROPERTIES_COMPLETE, this.getProgressMonitor());
        if (buildRequest != null) {
            this.setRequestUUIDProperty(buildRequest, this.fRequestUUIDProperty);
            this.writeRequestUUIDFile(buildRequest, this.fRequestUUIDFile);
            this.createBuildDefinitionProperties(buildRequest);
            if (this.isVerbose()) {
                this.log(NLS.bind((String)AntMessages.GetNextBuildRequestTask_RETRIEVED_BUILD_REQUEST, (Object)this.fEngineId, (Object)buildRequest.getBuildDefinitionInstance().getBuildDefinitionId()));
            }
        } else if (this.isVerbose()) {
            this.log(NLS.bind((String)AntMessages.GetNextBuildRequestTask_NO_REQUEST_FOUND, (Object)this.fEngineId));
        }
    }

    protected IBuildEngine getBuildEngine(String engineId) throws TeamRepositoryException {
        IBuildEngine buildEngine = this.getTeamBuildClient().getBuildEngine(engineId, this.getProgressMonitor());
        if (buildEngine == null) {
            throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)ENGINE_ID, (Object)engineId));
        }
        return buildEngine;
    }

    private void setRequestUUIDProperty(IBuildRequest buildRequest, String antPropety) {
        String requestUUID = buildRequest.getItemId().getUuidValue();
        if (antPropety != null) {
            this.getProject().setProperty(antPropety, requestUUID);
        }
    }

    private void writeRequestUUIDFile(IBuildRequest buildRequest, File propertyFile) throws IOException {
        String requestUUID = buildRequest.getItemId().getUuidValue();
        if (propertyFile != null) {
            this.createPropertiesFile(this.fRequestUUIDFile, this.fRequestUUIDProperty, requestUUID);
            if (this.isVerbose()) {
                this.log(NLS.bind((String)AntMessages._WRITE_BUILD_PROPERTY, (Object[])new String[]{BUILD_REQUEST_UUID_PROPERTY, requestUUID, this.fRequestUUIDFile.getAbsolutePath()}));
            }
        }
    }

    private void createBuildDefinitionProperties(IBuildRequest buildRequest) {
        IBuildDefinitionInstance typeInstance = buildRequest.getBuildDefinitionInstance();
        if (typeInstance != null) {
            if (this.fBuildDefinitionIdProperty != null) {
                this.getProject().setProperty(this.fBuildDefinitionIdProperty, typeInstance.getBuildDefinitionId());
            }
            List props = typeInstance.getProperties();
            for (IBuildProperty buildProperty : props) {
                this.getProject().setProperty(buildProperty.getName(), buildProperty.getValue());
            }
        }
    }

    public void setEngineId(String engineId) {
        this.fEngineId = engineId;
    }

    public void setRequestUUIDProperty(String requestUUIDProperty) {
        this.fRequestUUIDProperty = requestUUIDProperty;
    }

    public void setRequestUUIDFile(File requestUUIDFile) {
        this.fRequestUUIDFile = requestUUIDFile;
    }

    public void setBuildDefinitionIdProperty(String buildDefinitionIdProperty) {
        this.fBuildDefinitionIdProperty = buildDefinitionIdProperty;
    }

    public void setBuildDefinitionId(String buildDefinitionId) {
        this.fBuildDefinitionId = buildDefinitionId;
    }
}

