/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.listener.TeamBuildListener;
import com.ibm.team.build.ant.task.AbstractPublisherTask;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;

public final class CompleteBuildTask
extends AbstractPublisherTask {
    public static final String BUILD_STATUS = "status";
    public static final String BUILD_LABEL = "label";
    public static final String BUILD_NOT_NECESSARY = "buildNotNecessary";
    private String fStatus = null;
    private String fLabel = null;
    private boolean fBuildNotNecessary = false;

    protected void collectAntAttributes(List antAttributes) {
        super.collectAntAttributes(antAttributes);
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_STATUS, this.fStatus, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_LABEL, this.fLabel, false));
        antAttributes.add(new AbstractTeamBuildTask.BooleanAntAttribute(BUILD_NOT_NECESSARY, this.fBuildNotNecessary, false));
    }

    protected void updateBuildResult() throws Exception {
        IBuildResult buildResult = this.getBuildResult(new String[]{IBuildResult.PROPERTY_BUILD_STATUS, IBuildResult.PROPERTY_LABEL});
        try {
            if (!this.fBuildNotNecessary) {
                buildResult = this.updateStatusAndLabel(buildResult, this.fStatus, this.fLabel);
            }
            this.getTeamBuildRequestClient().makeBuildComplete((IBuildResultHandle)buildResult, this.fBuildNotNecessary, IBuildResult.PROPERTIES_REQUIRED, this.getProgressMonitor());
            this.logBuildResultChanges();
            TeamBuildListener.completeBuild((IBuildResultHandle)buildResult);
        }
        catch (TeamRepositoryException exception) {
            String message = NLS.bind((String)AntMessages.CompleteBuildTask_FAILED_TO_COMPLETE_BUILD, (Object)buildResult.getLabel(), (Object)this.fBuildNotNecessary);
            throw new BuildException(message, (Throwable)exception);
        }
    }

    private void logBuildResultChanges() {
        if (this.isVerbose()) {
            IBuildResult buildResult = this.getBuildResult(new String[]{IBuildResult.PROPERTY_LABEL});
            this.log(NLS.bind((String)AntMessages.CompleteBuildTask_COMPLETED_BUILD_SUCCESSFULLY, (Object)buildResult.getLabel(), (Object)this.fBuildNotNecessary));
        }
    }

    private IBuildResult updateStatusAndLabel(IBuildResult buildResult, String status, String buildLabel) throws TeamRepositoryException {
        boolean doSave = false;
        buildResult = (IBuildResult)buildResult.getWorkingCopy();
        BuildStatus resultStatus = buildResult.getStatus();
        if (status != null && resultStatus != null && !resultStatus.equals((Object)BuildStatus.valueOf((String)status))) {
            buildResult.setStatus(BuildStatus.valueOf((String)status));
            doSave = true;
        }
        String resultLabel = buildResult.getLabel();
        if (buildLabel != null && resultLabel != null && !resultLabel.equals(buildLabel)) {
            buildResult.setLabel(buildLabel);
            doSave = true;
        }
        if (doSave) {
            return this.getTeamBuildClient().save(buildResult, this.getProgressMonitor());
        }
        return buildResult;
    }

    public void setStatus(AbstractPublisherTask.BuildStatusAttribute status) {
        this.fStatus = status.getValue();
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public void setBuildNotNecessary(boolean buildNotNecessary) {
        this.fBuildNotNecessary = buildNotNecessary;
    }
}

