/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractPublisherTask;
import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.common.helper.TagsHelper;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public final class BuildResultPublisherTask
extends AbstractPublisherTask {
    public static final String BUILD_LABEL = "label";
    public static final String BUILD_TAGS = "tags";
    public static final String DELETE_ALLOWED = "deleteAllowed";
    private String fLabel = null;
    private String fTags = null;
    private boolean fDeleteAllowed = true;
    private boolean fDeleteAllowedSet = false;

    protected void collectAntAttributes(List antAttributes) {
        super.collectAntAttributes(antAttributes);
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_LABEL, this.fLabel, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(BUILD_TAGS, this.fTags, false));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(DELETE_ALLOWED, this.fDeleteAllowedSet ? Boolean.toString(this.fDeleteAllowed) : null, false));
    }

    protected void updateBuildResult() throws Exception {
        IBuildResult buildResult = this.getBuildResult(new String[]{IBuildResult.PROPERTY_LABEL, IBuildResult.PROPERTY_TAGS, IBuildResult.PROPERTY_DELETE_ALLOWED});
        buildResult = (IBuildResult)buildResult.getWorkingCopy();
        boolean modified = false;
        if (this.fLabel != null) {
            if (this.isVerbose()) {
                this.log(NLS.bind((String)AntMessages.BuildResultPublisherTask_UPDATE_LABEL, (Object)this.getBuildIdentifier(), (Object)this.fLabel));
            }
            buildResult.setLabel(this.fLabel);
            modified = true;
        }
        if (this.fTags != null) {
            buildResult.setTags(TagsHelper.normalizeTags((String)this.fTags));
            modified = true;
        }
        if (this.fDeleteAllowedSet) {
            buildResult.setDeleteAllowed(this.fDeleteAllowed);
            modified = true;
        }
        if (modified) {
            this.getTeamBuildClient().save(buildResult, this.getProgressMonitor());
        }
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public void setTags(String tags) {
        this.fTags = tags;
    }

    public void setDeleteAllowed(boolean deleteAllowed) {
        this.fDeleteAllowed = deleteAllowed;
        this.fDeleteAllowedSet = true;
    }
}

