/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.listener.TeamBuildListener;
import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.client.ITeamBuildRequestClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.internal.PasswordHelper;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.build.internal.client.ProxyHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractTeamBuildTask
extends Task {
    public static final String REPOSITORY_ADDRESS = "repositoryAddress";
    public static final String PASSWORD = "password";
    public static final String PASSWORD_FILE = "passwordFile";
    public static final String USER_ID = "userId";
    public static final String VERBOSE = "verbose";
    public static final String FAIL_ON_ERROR = "failOnError";
    private ITeamBuildClient fTeamBuildClient = null;
    private ITeamBuildRequestClient fTeamBuildRequestClient = null;
    private ITeamRepository fTeamRepository = null;
    private String fRepositoryAddress = null;
    private String fUserId = null;
    private static final String DEFAULT_PASSWORD = "";
    private String fPassword = null;
    private File fPasswordFile = null;
    private boolean fVerbose = false;
    private boolean fFailOnError = true;

    static {
        BuildItemFactory.initializeBuildPackage();
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
    }

    protected ITeamBuildClient getTeamBuildClient() throws TeamRepositoryException {
        if (this.fTeamBuildClient == null) {
            this.fTeamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)this.getTeamRepository());
        }
        return this.fTeamBuildClient;
    }

    protected ITeamBuildRequestClient getTeamBuildRequestClient() throws TeamRepositoryException {
        if (this.fTeamBuildRequestClient == null) {
            this.fTeamBuildRequestClient = ClientFactory.getTeamBuildRequestClient((ITeamRepository)this.getTeamRepository());
        }
        return this.fTeamBuildRequestClient;
    }

    protected IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected ITeamRepository getTeamRepository() throws TeamRepositoryException {
        if (this.fTeamRepository == null) {
            this.fTeamRepository = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(this.getRepositoryAddress());
            final String userId = this.getUserId();
            final String password = this.getProvidedPassword();
            this.fTeamRepository.registerLoginHandler(new ITeamRepository.ILoginHandler(){

                public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                    return new ITeamRepository.ILoginHandler.ILoginInfo(){

                        public String getUserId() {
                            return userId;
                        }

                        public String getPassword() {
                            return password;
                        }
                    };
                }
            });
            String host = ProxyHelper.getProxyHost((String)this.getRepositoryAddress());
            if (host != null) {
                int port = ProxyHelper.getProxyPort((String)this.getRepositoryAddress());
                this.fTeamRepository.setProxy(host, port, userId, password);
                if (this.isVerbose()) {
                    this.log(NLS.bind((String)AntMessages.AbstractTeamBuildTask_USING_PROXY, (Object)host, (Object[])new Object[]{port, this.getRepositoryAddress()}));
                }
            } else if (this.isVerbose()) {
                this.log(NLS.bind((String)AntMessages.AbstractTeamBuildTask_NOT_USING_PROXY, (Object)this.getRepositoryAddress(), (Object[])new Object[0]));
            }
        }
        if (!this.fTeamRepository.loggedIn()) {
            this.fTeamRepository.login(this.getProgressMonitor());
        }
        return this.fTeamRepository;
    }

    protected String getProvidedPassword() throws TeamRepositoryException {
        File passwordFile = this.getPasswordFile();
        if (passwordFile != null) {
            try {
                return this.decryptPassword(passwordFile);
            }
            catch (Exception exception) {
                throw new TeamRepositoryException(NLS.bind((String)AntMessages.AbstractTeamBuildTask_CANT_GET_PASSWORD_FROM_FILE, (Object)passwordFile.getAbsolutePath(), (Object[])new Object[0]), (Throwable)exception);
            }
        }
        return this.getPassword();
    }

    protected String decryptPassword(File passwordFile) throws GeneralSecurityException, IOException {
        return PasswordHelper.getPassword(passwordFile);
    }

    protected void logout() {
        this.fTeamRepository.logout();
    }

    public void setUserId(String userId) {
        this.fUserId = userId;
    }

    public String getUserId() {
        return this.fUserId;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }

    public String getPassword() {
        if (this.fPassword == null) {
            return DEFAULT_PASSWORD;
        }
        return this.fPassword;
    }

    public void setPasswordFile(File passwordFile) {
        this.fPasswordFile = passwordFile;
    }

    public File getPasswordFile() {
        return this.fPasswordFile;
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.fRepositoryAddress = repositoryAddress;
    }

    public String getRepositoryAddress() {
        return this.fRepositoryAddress;
    }

    public void setVerbose(boolean verbose) {
        this.fVerbose = verbose;
    }

    public boolean isVerbose() {
        return this.fVerbose;
    }

    public void setFailOnError(boolean failOnError) {
        this.fFailOnError = failOnError;
    }

    public boolean shouldFailOnError() {
        return this.fFailOnError;
    }

    protected abstract void collectAntAttributes(List var1);

    protected abstract void doExecute() throws Exception;

    public final void execute() throws BuildException {
        block21: {
            long startTime = System.currentTimeMillis();
            this.configureTaskAttributes();
            try {
                try {
                    this.validateAntTaskAttributes(this.getAntAttributes());
                    this.doExecute();
                }
                catch (Exception exception) {
                    if (this.shouldFailOnError()) {
                        if (this.isVerbose()) {
                            if (exception instanceof IllegalAntAttributeException) {
                                this.log(exception.toString(), 0);
                            } else {
                                this.logException(exception, 0);
                            }
                        }
                        if (exception instanceof BuildException) {
                            throw (BuildException)exception;
                        }
                        throw new BuildException((Throwable)exception);
                    }
                    this.log(AntMessages.AbstractTeamBuildTask_IGNORING_FAILURE, 1);
                    if (this.isVerbose() && !(exception instanceof IllegalAntAttributeException)) {
                        this.logException(exception, 1);
                    } else {
                        this.log(exception.toString(), 1);
                    }
                    TeamBuildListener.incrementBuildToolkitTime(System.currentTimeMillis() - startTime);
                    if (this.fTeamRepository == null || !this.fTeamRepository.loggedIn()) break block21;
                    try {
                        this.logout();
                    }
                    finally {
                        this.fTeamRepository = null;
                    }
                }
            }
            finally {
                TeamBuildListener.incrementBuildToolkitTime(System.currentTimeMillis() - startTime);
                if (this.fTeamRepository != null && this.fTeamRepository.loggedIn()) {
                    try {
                        this.logout();
                    }
                    finally {
                        this.fTeamRepository = null;
                    }
                }
            }
        }
    }

    protected final void logException(Exception exception, int messagePriorty) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        this.log(stringWriter.toString(), messagePriorty);
    }

    protected void configureTaskAttributes() {
    }

    protected final AntAttribute[] getAntAttributes() {
        LinkedList<AntAttribute> antAttributes = new LinkedList<AntAttribute>();
        antAttributes.add(new AntAttribute(REPOSITORY_ADDRESS, this.getRepositoryAddress(), true));
        antAttributes.add(new AntAttribute(USER_ID, this.getUserId(), true));
        antAttributes.add(new AntAttribute(PASSWORD, this.getPassword(), false){

            public void validate() throws IllegalAntAttributeException {
            }
        });
        antAttributes.add(new FileAntAttribute(PASSWORD_FILE, this.getPasswordFile(), false, true));
        antAttributes.add(new BooleanAntAttribute(VERBOSE, this.isVerbose(), false));
        antAttributes.add(new BooleanAntAttribute(FAIL_ON_ERROR, this.shouldFailOnError(), false));
        this.collectAntAttributes(antAttributes);
        AntAttribute[] theAttributes = new AntAttribute[antAttributes.size()];
        return antAttributes.toArray(theAttributes);
    }

    private void validateAntTaskAttributes(AntAttribute[] antAttributes) throws IllegalAntAttributeException {
        int i = 0;
        while (i < antAttributes.length) {
            this.validateAttribute(antAttributes[i]);
            ++i;
        }
    }

    protected void validateAttribute(AntAttribute theAttribute) throws IllegalAntAttributeException {
        if ((this.isAttribute(theAttribute, PASSWORD) || this.isAttribute(theAttribute, PASSWORD_FILE)) && this.fPassword != null && this.fPasswordFile != null) {
            throw new IllegalAntAttributeException(NLS.bind((String)AntMessages.AbstractTeamBuildTask_CANT_SPECIFY_BOTH_PASSWORD_AND_PASSWORD_FILE, (Object)PASSWORD, (Object[])new Object[]{PASSWORD_FILE}));
        }
        theAttribute.validate();
    }

    protected final boolean isAttribute(AntAttribute theAttribute, String attributeName) {
        return theAttribute.getName().equals(attributeName);
    }

    protected void createPropertiesFile(File file, String name, String value) throws IOException {
        Properties properties = new Properties();
        properties.put(name, value);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            properties.store(outputStream, null);
        }
        finally {
            outputStream.close();
        }
    }

    protected static class AntAttribute {
        private String fName = null;
        private String fValue = null;
        private boolean fRequired = false;

        public AntAttribute(String attributeName, String attributeValue, boolean attributeRequired) {
            this.setName(attributeName);
            this.setValue(attributeValue);
            this.setRequired(attributeRequired);
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String attributeName) {
            this.fName = attributeName;
        }

        public boolean isRequired() {
            return this.fRequired;
        }

        public void setRequired(boolean attributeRequired) {
            this.fRequired = attributeRequired;
        }

        public String getValue() {
            return this.fValue;
        }

        public void setValue(String attributeValue) {
            this.fValue = attributeValue;
        }

        public void validate() throws IllegalAntAttributeException {
            if (this.isRequired() && this.getValue() == null) {
                this.handleMissingRequiredAttribute(this.getName());
            } else if (this.getValue() != null && this.getValue().trim().length() == 0) {
                this.handleIllegalAttributeValue(this.getName(), this.getValue());
            }
        }

        protected final void handleMissingRequiredAttribute(String attributeName) throws IllegalAntAttributeException {
            String message = NLS.bind((String)AntMessages.AbstractTeamBuildTask_MISSING_REQUIRED_ATTRIBUTE, (Object)attributeName, (Object[])new Object[0]);
            throw new IllegalAntAttributeException(message);
        }

        protected final void handleIllegalAttributeValue(String attributeName, String attributeValue) throws IllegalAntAttributeException {
            String message = NLS.bind((String)AntMessages.AbstractTeamBuildTask_ILLEGAL_ATTRIBUTE_VALUE, (Object)attributeName, (Object[])new Object[]{attributeValue});
            throw new IllegalAntAttributeException(message);
        }
    }

    protected static class BooleanAntAttribute
    extends AntAttribute {
        public BooleanAntAttribute(String attributeName, boolean attributeValue, boolean attributeRequired) {
            super(attributeName, Boolean.toString(attributeValue), attributeRequired);
        }
    }

    protected static class FileAntAttribute
    extends AntAttribute {
        private boolean fFileMustExist = false;

        public FileAntAttribute(String attributeName, File attributeValue, boolean attributeRequired, boolean fileMustExist) {
            super(attributeName, attributeValue == null ? null : attributeValue.getPath(), attributeRequired);
            this.fFileMustExist = fileMustExist;
        }

        public void validate() throws IllegalAntAttributeException {
            super.validate();
            if (this.getValue() != null && !this.isValidFile()) {
                String message = NLS.bind((String)AntMessages.AbstractTeamBuildTask_PATH_TO_NON_EXISTENT_FILE, (Object)this.getName(), (Object[])new Object[]{this.getValue()});
                throw new IllegalAntAttributeException(message);
            }
        }

        private boolean isValidFile() {
            File file;
            return !this.fFileMustExist || (file = new File(this.getValue())).exists();
        }
    }

    protected static class IllegalAntAttributeException
    extends BuildException {
        private static final long serialVersionUID = 1L;

        public IllegalAntAttributeException(String message) {
            super(message);
        }

        public IllegalAntAttributeException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class LongAntAttribute
    extends AntAttribute {
        public LongAntAttribute(String attributeName, long attributeValue, boolean attributeRequired) {
            super(attributeName, Long.toString(attributeValue), attributeRequired);
        }
    }

    protected static class UUIDAntAttribute
    extends AntAttribute {
        public UUIDAntAttribute(String attributeName, String attributeValue, boolean attributeRequired) {
            super(attributeName, attributeValue, attributeRequired);
        }

        public void validate() throws IllegalAntAttributeException {
            super.validate();
            if (this.getValue() != null) {
                try {
                    UUID.valueOf((String)this.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.handleIllegalAttributeValue(this.getName(), this.getValue());
                }
            }
        }
    }
}

