/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.task;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractPublisherTask
extends AbstractTeamBuildTask {
    public static final String BUILD_RESULT_UUID = "buildResultUUID";
    public static final String COMPONENT_NAME = "componentName";
    private String fBuildResultUUID = null;
    private String fComponentName = null;

    protected String getComponentName() {
        return this.fComponentName;
    }

    public void setComponentName(String componentName) {
        this.fComponentName = componentName;
    }

    protected abstract void updateBuildResult() throws Exception;

    protected final void doExecute() throws Exception {
        try {
            this.updateBuildResult();
        }
        finally {
            this.updateLastContactTime();
        }
    }

    protected void collectAntAttributes(List antAttributes) {
        antAttributes.add(new AbstractTeamBuildTask.UUIDAntAttribute(BUILD_RESULT_UUID, this.fBuildResultUUID, true));
        antAttributes.add(new AbstractTeamBuildTask.AntAttribute(COMPONENT_NAME, this.fComponentName, false));
    }

    protected final IBuildResult getBuildResult(String[] properties) throws BuildException {
        try {
            IBuildResultHandle resultHandle = this.getBuildResultHandle();
            if (properties == IBuildResult.PROPERTIES_COMPLETE) {
                return (IBuildResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)resultHandle, 1, this.getProgressMonitor());
            }
            return (IBuildResult)this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)resultHandle, 1, Arrays.asList(properties), this.getProgressMonitor());
        }
        catch (ItemNotFoundException e) {
            throw new BuildException(NLS.bind((String)AntMessages._ITEM_WITH_ID_NOT_FOUND, (Object)IBuildResult.ITEM_TYPE.getName(), (Object)this.getBuildResultUUID()), (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected String getBuildIdentifier() {
        IBuildResult buildResult = this.getBuildResult(new String[]{IBuildResult.PROPERTY_LABEL});
        String identifier = buildResult.getLabel();
        if (identifier == null || identifier.trim().length() == 0) {
            identifier = buildResult.getItemId().getUuidValue();
        }
        return identifier;
    }

    protected IBuildResultHandle getBuildResultHandle() throws TeamRepositoryException {
        return (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.getBuildResultUUID()), null);
    }

    private void updateLastContactTime() {
        try {
            IBuildResult buildResult = this.getBuildResult(new String[]{IBuildResult.PROPERTY_BUILD_STATE, IBuildResult.PROPERTY_BUILD_REQUESTS});
            List buildRequests = buildResult.getBuildRequests();
            if (buildRequests.size() > 0 && buildResult.getState() == BuildState.IN_PROGRESS) {
                List<String> requestProperties = Arrays.asList(IBuildRequest.PROPERTY_BUILD_ACTION, IBuildRequest.PROPERTY_HANDLER);
                for (IBuildRequestHandle buildRequestHandle : buildRequests) {
                    IBuildRequest buildRequest = (IBuildRequest)this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)buildRequestHandle, 1, requestProperties, this.getProgressMonitor());
                    if (!buildRequest.getBuildAction().getAction().equals("com.ibm.team.build.action.requestBuild") || buildRequest.getHandler() == null) continue;
                    this.getTeamBuildClient().setLastContactTime(buildRequest.getHandler(), null, this.getProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            this.log(NLS.bind((String)AntMessages.AbstractPublisherTask_UPDATE_LAST_CONTACT_TIME_FAILED, (Object)e.getLocalizedMessage()), 1);
            this.logException(e, 1);
        }
    }

    public void setBuildResultUUID(String buildResultUUID) {
        this.fBuildResultUUID = buildResultUUID;
    }

    protected String getBuildResultUUID() {
        return this.fBuildResultUUID;
    }

    public static class BuildStatusAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            BuildStatus[] values = BuildStatus.values();
            String[] validValues = new String[values.length];
            int i = 0;
            while (i < values.length) {
                validValues[i] = values[i].name();
                ++i;
            }
            return validValues;
        }
    }
}

