/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.ant.listener;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.ant.AntMessages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamBuildListener
implements BuildListener {
    public static final String VERBOSE_PROPERTY = "team.build.listener.verbose";
    private Collection MIN_PROPERTIES = Arrays.asList(IBuildResult.PROPERTY_BUILD_STATE, IBuildResult.PROPERTY_BUILD_DEFINITION, IBuildResult.PROPERTY_BUILD_STATUS);
    private static Hashtable<String, ITeamRepository> fgStartedBuilds;
    private static long fgTotalBuildToolkitTime;
    private Hashtable<String, Long> fTaskStartTimes = new Hashtable();
    private List<TaskDuration> fTaskDurations = new LinkedList<TaskDuration>();
    private Map<String, TaskDuration> fCombinedTaskDurations = new HashMap<String, TaskDuration>();

    static {
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        fgStartedBuilds = new Hashtable();
        fgTotalBuildToolkitTime = 0L;
    }

    public static void startBuild(IBuildResultHandle buildResultHandle, ITeamRepository teamRepository) {
        fgStartedBuilds.put(buildResultHandle.getItemId().getUuidValue(), teamRepository);
    }

    public static void completeBuild(IBuildResultHandle buildResultHandle) {
        fgStartedBuilds.remove(buildResultHandle.getItemId().getUuidValue());
    }

    public static void incrementBuildToolkitTime(long toolkitTimeTaken) {
        fgTotalBuildToolkitTime += toolkitTimeTaken;
    }

    public void buildFinished(BuildEvent event) {
        if (this.verboseLogging(event.getProject())) {
            this.printTaskDurations(event);
        }
        Enumeration<String> enumeratedBuilds = fgStartedBuilds.keys();
        while (enumeratedBuilds.hasMoreElements()) {
            String buildResultUUID = enumeratedBuilds.nextElement();
            try {
                ITeamRepository teamRepository = fgStartedBuilds.get(buildResultUUID);
                if (!teamRepository.loggedIn()) {
                    teamRepository.login(this.getProgressMonitor());
                }
                IItemHandle itemHandle = IBuildResult.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildResultUUID), null);
                IBuildResult buildResult = (IBuildResult)teamRepository.itemManager().fetchPartialItem(itemHandle, 1, this.MIN_PROPERTIES, this.getProgressMonitor());
                if (buildResult.getState() != BuildState.COMPLETED) {
                    if (event.getException() != null) {
                        buildResult = (IBuildResult)teamRepository.itemManager().fetchPartialItem(itemHandle, 1, this.MIN_PROPERTIES, this.getProgressMonitor()).getWorkingCopy();
                        buildResult.setStatus(BuildStatus.ERROR);
                        buildResult = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository).save(buildResult, this.getProgressMonitor());
                    }
                    ClientFactory.getTeamBuildRequestClient((ITeamRepository)teamRepository).makeBuildComplete((IBuildResultHandle)buildResult, false, IBuildResult.PROPERTIES_REQUIRED, this.getProgressMonitor());
                    TeamBuildListener.completeBuild((IBuildResultHandle)buildResult);
                    if (this.verboseLogging(event.getProject())) {
                        IBuildDefinition definition = (IBuildDefinition)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildResult.getBuildDefinition(), 0, this.getProgressMonitor());
                        event.getProject().log(NLS.bind((String)AntMessages.TeamBuildListener_AUTO_COMPLETE_BUILD, (Object)definition.getId(), (Object)buildResultUUID), 2);
                    }
                }
                teamRepository.logout();
            }
            catch (TeamRepositoryException e) {
                fgStartedBuilds.remove(buildResultUUID);
                event.getProject().log(NLS.bind((String)AntMessages.TeamBuildListener_FAILED_TO_AUTO_COMPLETE_BUILD, (Object)buildResultUUID), 1);
                event.getProject().log(e.getLocalizedMessage(), 1);
            }
        }
    }

    public void buildStarted(BuildEvent event) {
        fgTotalBuildToolkitTime = 0L;
    }

    public void messageLogged(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
        long taskFinishedTime = System.currentTimeMillis();
        String taskName = event.getTask().getTaskName();
        Long taskStartTime = this.fTaskStartTimes.get(taskName);
        if (taskStartTime != null) {
            Long duration = taskFinishedTime - taskStartTime;
            this.fTaskDurations.add(new TaskDuration(taskName, duration));
            TaskDuration taskDuration = this.fCombinedTaskDurations.get(taskName);
            taskDuration = taskDuration != null ? new TaskDuration(taskName, duration + taskDuration.getDuration()) : new TaskDuration(taskName, duration);
            this.fCombinedTaskDurations.put(taskName, taskDuration);
        }
    }

    public void taskStarted(BuildEvent event) {
        String taskName = event.getTask().getTaskName();
        if (taskName.equalsIgnoreCase("property") || taskName.equalsIgnoreCase("taskdef") || taskName.equalsIgnoreCase("echo") || taskName.equalsIgnoreCase("fail")) {
            return;
        }
        this.fTaskStartTimes.put(event.getTask().getTaskName(), System.currentTimeMillis());
    }

    private boolean verboseLogging(Project project) {
        return project.getProperty(VERBOSE_PROPERTY) != null;
    }

    private void printTaskDurations(BuildEvent event) {
        event.getProject().log(System.getProperty("line.separator"));
        event.getProject().log(System.getProperty("line.separator"));
        event.getProject().log(NLS.bind((String)AntMessages.TeamBuildListener_TOTAL_TOOLKIT_TIME, (Object)Float.valueOf(Float.valueOf(fgTotalBuildToolkitTime).floatValue() / 1000.0f)));
        if (!this.fCombinedTaskDurations.isEmpty()) {
            event.getProject().log(System.getProperty("line.separator"));
            event.getProject().log(AntMessages.TeamBuildListener_COMBINED_TASK_TIME);
            SortedSet<TaskDuration> sortedTaskDurations = this.getSortedTaskDurations();
            for (TaskDuration taskDuration : sortedTaskDurations) {
                Float duration = Float.valueOf(Float.valueOf(taskDuration.getDuration()).floatValue() / 1000.0f);
                event.getProject().log(NLS.bind((String)AntMessages.TeamBuildListener_TASK_DURATION, (Object)taskDuration.getTaskName(), (Object)duration));
            }
        }
        if (!this.fTaskDurations.isEmpty()) {
            event.getProject().log(System.getProperty("line.separator"));
            event.getProject().log(AntMessages.TeamBuildListener_SEPARATE_TASK_TIME);
            for (TaskDuration taskDuration : this.fTaskDurations) {
                Float duration = Float.valueOf(Float.valueOf(taskDuration.getDuration()).floatValue() / 1000.0f);
                event.getProject().log(NLS.bind((String)AntMessages.TeamBuildListener_TASK_DURATION, (Object)taskDuration.getTaskName(), (Object)duration));
            }
        }
    }

    private SortedSet<TaskDuration> getSortedTaskDurations() {
        TreeSet<TaskDuration> sortedTaskDurations = new TreeSet<TaskDuration>(new Comparator<TaskDuration>(){

            @Override
            public int compare(TaskDuration o1, TaskDuration o2) {
                return Long.valueOf(o2.getDuration()).compareTo(o1.getDuration());
            }
        });
        sortedTaskDurations.addAll(this.fCombinedTaskDurations.values());
        return sortedTaskDurations;
    }

    private IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    private class TaskDuration {
        final String fTaskName;
        final long fDuration;

        public TaskDuration(String taskName, long duration) {
            this.fTaskName = taskName;
            this.fDuration = duration;
        }

        protected String getTaskName() {
            return this.fTaskName;
        }

        protected long getDuration() {
            return this.fDuration;
        }
    }
}

