/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionablePathSegment {
    private ItemId<IFolder> parent;
    private String name;
    private static VersionablePathSegment root;

    private VersionablePathSegment(ItemId<IFolder> parent, String filename) {
        if (parent.getItemType() != IFolder.ITEM_TYPE) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.name = filename;
    }

    public static VersionablePathSegment pathFor(IVersionable folder) {
        return VersionablePathSegment.create(ItemUtil.getParent(folder), folder.getName());
    }

    public static VersionablePathSegment create(ItemId<IFolder> parent, String name) {
        return new VersionablePathSegment(VersionablePathSegment.asFolderItem(parent), name);
    }

    private static ItemId<IFolder> asFolderItem(ItemId<IFolder> itemId) {
        if (itemId.getItemType() == IFolder.ITEM_TYPE) {
            return itemId;
        }
        return new ItemId(IFolder.ITEM_TYPE, itemId.getItemUUID());
    }

    public static VersionablePathSegment emptyPath() {
        if (root == null) {
            root = VersionablePathSegment.create((ItemId<IFolder>)ItemId.getNullItem((IItemType)IFolder.ITEM_TYPE), "");
        }
        return root;
    }

    public boolean isResolved() {
        return this.parent.isNull();
    }

    public boolean isEmpty() {
        return this.parent.isNull() && this.name.equals("");
    }

    public ItemId<IFolder> getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionablePathSegment other = (VersionablePathSegment)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getFileExtension() {
        return new Path(this.name).getFileExtension();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return String.valueOf(this.parent.getItemUUID().getUuidValue()) + "/" + this.name;
    }
}

