/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import com.ibm.team.scm.client.internal.ScmServiceInterfaceProxy;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmClientLibraryContext
implements IClientLibraryContext {
    private IClientLibraryContext wrappedContext;
    private static Log log = LogFactory.getLog(ScmClientLibraryContext.class);
    private static boolean DEBUG_MISSINGMONITORS = true;

    public ScmClientLibraryContext(IClientLibraryContext context) {
        this.wrappedContext = context;
    }

    public Object callCancelableService(IClientLibraryContext.IServiceRunnable runnable, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.wrappedContext.callCancelableService(runnable, monitor);
    }

    public Object getServiceInterface(Class interfaceClass) {
        Object serviceImplementation = this.wrappedContext.getServiceInterface(interfaceClass);
        boolean isRest = serviceImplementation instanceof ITeamRestServiceClient;
        if (!isRest && ScmClientLibraryContext.needsProgress(interfaceClass)) {
            return ScmServiceInterfaceProxy.newServiceInterfaceProxy(interfaceClass, this.wrappedContext.getServiceInterface(interfaceClass), this);
        }
        return this.wrappedContext.getServiceInterface(interfaceClass);
    }

    public static boolean needsProgress(Class interfaceClass) {
        Method[] methods = interfaceClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (ScmClientLibraryContext.requiresProgressReporting(method.getParameterTypes())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean requiresProgressReporting(Class<?>[] parameterTypes) {
        int i = 0;
        while (i < parameterTypes.length) {
            Class<?> clazz = parameterTypes[i];
            if (IRepositoryProgressMonitor.class.equals(clazz)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IRepositoryProgressMonitor requiresProgressReporting(Method method, Object[] args) {
        if (method.getName().startsWith("saveProgress")) {
            return null;
        }
        boolean hasProgressArgument = ScmClientLibraryContext.requiresProgressReporting(method.getParameterTypes());
        int i = 0;
        while (i < args.length) {
            Object object = args[i];
            if (object instanceof IRepositoryProgressMonitor) {
                IRepositoryProgressMonitor monitor = (IRepositoryProgressMonitor)object;
                if (monitor.getWrappedMonitor() == null) {
                    IllegalArgumentException e = new IllegalArgumentException("IProgressMonitor instance not available: " + method.getDeclaringClass().getName() + "." + method.getName());
                    if (DEBUG_MISSINGMONITORS) {
                        log.warn((Object)"IRepositoryProgressMonitor is not wrapping a IProgressMonitor which means that the service call won't be cancellable", (Throwable)e);
                    }
                }
                return monitor;
            }
            ++i;
        }
        if (hasProgressArgument) {
            IllegalArgumentException e = new IllegalArgumentException("Specified progress monitor is null: " + method.getDeclaringClass().getName() + "." + method.getName());
            if (DEBUG_MISSINGMONITORS) {
                log.warn((Object)"Service interface method called with null progress monitor means that it won't be cancellable", (Throwable)e);
            }
        }
        return null;
    }

    public ITeamRepository teamRepository() {
        return this.wrappedContext.teamRepository();
    }

    public X509Certificate[] getServerCertificatePath() {
        return this.wrappedContext.getServerCertificatePath();
    }
}

