/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IHistoricBaselineIterator;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.internal.dto.MergedBaselineResult;
import com.ibm.team.scm.common.internal.dto.SynchronizationInfo;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedBaselineHistoryIterator
implements IHistoricBaselineIterator {
    private final MergedBaselineResult result;
    private final WorkspaceManager workspaceManager;
    private final IWorkspaceHandle workspace;
    private final IComponentHandle component;

    public MergedBaselineHistoryIterator(IWorkspaceHandle workspace, IComponentHandle component, MergedBaselineResult result, WorkspaceManager workspaceManager) {
        this.result = result;
        this.workspaceManager = workspaceManager;
        this.workspace = workspace;
        this.component = component;
    }

    @Override
    public List<? extends IBaselineHandle> getBaselines() {
        return this.result.getBaselines();
    }

    @Override
    public IHistoricBaselineIterator getPrevious(int max, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getPrevious(max, null, monitor);
    }

    public IHistoricBaselineIterator getPrevious(int max, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        if (max < 1) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        IScmService service = this.workspaceManager.getServerConfigurationService();
        monitor.worked(5);
        SCMClientUtil.checkMonitor(monitor);
        MergedBaselineResult r = service.getMergedBaselineHistory(this.workspace, this.component, this.result.getNextPosition(), max, MergedBaselineHistoryIterator.getSyncTimes(syncInfo), MergedBaselineHistoryIterator.monitorFor(monitor));
        monitor.worked(90);
        SCMClientUtil.checkMonitor(monitor);
        monitor.done();
        return new MergedBaselineHistoryIterator(this.workspace, this.component, r, this.workspaceManager);
    }

    @Override
    public boolean hasPrevious() {
        return !this.result.getNextPosition().isFinishedHistory() || this.result.getNextPosition().getIndex() != -1L;
    }

    private static ISynchronizationTimes[] getSyncTimes(ISynchronizationInfo syncInfo) {
        if (syncInfo == null) {
            return null;
        }
        return ((SynchronizationInfo)syncInfo).getSyncTimes();
    }

    private static IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }
}

