/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.process;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class ProcessProxy {
    public abstract IOperationReport advise(AdvisableOperation var1, IProgressMonitor var2) throws TeamRepositoryException;

    public abstract IOperationReport adviseAndExecute(AdvisableOperation var1, IProgressMonitor var2) throws TeamRepositoryException;

    public abstract IProcessArea getProcessArea(IItem var1, IProgressMonitor var2) throws TeamRepositoryException;

    public abstract IDevelopmentLine getDevelopmentLine(ITeamArea var1, IProgressMonitor var2) throws TeamRepositoryException;

    public abstract IContributorHandle getContributor();

    public boolean ignoreProcessCancellationExceptions() {
        return true;
    }

    protected IItemHandle convert(IItem item) {
        if (item instanceof IProcessAreaHandle) {
            return item;
        }
        if (item instanceof IWorkspace) {
            IAuditableHandle owner = ((IWorkspace)item).getOwner();
            if (owner instanceof IProcessAreaHandle) {
                return owner;
            }
            return null;
        }
        if (item instanceof IComponent) {
            IAuditableHandle owner = this.getComponentOwner((IComponentHandle)item);
            if (owner instanceof IProcessAreaHandle) {
                return owner;
            }
            return null;
        }
        return item;
    }

    protected abstract IAuditableHandle getComponentOwner(IComponentHandle var1);
}

