/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal.text;

import com.ibm.team.foundation.common.internal.text.SubstitutionTextReader;
import com.ibm.team.foundation.common.text.HTMLHandler;
import com.ibm.team.foundation.common.text.XMLString;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HTML2TextReader
extends SubstitutionTextReader {
    private static final String EMPTY_STRING = "";
    private static final Map<String, String> fgEntityLookup;
    private static final Set<String> fgTags;
    public static final boolean PRESERVE_WHITE_SPACE;
    private static final Object FOREGROUND;
    private static final Object BACKGROUND;
    private boolean fSkipWhiteSpace = true;
    private boolean fNeverSkipWhiteSpace;
    private int fBold = 0;
    private int fItalic = 0;
    private boolean fInParagraph = false;
    private boolean fIsPreformattedText = false;
    private int fHyperlink = 0;
    private List<Object> fKeyStack = new ArrayList<Object>();
    private List<Object> fValueStack = new ArrayList<Object>();
    private HTMLHandler fHandler;
    private StringBuffer fBuffer;

    static {
        fgTags = new HashSet<String>();
        fgTags.add("b");
        fgTags.add("strong");
        fgTags.add("i");
        fgTags.add("em");
        fgTags.add("br");
        fgTags.add("h5");
        fgTags.add("p");
        fgTags.add("dl");
        fgTags.add("dt");
        fgTags.add("dd");
        fgTags.add("li");
        fgTags.add("ul");
        fgTags.add("pre");
        fgTags.add("a");
        fgTags.add("div");
        fgTags.add("span");
        fgEntityLookup = new HashMap<String, String>(7);
        fgEntityLookup.put("lt", "<");
        fgEntityLookup.put("gt", ">");
        fgEntityLookup.put("nbsp", " ");
        fgEntityLookup.put("amp", "&");
        fgEntityLookup.put("circ", "^");
        fgEntityLookup.put("tilde", "~");
        fgEntityLookup.put("quot", "\"");
        fgEntityLookup.put("apos", "'");
        PRESERVE_WHITE_SPACE = Boolean.toString(true).equals(System.getProperty("com.ibm.team.foundation.common.behavior.preserveWhitespace"));
        FOREGROUND = new Object();
        BACKGROUND = new Object();
    }

    private HTML2TextReader(Reader reader, boolean neverSkipWhiteSpace, HTMLHandler handler) {
        super(new PushbackReader(reader));
        this.fNeverSkipWhiteSpace = neverSkipWhiteSpace;
        this.fHandler = handler;
    }

    private final void setSkipWhitespace(boolean state) {
        this.fSkipWhiteSpace = state;
    }

    private final boolean isSkippingWhitespace() {
        return !this.fNeverSkipWhiteSpace && this.fSkipWhiteSpace;
    }

    protected void startBold() {
        if (this.fBold == 0) {
            this.styleAboutToChange();
        }
        ++this.fBold;
        if (this.fBold == 1) {
            this.styleChanged();
        }
    }

    protected void stopBold() {
        if (this.fBold == 1) {
            this.styleAboutToChange();
        }
        --this.fBold;
        if (this.fBold == 0) {
            this.styleChanged();
        }
    }

    protected void startItalic() {
        if (this.fItalic == 0) {
            this.styleAboutToChange();
        }
        ++this.fItalic;
        if (this.fItalic == 1) {
            this.styleChanged();
        }
    }

    protected void stopItalic() {
        if (this.fItalic == 1) {
            this.styleAboutToChange();
        }
        --this.fItalic;
        if (this.fItalic == 0) {
            this.styleChanged();
        }
    }

    protected void startSpan(Object key, Object value) {
        this.styleAboutToChange();
        this.fKeyStack.add(key);
        this.fValueStack.add(value);
        this.styleChanged();
    }

    protected void stopSpan() {
        this.styleAboutToChange();
        int i = this.fKeyStack.size() - 1;
        if (i >= 0) {
            this.fKeyStack.remove(i);
            this.fValueStack.remove(i);
        }
        this.styleChanged();
    }

    protected void startPreformattedText() {
        this.fIsPreformattedText = true;
        this.setSkipWhitespace(false);
    }

    protected void stopPreformattedText() {
        this.fIsPreformattedText = false;
        this.setSkipWhitespace(true);
    }

    private void styleAboutToChange() {
        this.styleChange(true);
    }

    private void styleChanged() {
        this.styleChange(false);
    }

    private void styleChange(boolean aboutToChange) {
        int[] foreground = null;
        int[] background = null;
        int fontStyle = (this.fBold > 0 ? 1 : 0) | (this.fItalic > 0 ? 2 : 0);
        int i = 0;
        int n = this.fKeyStack.size();
        while (i < n) {
            if (this.fKeyStack.get(i) == FOREGROUND) {
                foreground = (int[])this.fValueStack.get(i);
            } else if (this.fKeyStack.get(i) == BACKGROUND) {
                background = (int[])this.fValueStack.get(i);
            }
            ++i;
        }
        if (foreground != null || background != null || fontStyle != 0) {
            this.flushTextBuffer();
            if (aboutToChange) {
                this.fHandler.endStyle();
            } else {
                this.fHandler.beginStyle(foreground, background, fontStyle);
            }
        }
    }

    protected void startHyperlink(String reference) {
        if (this.fHyperlink == 0) {
            this.flushTextBuffer();
            this.fHandler.beginReference(reference);
        }
        ++this.fHyperlink;
    }

    protected void stopHyperlink() {
        if (this.fHyperlink == 1) {
            this.flushTextBuffer();
            this.fHandler.endReference();
        }
        --this.fHyperlink;
    }

    protected String computeSubstitution(int c) throws IOException {
        if (c == 60) {
            return this.processHTMLTag();
        }
        if (c == 38) {
            return this.processEntity();
        }
        if (this.fIsPreformattedText) {
            return null;
        }
        if (this.isSkippingWhitespace() && Character.isWhitespace((char)c)) {
            while (Character.isWhitespace((char)c)) {
                c = this.nextChar();
            }
            if (c != -1) {
                this.unread(c);
            }
            return " ";
        }
        return null;
    }

    private String html2Text(String html) {
        String orig = html;
        if ((html = orig.toLowerCase()) == null || html.length() == 0) {
            return EMPTY_STRING;
        }
        String tag = this.tagName(html);
        if (!fgTags.contains(tag)) {
            return EMPTY_STRING;
        }
        if ("pre".equals(html)) {
            this.startPreformattedText();
            return EMPTY_STRING;
        }
        if ("/pre".equals(html)) {
            this.stopPreformattedText();
            return EMPTY_STRING;
        }
        if (this.fIsPreformattedText) {
            return EMPTY_STRING;
        }
        if ("a".equals(tag) && html.charAt(0) != '/' && html.charAt(html.length() - 1) != '/') {
            String reference = this.getAttribute(orig, "href");
            this.startHyperlink(reference != null ? reference : EMPTY_STRING);
            return EMPTY_STRING;
        }
        if ("span".equals(tag) && html.charAt(0) != '/' && html.charAt(html.length() - 1) != '/') {
            String style = this.getAttribute(orig, "style");
            String color_prefix = "color: #";
            String background_prefix = "background: #";
            if (style != null && style.startsWith(color_prefix)) {
                this.startSpan(FOREGROUND, this.parseRGB(style.substring(color_prefix.length(), style.length())));
            } else if (style != null && style.startsWith(background_prefix)) {
                this.startSpan(BACKGROUND, this.parseRGB(style.substring(background_prefix.length(), style.length())));
            }
            return EMPTY_STRING;
        }
        if ("b".equals(html) || "strong".equals(html)) {
            this.startBold();
            return EMPTY_STRING;
        }
        if ("i".equals(html) || "em".equals(html)) {
            this.startItalic();
            return EMPTY_STRING;
        }
        if ("h5".equals(html) || "dt".equals(html)) {
            this.startBold();
            return EMPTY_STRING;
        }
        if ("dl".equals(html)) {
            return LINE_DELIM;
        }
        if ("dd".equals(html)) {
            return "\t";
        }
        if ("li".equals(html)) {
            return String.valueOf(LINE_DELIM) + "\t-";
        }
        if ("/a".equals(html)) {
            this.stopHyperlink();
            return EMPTY_STRING;
        }
        if ("/span".equals(html)) {
            this.stopSpan();
            return EMPTY_STRING;
        }
        if ("/b".equals(html) || "/strong".equals(html)) {
            this.stopBold();
            return EMPTY_STRING;
        }
        if ("/i".equals(html) || "/em".equals(html)) {
            this.stopItalic();
            return EMPTY_STRING;
        }
        if ("p".equals(html) || "div".equals(html)) {
            this.fInParagraph = true;
            return LINE_DELIM;
        }
        if ("br".equals(tag)) {
            return LINE_DELIM;
        }
        if ("/p".equals(html) || "/div".equals(html)) {
            boolean inParagraph = this.fInParagraph;
            this.fInParagraph = false;
            return inParagraph ? EMPTY_STRING : LINE_DELIM;
        }
        if ("/h5".equals(html) || "/dt".equals(html)) {
            this.stopBold();
            return LINE_DELIM;
        }
        if ("/dd".equals(html)) {
            return LINE_DELIM;
        }
        return EMPTY_STRING;
    }

    private int[] parseRGB(String s) {
        if (s.length() < 6) {
            return null;
        }
        int[] rgb = new int[3];
        try {
            rgb[0] = Integer.parseInt(s.substring(0, 2), 16);
            rgb[1] = Integer.parseInt(s.substring(2, 4), 16);
            rgb[2] = Integer.parseInt(s.substring(4, 6), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return rgb;
    }

    private String getAttribute(String html, String attribute) {
        int end;
        String value = null;
        String orig = html;
        int start = (html = orig.toLowerCase()).indexOf(attribute);
        if (start != -1 && (start = html.indexOf(34, start + 1)) != -1 && (end = html.indexOf(34, ++start)) != -1) {
            value = orig.substring(start, end);
        }
        return value != null ? XMLString.createFromXMLText(value).getPlainText() : null;
    }

    private String tagName(String html) {
        String tag = html;
        if ('/' == tag.charAt(0)) {
            tag = tag.substring(1);
        } else if ('/' == tag.charAt(tag.length() - 1)) {
            tag = tag.substring(0, tag.length() - 1);
        }
        int index = tag.indexOf(32);
        if (index != -1) {
            tag = tag.substring(0, index);
        }
        return tag;
    }

    private String processHTMLTag() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextChar();
        while (ch != -1 && ch != 62) {
            buf.append((char)ch);
            ch = this.nextChar();
            if (ch == 34) {
                buf.append((char)ch);
                ch = this.nextChar();
                while (ch != -1 && ch != 34) {
                    buf.append((char)ch);
                    ch = this.nextChar();
                }
            }
            if (ch != 60) continue;
            this.unread(ch);
            return String.valueOf('<') + buf.toString();
        }
        if (ch == -1) {
            return EMPTY_STRING;
        }
        return this.html2Text(buf.toString());
    }

    private void unread(int ch) throws IOException {
        ((PushbackReader)this.getReader()).unread(ch);
    }

    protected String entity2Text(String symbol) {
        if (symbol.length() > 1 && symbol.charAt(0) == '#') {
            try {
                int ch = symbol.charAt(1) == 'x' ? Integer.parseInt(symbol.substring(2), 16) : Integer.parseInt(symbol.substring(1), 10);
                return EMPTY_STRING + (char)ch;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String str = fgEntityLookup.get(symbol);
            if (str != null) {
                return str;
            }
        }
        return "&" + symbol;
    }

    private String processEntity() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextChar();
        while (Character.isLetterOrDigit((char)ch) || ch == 35) {
            buf.append((char)ch);
            ch = this.nextChar();
        }
        if (ch == 59) {
            return this.entity2Text(buf.toString());
        }
        buf.insert(0, '&');
        if (ch != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }

    private void parse() {
        try {
            this.fHandler.beginDocument();
            this.fBuffer = new StringBuffer();
            int read = this.read();
            while (read > -1) {
                this.fBuffer.append((char)read);
                read = this.read();
            }
            this.flushTextBuffer();
            this.fHandler.endDocument();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void flushTextBuffer() {
        if (this.fBuffer != null && this.fBuffer.length() > 0) {
            this.fHandler.text(this.fBuffer);
            this.fBuffer.setLength(0);
        }
    }

    public static void parse(XMLString content, HTMLHandler handler) {
        new HTML2TextReader(new StringReader(content.getXMLText()), PRESERVE_WHITE_SPACE, handler).parse();
    }

    public static Reader getHTML2TextReader(Reader reader, HTMLHandler handler) {
        return new HTML2TextReader(reader, PRESERVE_WHITE_SPACE, handler);
    }
}

