/*
 * Decompiled with CFR 0.152.
 */
package org.xmlsoap.schemas.soap.envelope.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Detail;
import org.xmlsoap.schemas.soap.envelope.DocumentRoot;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.EnvelopePackage;
import org.xmlsoap.schemas.soap.envelope.Fault;
import org.xmlsoap.schemas.soap.envelope.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvelopeValidator
extends EObjectValidator {
    public static final EnvelopeValidator INSTANCE = new EnvelopeValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.xmlsoap.schemas.soap.envelope";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final EValidator.PatternMatcher[][] MUST_UNDERSTAND_TYPE__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"0|1")}};

    protected EPackage getEPackage() {
        return EnvelopePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateBody((Body)value, diagnostics, context);
            }
            case 1: {
                return this.validateDetail((Detail)value, diagnostics, context);
            }
            case 2: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 3: {
                return this.validateEnvelope((Envelope)value, diagnostics, context);
            }
            case 4: {
                return this.validateFault((Fault)value, diagnostics, context);
            }
            case 5: {
                return this.validateHeader((Header)value, diagnostics, context);
            }
            case 6: {
                return this.validateEncodingStyle((List)value, diagnostics, context);
            }
            case 7: {
                return this.validateMustUnderstandType((Boolean)value, diagnostics, context);
            }
            case 8: {
                return this.validateMustUnderstandTypeObject((Boolean)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateBody(Body body, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(body, diagnostics, context);
    }

    public boolean validateDetail(Detail detail, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(detail, diagnostics, context);
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateEnvelope(Envelope envelope, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(envelope, diagnostics, context);
    }

    public boolean validateFault(Fault fault, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(fault, diagnostics, context);
    }

    public boolean validateHeader(Header header, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(header, diagnostics, context);
    }

    public boolean validateEncodingStyle(List<?> encodingStyle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateEncodingStyle_ItemType(encodingStyle, diagnostics, context);
        return result;
    }

    public boolean validateEncodingStyle_ItemType(List<?> encodingStyle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = encodingStyle.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.ANY_URI.isInstance(item)) {
                result &= this.xmlTypeValidator.validateAnyURI((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.ANY_URI, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateMustUnderstandType(boolean mustUnderstandType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMustUnderstandType_Pattern(mustUnderstandType, diagnostics, context);
        return result;
    }

    public boolean validateMustUnderstandType_Pattern(boolean mustUnderstandType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(EnvelopePackage.Literals.MUST_UNDERSTAND_TYPE, new Boolean(mustUnderstandType), MUST_UNDERSTAND_TYPE__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateMustUnderstandTypeObject(Boolean mustUnderstandTypeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMustUnderstandType_Pattern(mustUnderstandTypeObject, diagnostics, context);
        return result;
    }
}

