/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.client.internal.util;

import com.ibm.team.foundation.client.internal.util.Messages;
import com.ibm.team.foundation.client.util.FoundationJobContext;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class FoundationJobUtil {
    public static final FoundationJobContext SYSTEM_INITIATED_JOB = new FoundationJobContext(){

        public void configureJob(Job job) {
            job.setSystem(true);
        }
    };
    private static FoundationJobContext fgCompatibilityContext = new FoundationJobContext();
    private static PackageAdmin fgPackageAdmin = null;

    public static FoundationJobContext getCompatibilityContext() {
        return fgCompatibilityContext;
    }

    public static void setCompatibilityContext(FoundationJobContext compatibilityContext) {
        fgCompatibilityContext = compatibilityContext;
    }

    public static void setPackageAdmin(PackageAdmin packageAdmin) {
        fgPackageAdmin = packageAdmin;
    }

    public static IStatus createStatus(Job job, Exception x) {
        if (x instanceof OperationCanceledException) {
            return new Status(8, FoundationJobUtil.getPluginId(job), NLS.bind((String)Messages.FoundationJobUtil_OPERATION_CANCELED, (Object)job.getName(), (Object[])new Object[0]), (Throwable)x);
        }
        return new Status(4, FoundationJobUtil.getPluginId(job), NLS.bind((String)Messages.FoundationJobUtil_EXCEPTION_RUNNING, (Object)job.getName(), (Object[])new Object[0]), (Throwable)x);
    }

    private static String getPluginId(Job job) {
        Bundle bundle;
        PackageAdmin packageAdmin = fgPackageAdmin;
        if (packageAdmin != null && (bundle = packageAdmin.getBundle(job.getClass())) != null && bundle.getSymbolicName() != null) {
            return bundle.getSymbolicName();
        }
        return "com.ibm.team.foundation.client";
    }

    public static IStatus handleStatus(Job job, FoundationJobContext context, IStatus status) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (!context.isExpectedStatus(job, status)) {
            FoundationLog.logUnexpected((IStatus)status);
        }
        context.handleStatus(job, status);
        return Status.OK_STATUS;
    }
}

