/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.decoder.Base64InputStream;
import org.apache.james.mime4j.decoder.QuotedPrintableInputStream;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.util.MimeUtil;

public abstract class SimpleContentHandler
extends AbstractContentHandler {
    private Header currHeader;

    public abstract void headers(Header var1);

    public abstract void bodyDecoded(BodyDescriptor var1, InputStream var2) throws IOException;

    public final void startHeader() {
        this.currHeader = new Header();
    }

    public final void field(String fieldData) {
        this.currHeader.addField(Field.parse(fieldData));
    }

    public final void endHeader() {
        Header tmp = this.currHeader;
        this.currHeader = null;
        this.headers(tmp);
    }

    public final void body(BodyDescriptor bd, InputStream is) throws IOException {
        if (MimeUtil.isBase64Encoding(bd.getTransferEncoding())) {
            this.bodyDecoded(bd, new Base64InputStream(is));
        } else if (MimeUtil.isQuotedPrintableEncoded(bd.getTransferEncoding())) {
            this.bodyDecoded(bd, new QuotedPrintableInputStream(is));
        } else {
            this.bodyDecoded(bd, is);
        }
    }
}

