/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.decoder.Base64InputStream;
import org.apache.james.mime4j.decoder.QuotedPrintableInputStream;
import org.apache.james.mime4j.descriptor.BodyDescriptor;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.field.UnstructuredField;
import org.apache.james.mime4j.message.AbstractBody;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.message.Multipart;
import org.apache.james.mime4j.message.TempFileBinaryBody;
import org.apache.james.mime4j.message.TempFileTextBody;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.util.CharArrayBuffer;

public class Message
extends Entity
implements Body {
    static /* synthetic */ Class class$org$apache$james$mime4j$message$Entity;
    static /* synthetic */ Class class$org$apache$james$mime4j$message$Message;
    static /* synthetic */ Class class$org$apache$james$mime4j$message$Header;
    static /* synthetic */ Class class$org$apache$james$mime4j$message$Multipart;
    static /* synthetic */ Class class$org$apache$james$mime4j$message$BodyPart;

    public Message() {
    }

    public Message(InputStream is) throws IOException {
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler(new MessageBuilder());
        try {
            parser.parse(is);
        }
        catch (MimeException e) {
            IllegalStateException ise = new IllegalStateException("Unexpected message processing error");
            ise.initCause(e);
            throw ise;
        }
    }

    public UnstructuredField getSubject() {
        return (UnstructuredField)this.getHeader().getField("Subject");
    }

    private class MessageBuilder
    implements ContentHandler {
        private Stack stack = new Stack();

        private void expect(Class c) {
            if (!c.isInstance(this.stack.peek())) {
                throw new IllegalStateException("Internal stack error: Expected '" + c.getName() + "' found '" + this.stack.peek().getClass().getName() + "'");
            }
        }

        public void startMessage() {
            if (this.stack.isEmpty()) {
                this.stack.push(Message.this);
            } else {
                this.expect(class$org$apache$james$mime4j$message$Entity == null ? (class$org$apache$james$mime4j$message$Entity = Message.class$("org.apache.james.mime4j.message.Entity")) : class$org$apache$james$mime4j$message$Entity);
                Message m = new Message();
                ((Entity)this.stack.peek()).setBody(m);
                this.stack.push(m);
            }
        }

        public void endMessage() {
            this.expect(class$org$apache$james$mime4j$message$Message == null ? (class$org$apache$james$mime4j$message$Message = Message.class$("org.apache.james.mime4j.message.Message")) : class$org$apache$james$mime4j$message$Message);
            this.stack.pop();
        }

        public void startHeader() {
            this.stack.push(new Header());
        }

        public void field(String fieldData) {
            this.expect(class$org$apache$james$mime4j$message$Header == null ? (class$org$apache$james$mime4j$message$Header = Message.class$("org.apache.james.mime4j.message.Header")) : class$org$apache$james$mime4j$message$Header);
            ((Header)this.stack.peek()).addField(Field.parse(fieldData));
        }

        public void endHeader() {
            this.expect(class$org$apache$james$mime4j$message$Header == null ? (class$org$apache$james$mime4j$message$Header = Message.class$("org.apache.james.mime4j.message.Header")) : class$org$apache$james$mime4j$message$Header);
            Header h = (Header)this.stack.pop();
            this.expect(class$org$apache$james$mime4j$message$Entity == null ? (class$org$apache$james$mime4j$message$Entity = Message.class$("org.apache.james.mime4j.message.Entity")) : class$org$apache$james$mime4j$message$Entity);
            ((Entity)this.stack.peek()).setHeader(h);
        }

        public void startMultipart(BodyDescriptor bd) {
            this.expect(class$org$apache$james$mime4j$message$Entity == null ? (class$org$apache$james$mime4j$message$Entity = Message.class$("org.apache.james.mime4j.message.Entity")) : class$org$apache$james$mime4j$message$Entity);
            Entity e = (Entity)this.stack.peek();
            String subType = bd.getSubType();
            Multipart multiPart = new Multipart(subType);
            e.setBody(multiPart);
            this.stack.push(multiPart);
        }

        public void body(BodyDescriptor bd, InputStream is) throws IOException {
            this.expect(class$org$apache$james$mime4j$message$Entity == null ? (class$org$apache$james$mime4j$message$Entity = Message.class$("org.apache.james.mime4j.message.Entity")) : class$org$apache$james$mime4j$message$Entity);
            String enc = bd.getTransferEncoding();
            InputStream decodedStream = "base64".equals(enc) ? new Base64InputStream(is) : ("quoted-printable".equals(enc) ? new QuotedPrintableInputStream(is) : is);
            AbstractBody body = bd.getMimeType().startsWith("text/") ? new TempFileTextBody(decodedStream, bd.getCharset()) : new TempFileBinaryBody(decodedStream);
            Entity entity = (Entity)this.stack.peek();
            entity.setBody(body);
        }

        public void endMultipart() {
            this.stack.pop();
        }

        public void startBodyPart() {
            this.expect(class$org$apache$james$mime4j$message$Multipart == null ? (class$org$apache$james$mime4j$message$Multipart = Message.class$("org.apache.james.mime4j.message.Multipart")) : class$org$apache$james$mime4j$message$Multipart);
            BodyPart bodyPart = new BodyPart();
            ((Multipart)this.stack.peek()).addBodyPart(bodyPart);
            this.stack.push(bodyPart);
        }

        public void endBodyPart() {
            this.expect(class$org$apache$james$mime4j$message$BodyPart == null ? (class$org$apache$james$mime4j$message$BodyPart = Message.class$("org.apache.james.mime4j.message.BodyPart")) : class$org$apache$james$mime4j$message$BodyPart);
            this.stack.pop();
        }

        public void epilogue(InputStream is) throws IOException {
            int b;
            this.expect(class$org$apache$james$mime4j$message$Multipart == null ? (class$org$apache$james$mime4j$message$Multipart = Message.class$("org.apache.james.mime4j.message.Multipart")) : class$org$apache$james$mime4j$message$Multipart);
            CharArrayBuffer sb = new CharArrayBuffer(128);
            while ((b = is.read()) != -1) {
                sb.append((char)b);
            }
            ((Multipart)this.stack.peek()).setEpilogue(sb.toString());
        }

        public void preamble(InputStream is) throws IOException {
            int b;
            this.expect(class$org$apache$james$mime4j$message$Multipart == null ? (class$org$apache$james$mime4j$message$Multipart = Message.class$("org.apache.james.mime4j.message.Multipart")) : class$org$apache$james$mime4j$message$Multipart);
            CharArrayBuffer sb = new CharArrayBuffer(128);
            while ((b = is.read()) != -1) {
                sb.append((char)b);
            }
            ((Multipart)this.stack.peek()).setPreamble(sb.toString());
        }

        public void raw(InputStream is) throws IOException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

