/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.io.LineReaderInputStream;
import org.apache.james.mime4j.util.ByteArrayBuffer;

public class LineReaderInputStreamAdaptor
extends LineReaderInputStream {
    private final LineReaderInputStream bis;
    private boolean used = false;
    private boolean eof = false;

    public LineReaderInputStreamAdaptor(InputStream is) {
        super(is);
        this.bis = is instanceof LineReaderInputStream ? (LineReaderInputStream)is : null;
    }

    public int read() throws IOException {
        int i = this.in.read();
        this.eof = i == -1;
        this.used = true;
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = this.in.read(b, off, len);
        this.eof = i == -1;
        this.used = true;
        return i;
    }

    public int readLine(ByteArrayBuffer dst) throws IOException {
        int i = this.bis != null ? this.bis.readLine(dst) : this.doReadLine(dst);
        this.eof = i == -1;
        this.used = true;
        return i;
    }

    private int doReadLine(ByteArrayBuffer dst) throws IOException {
        int ch;
        int total = 0;
        while ((ch = this.in.read()) != -1) {
            dst.append(ch);
            ++total;
            if (ch != 10) continue;
        }
        if (total == 0 && ch == -1) {
            return -1;
        }
        return total;
    }

    public boolean eof() {
        return this.eof;
    }

    public boolean isUsed() {
        return this.used;
    }

    public String toString() {
        return "[LineReaderInputStreamAdaptor: " + this.bis + "]";
    }
}

