/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.common.query.BaseProcessAttachmentQueryModel;
import com.ibm.team.process.internal.common.query.BaseProjectAreaQueryModel;
import com.ibm.team.process.internal.common.query.BaseTeamAreaQueryModel;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IChangeEventHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseChangeEventQueryModel;
import com.ibm.team.repository.common.model.query.BaseContributorQueryModel;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IDynamicItemQueryModel;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IItemQueryModel;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.query.ast.IUUIDField;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.query.BaseAttributeQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseCategoryQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseDeliverableQueryModel;
import com.ibm.team.workitem.common.internal.model.query.BaseWorkItemQueryModel;
import com.ibm.team.workitem.common.internal.query.query.BaseQueryDescriptorQueryModel;
import com.ibm.team.workitem.common.internal.query.util.QueryUtils;
import com.ibm.team.workitem.common.internal.util.DataQueryIterator;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemQueries {
    private static final char ESCAPE_CHARACTER = '\\';
    private static IItemQuery fgWorkItemByIdRange;
    private static IItemQuery fgAttributeByIdentifier;
    private static IItemQuery fgAttributesByProjectArea;
    private static IItemQuery fgBuiltInAttributes;
    private static IItemQuery fgCategoryByProjectArea;
    private static IItemQuery fgCategoryByIdentifier;
    private static IItemQuery fgCategoryByName;
    private static IItemQuery fgCategoriesByContributor;
    private static IItemQuery fgCategoriesByTeamArea;
    private static IItemQuery fgCategoriesByProjectArea;
    private static IItemQuery fgRootCategory;
    private static IItemQuery fgContributorByName;
    private static IItemQuery fgContributorByEmail;
    private static IItemQuery fgContributorByUserId;
    private static IItemQuery fgProjectAreaByName;
    private static IItemQuery fgTeamsByContributorAndProjectArea;
    private static IItemQuery fgChangeEventsByCategoryName;
    private static IItemQuery fgAllChangeEventsByTimeRangeAndType;
    private static IItemQuery fgTeamAreasByContributor;
    private static IItemQuery fgQueryDescriptorByName;
    private static IItemQuery fgQueryDescriptorById;
    private static IItemQuery fgProcessAttachmentByPath;
    private static IItemQuery fgDeliverableByProjectArea;
    private static IItemQuery fgActiveDeliverableByProjectArea;
    private static IItemQuery fgDeliverableByName;
    private static IItemQuery fgDeliverableByArtifact;
    private static Map<IItemType, IItemQuery> fgAll;
    private static Map<IItemType, IItemQuery> fgExists;
    private static Map<IItemType, IItemQuery> fgNewer;
    private static IDataQuery fgDistinctWorkItemTagsByProjectArea;
    private static IDataQuery fgWorkItemMediumStringCustomAttributeValues;
    private static IDataQuery fgApprovalDescriptorNames;
    private static IDataQuery fgTeamAreaMemberCount;
    private static IItemQuery fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan;
    private static IItemQuery fgProcessAttachmentsByPathPrefix;

    static {
        fgAll = new HashMap<IItemType, IItemQuery>();
        fgExists = new HashMap<IItemType, IItemQuery>();
        fgNewer = new HashMap<IItemType, IItemQuery>();
    }

    public static ItemQueryIterator<IWorkItemHandle> workItemsById(IAuditableCommon auditableCommon, List<Integer> ids) {
        BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        ArrayList<INumericInputArg> args = new ArrayList<INumericInputArg>();
        int i = 0;
        while (i < ids.size()) {
            args.add(query.newIntegerArg());
            ++i;
        }
        query.filter(model.id()._in(args.toArray(new INumeric[args.size()])));
        return new ItemQueryIterator<IWorkItemHandle>(auditableCommon, query, ids.toArray());
    }

    public static ItemQueryIterator<IWorkItemHandle> workItemByIdRange(IAuditableCommon auditableCommon, int from, int to) {
        if (fgWorkItemByIdRange == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IPredicate predicate = model.id()._gtOrEq((INumeric)query.newIntegerArg());
            predicate = predicate._and(model.id()._lt((INumeric)query.newIntegerArg()));
            query.filter(predicate);
            fgWorkItemByIdRange = query;
        }
        return new ItemQueryIterator<IWorkItemHandle>(auditableCommon, fgWorkItemByIdRange, new Object[]{from, to});
    }

    public static ItemQueryIterator<IAttributeHandle> attributeByIdentifier(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String identifier) {
        if (fgAttributeByIdentifier == null) {
            BaseAttributeQueryModel.AttributeQueryModel model = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.identifier()._eq((IString)query.newStringArg())));
            fgAttributeByIdentifier = query;
        }
        return new ItemQueryIterator<IAttributeHandle>(auditableCommon, fgAttributeByIdentifier, new Object[]{projectArea, identifier}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<IAttributeHandle> attributesByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgAttributesByProjectArea == null) {
            BaseAttributeQueryModel.AttributeQueryModel model = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            fgAttributesByProjectArea = query;
        }
        return new ItemQueryIterator<IAttributeHandle>(auditableCommon, fgAttributesByProjectArea, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<IAttributeHandle> builtInAttributes(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgBuiltInAttributes == null) {
            BaseAttributeQueryModel.AttributeQueryModel model = BaseAttributeQueryModel.AttributeQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.builtIn()._isTrue()));
            fgBuiltInAttributes = query;
        }
        return new ItemQueryIterator<IAttributeHandle>(auditableCommon, fgBuiltInAttributes, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<ICategoryHandle> categoryByIdentifier(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, CategoryId identifier) {
        if (fgCategoryByIdentifier == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.internalCategoryId()._eq((IString)query.newStringArg())));
            fgCategoryByIdentifier = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoryByIdentifier, new Object[]{projectArea, identifier.getInternalRepresentation()}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<ICategoryHandle> categoryByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgCategoryByProjectArea == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            fgCategoryByProjectArea = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoryByProjectArea, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<ICategoryHandle> categoryByName(IAuditableCommon auditableCommon, String name) {
        if (fgCategoryByName == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.name()._eq((IString)query.newStringArg()));
            fgCategoryByName = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoryByName, new Object[]{name});
    }

    public static ItemQueryIterator<ICategoryHandle> categoriesByContributor(IAuditableCommon auditableCommon, IContributorHandle contributor) {
        if (fgCategoriesByContributor == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IItemHandleInputArg contributorArg = query.newItemHandleArg();
            query.filter(model.defaultTeamArea().contributors()._contains(contributorArg)._or(model.teamAreas().contributors()._contains(contributorArg)));
            query.distinct();
            fgCategoriesByContributor = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoriesByContributor, new Object[]{contributor});
    }

    public static ItemQueryIterator<ICategoryHandle> categoriesByProcessArea(IAuditableCommon auditableCommon, IProcessAreaHandle processArea) {
        IItemQuery query;
        BaseCategoryQueryModel.CategoryQueryModel model;
        if (fgCategoriesByTeamArea == null) {
            model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IItemHandleInputArg teamAreaArg = query.newItemHandleArg();
            query.filter(model.defaultTeamArea()._eq(teamAreaArg)._or(model.teamAreas()._contains(teamAreaArg)));
            query.distinct();
            fgCategoriesByTeamArea = query;
        }
        if (fgCategoriesByProjectArea == null) {
            model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IItemHandleInputArg projectAreaArg = query.newItemHandleArg();
            query.filter(model.projectArea()._eq(projectAreaArg)._and(model.defaultTeamArea()._isNull()._and(model.teamAreas()._isEmpty())));
            query.distinct();
            fgCategoriesByProjectArea = query;
        }
        if (processArea instanceof ITeamAreaHandle) {
            return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoriesByTeamArea, new Object[]{processArea});
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgCategoriesByProjectArea, new Object[]{processArea}, QueryUtils.getContextIds((IProjectAreaHandle)processArea));
    }

    public static ItemQueryIterator<ICategoryHandle> rootCategory(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgRootCategory == null) {
            BaseCategoryQueryModel.CategoryQueryModel model = BaseCategoryQueryModel.CategoryQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            query.orderByAsc((IField)model.internalCategoryId());
            fgRootCategory = query;
        }
        return new ItemQueryIterator<ICategoryHandle>(auditableCommon, fgRootCategory, new Object[]{projectArea}, 1, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<IContributorHandle> contributorByName(IAuditableCommon auditableCommon, String name) {
        if (fgContributorByName == null) {
            BaseContributorQueryModel.ContributorQueryModel c = BaseContributorQueryModel.ContributorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)c);
            query.filter(c.name()._eq((IString)query.newStringArg()));
            fgContributorByName = query;
        }
        return new ItemQueryIterator<IContributorHandle>(auditableCommon, fgContributorByName, new Object[]{name}, QueryUtils.getPublicContextIds());
    }

    public static ItemQueryIterator<IContributorHandle> contributorByEmail(IAuditableCommon auditableCommon, String email) {
        if (fgContributorByEmail == null) {
            BaseContributorQueryModel.ContributorQueryModel c = BaseContributorQueryModel.ContributorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)c);
            query.filter(c.emailAddress()._eq((IString)query.newStringArg()));
            fgContributorByEmail = query;
        }
        return new ItemQueryIterator<IContributorHandle>(auditableCommon, fgContributorByEmail, new Object[]{email}, QueryUtils.getPublicContextIds());
    }

    public static ItemQueryIterator<IContributorHandle> contributorByUserId(IAuditableCommon auditableCommon, String userId) {
        if (fgContributorByUserId == null) {
            BaseContributorQueryModel.ContributorQueryModel c = BaseContributorQueryModel.ContributorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)c);
            query.filter(c.userId()._eq((IString)query.newStringArg()));
            fgContributorByUserId = query;
        }
        return new ItemQueryIterator<IContributorHandle>(auditableCommon, fgContributorByUserId, new Object[]{userId}, QueryUtils.getPublicContextIds());
    }

    public static ItemQueryIterator<ITeamAreaHandle> teamAreasByContributorAndProjectArea(IAuditableCommon auditableCommon, IContributorHandle user, IProjectAreaHandle projectArea) {
        if (fgTeamsByContributorAndProjectArea == null) {
            BaseTeamAreaQueryModel.TeamAreaQueryModel teamModel = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
            IItemQuery teamQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)teamModel);
            teamQuery.filter(teamModel.projectArea()._eq(teamQuery.newItemHandleArg())._and(teamModel.contributors()._contains(teamQuery.newItemHandleArg())));
            teamQuery.distinct();
            fgTeamsByContributorAndProjectArea = teamQuery;
        }
        return new ItemQueryIterator<ITeamAreaHandle>(auditableCommon, fgTeamsByContributorAndProjectArea, new Object[]{projectArea, user}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<ITeamAreaHandle> teamAreasByContributor(IAuditableCommon auditableCommon, IContributorHandle user) {
        if (fgTeamAreasByContributor == null) {
            BaseTeamAreaQueryModel.TeamAreaQueryModel teamModel = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
            IItemQuery teamQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)teamModel);
            teamQuery.filter(teamModel.contributors()._contains(teamQuery.newItemHandleArg()));
            teamQuery.distinct();
            fgTeamAreasByContributor = teamQuery;
        }
        return new ItemQueryIterator<ITeamAreaHandle>(auditableCommon, fgTeamAreasByContributor, new Object[]{user});
    }

    public static ItemQueryIterator<IQueryDescriptorHandle> queryDescriptorByName(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String name) {
        if (fgQueryDescriptorByName == null) {
            BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel queryModel = BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
            query.filter(queryModel.projectArea()._eq(query.newItemHandleArg())._and(queryModel.name()._eq((IString)query.newStringArg())));
            fgQueryDescriptorByName = query;
        }
        return new ItemQueryIterator<IQueryDescriptorHandle>(auditableCommon, fgQueryDescriptorByName, new Object[]{projectArea, name}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<IQueryDescriptorHandle> queryDescriptorById(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String identifier) {
        if (fgQueryDescriptorById == null) {
            BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel queryModel = BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
            query.filter(queryModel.projectArea()._eq(query.newItemHandleArg())._and(queryModel.id()._eq((IString)query.newStringArg())));
            fgQueryDescriptorById = query;
        }
        return new ItemQueryIterator<IQueryDescriptorHandle>(auditableCommon, fgQueryDescriptorById, new Object[]{projectArea, identifier}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<IQueryDescriptorHandle> queryDescriptorsById(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String[] ids) {
        BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel queryModel = BaseQueryDescriptorQueryModel.QueryDescriptorQueryModel.ROOT;
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)queryModel);
        ArrayList<String> parameters = new ArrayList<String>(ids.length);
        IString[] args = new IString[ids.length];
        int i = 0;
        while (i < ids.length) {
            args[i] = query.newStringArg();
            parameters.add(ids[i]);
            ++i;
        }
        parameters.add((String)projectArea);
        query.filter(queryModel.projectArea()._eq(query.newItemHandleArg())._and(queryModel.id()._in(args)));
        return new ItemQueryIterator<IQueryDescriptorHandle>(auditableCommon, query, parameters.toArray(), QueryUtils.getContextIds(projectArea));
    }

    public static <T extends IAuditableHandle> ItemQueryIterator<T> all(IAuditableCommon auditableCommon, IItemType itemType) {
        IItemQuery query = fgAll.get(itemType);
        if (query == null) {
            IDynamicItemQueryModel model = itemType.getQueryModel();
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)model));
            fgAll.put(itemType, query);
        }
        return new ItemQueryIterator(auditableCommon, query);
    }

    public static ItemQueryIterator<IAuditableHandle> exists(IAuditableCommon auditableCommon, IAuditableHandle handle) {
        IItemQuery query = fgExists.get(handle.getItemType());
        if (query == null) {
            IDynamicItemQueryModel model = handle.getItemType().getQueryModel();
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)model));
            IUUIDField itemId = (IUUIDField)model.getField(IItem.ITEM_ID_PROPERTY);
            query.filter(itemId._eq((IUUID)query.newUUIDArg()));
            fgExists.put(handle.getItemType(), query);
        }
        return new ItemQueryIterator<IAuditableHandle>(auditableCommon, query, new Object[]{handle.getItemId()});
    }

    public static ItemQueryIterator<IAuditableHandle> newer(IAuditableCommon auditableCommon, IAuditableHandle stateHandle) {
        Assert.isTrue((boolean)stateHandle.hasStateId());
        IItemQuery query = fgNewer.get(stateHandle.getItemType());
        if (query == null) {
            IDynamicItemQueryModel model = stateHandle.getItemType().getQueryModel();
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)((IItemQueryModel)model));
            IUUIDField itemId = (IUUIDField)model.getField(IItem.ITEM_ID_PROPERTY);
            IUUIDField stateId = (IUUIDField)model.getField(IItem.STATE_ID_PROPERTY);
            query.filter(itemId._eq((IUUID)query.newUUIDArg())._and(query.not(stateId._eq((IUUID)query.newUUIDArg()))));
            fgNewer.put(stateHandle.getItemType(), query);
        }
        return new ItemQueryIterator<IAuditableHandle>(auditableCommon, query, new Object[]{stateHandle.getItemId(), stateHandle.getStateId()});
    }

    public static ItemQueryIterator<IProjectAreaHandle> projectAreaByName(IAuditableCommon auditableCommon, String projectAreaName) {
        if (fgProjectAreaByName == null) {
            BaseProjectAreaQueryModel.ProjectAreaQueryModel model = BaseProjectAreaQueryModel.ProjectAreaQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.name()._like((IString)query.newStringArg()));
            fgProjectAreaByName = query;
        }
        return new ItemQueryIterator<IProjectAreaHandle>(auditableCommon, fgProjectAreaByName, new Object[]{projectAreaName});
    }

    public static ItemQueryIterator<IChangeEventHandle> changeEventsByTeamArea(IAuditableCommon auditableCommon, ITeamArea teamArea, Timestamp since, List<String> categoryFilter, int maxResults) {
        int i;
        IPredicate predicate;
        Assert.isTrue((categoryFilter.size() == 2 ? 1 : 0) != 0);
        BaseChangeEventQueryModel.ChangeEventQueryModel changeModel = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
        IItemQuery changeQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)changeModel);
        changeQuery.setResultLimit(maxResults);
        if (since != null) {
            predicate = changeModel.modified()._gtOrEq((IDateTime)changeQuery.newDateTimeArg());
            predicate = predicate._and(changeModel.eventProcessArea()._eq(changeQuery.newItemHandleArg()));
            i = 0;
            while (i < categoryFilter.size()) {
                predicate = predicate._and(changeModel.eventCategory()._notEq((IString)changeQuery.newStringArg()));
                ++i;
            }
            changeQuery.filter(predicate);
            changeQuery.orderByDsc((IField)changeModel.eventTime());
        } else {
            predicate = changeModel.eventProcessArea()._eq(changeQuery.newItemHandleArg());
            i = 0;
            while (i < categoryFilter.size()) {
                predicate = predicate._and(changeModel.eventCategory()._notEq((IString)changeQuery.newStringArg()));
                ++i;
            }
            changeQuery.filter(predicate);
            changeQuery.orderByDsc((IField)changeModel.eventTime());
        }
        ArrayList<Object> params = new ArrayList<Object>(5);
        ItemQueryIterator<Object> query = null;
        if (since != null) {
            params.add(since);
            params.add(teamArea);
            for (String category : categoryFilter) {
                params.add(category);
            }
            query = new ItemQueryIterator(auditableCommon, changeQuery, params.toArray(), maxResults, QueryUtils.getContextIds(teamArea.getProjectArea()));
        } else {
            params.add(teamArea);
            for (String category : categoryFilter) {
                params.add(category);
            }
            query = new ItemQueryIterator<IChangeEventHandle>(auditableCommon, changeQuery, params.toArray(), maxResults, QueryUtils.getContextIds(teamArea.getProjectArea()));
        }
        return query;
    }

    public static ItemQueryIterator<IChangeEventHandle> allChangeEventsByCategoryName(IAuditableCommon auditableCommon, String categoryName) {
        if (fgChangeEventsByCategoryName == null) {
            BaseChangeEventQueryModel.ChangeEventQueryModel model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.eventCategory()._eq((IString)query.newStringArg()));
            query.orderByDsc((IField)model.modified());
            fgChangeEventsByCategoryName = query;
        }
        return new ItemQueryIterator<IChangeEventHandle>(auditableCommon, fgChangeEventsByCategoryName, new Object[]{categoryName});
    }

    public static ItemQueryIterator<IChangeEventHandle> allChangeEventsModifiedByUser(IAuditableCommon auditableCommon, IContributorHandle user, List<String> categoryFilter, Date since, int maxResults) {
        int i;
        IPredicate predicate;
        IItemQuery query;
        BaseChangeEventQueryModel.ChangeEventQueryModel model;
        Assert.isTrue((categoryFilter.size() == 2 ? 1 : 0) != 0);
        if (since != null) {
            model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.setResultLimit(maxResults);
            predicate = model.modifiedBy()._eq(query.newItemHandleArg());
            predicate._and(model.modified()._gt((IDateTime)query.newDateTimeArg()));
            i = 0;
            while (i < categoryFilter.size()) {
                predicate = predicate._and(model.eventCategory()._notEq((IString)query.newStringArg()));
                ++i;
            }
            query.filter(predicate);
            query.orderByDsc((IField)model.eventTime());
        } else {
            model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            predicate = model.modifiedBy()._eq(query.newItemHandleArg());
            i = 0;
            while (i < categoryFilter.size()) {
                predicate = predicate._and(model.eventCategory()._notEq((IString)query.newStringArg()));
                ++i;
            }
            query.filter(predicate);
            query.orderByDsc((IField)model.eventTime());
        }
        ArrayList<Object> params = new ArrayList<Object>(5);
        params.add(user);
        if (since != null) {
            params.add(since);
        }
        for (String filter : categoryFilter) {
            params.add(filter);
        }
        return new ItemQueryIterator<IChangeEventHandle>(auditableCommon, query, params.toArray());
    }

    public static ItemQueryIterator<IChangeEventHandle> changeEventsByTimeRangeAndType(IAuditableCommon auditableCommon, Date start, Date end, IItemType type) {
        if (fgAllChangeEventsByTimeRangeAndType == null) {
            BaseChangeEventQueryModel.ChangeEventQueryModel model = BaseChangeEventQueryModel.ChangeEventQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.modified()._gtOrEq((IDateTime)query.newDateTimeArg())._and(model.modified()._lt((IDateTime)query.newDateTimeArg()))._and(model.item()._isTypeOf(query.newItemTypeArg())));
            query.orderByAsc((IField)model.eventTime());
            fgAllChangeEventsByTimeRangeAndType = query;
        }
        return new ItemQueryIterator<IChangeEventHandle>(auditableCommon, fgAllChangeEventsByTimeRangeAndType, new Object[]{start, end, type});
    }

    public static ItemQueryIterator<IWorkItemHandle> workitemsContainingOpenApprovalsWithDueDatesEarlierThan(IAuditableCommon auditableCommon, Date maxDueDate) {
        if (fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan == null) {
            BaseWorkItemQueryModel.WorkItemQueryModel model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.internalApprovalDescriptors().cumulativeStateIdentifier()._eq(WorkItemApprovals.PENDING_STATE.getIdentifier())._and(model.internalApprovalDescriptors().dueDate()._lt((IDateTime)query.newDateTimeArg())));
            query.distinct();
            fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan = query;
        }
        return new ItemQueryIterator<IWorkItemHandle>(auditableCommon, fgWorkItemsWithOpenApprovalsWithDueDatesEarlierThan, new Object[]{maxDueDate});
    }

    public static ItemQueryIterator<IProcessAttachmentHandle> processAttachmentByPath(IAuditableCommon auditableCommon, UUID owningItem, String path) {
        if (fgProcessAttachmentByPath == null) {
            BaseProcessAttachmentQueryModel.ProcessAttachmentQueryModel processAttachment = BaseProcessAttachmentQueryModel.ProcessAttachmentQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)processAttachment);
            query.filter(processAttachment.internalOwningItem().itemId()._eq((IUUID)query.newUUIDArg())._and(processAttachment.path()._like((IString)query.newStringArg(), '\\')));
            fgProcessAttachmentByPath = query;
        }
        return new ItemQueryIterator<IProcessAttachmentHandle>(auditableCommon, fgProcessAttachmentByPath, new Object[]{owningItem, WorkItemQueries.escapeLikeParameter(path)});
    }

    public static ItemQueryIterator<IProcessAttachmentHandle> processAttachmentsByPathPrefix(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String path) {
        if (fgProcessAttachmentsByPathPrefix == null) {
            BaseProcessAttachmentQueryModel.ProcessAttachmentQueryModel processAttachment = BaseProcessAttachmentQueryModel.ProcessAttachmentQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)processAttachment);
            query.filter(processAttachment.internalOwningItem()._eq(query.newItemHandleArg())._and(processAttachment.path()._like((IString)query.newStringArg(), '\\')));
            fgProcessAttachmentsByPathPrefix = query;
        }
        return new ItemQueryIterator<IProcessAttachmentHandle>(auditableCommon, fgProcessAttachmentsByPathPrefix, new Object[]{projectArea, String.valueOf(WorkItemQueries.escapeLikeParameter(path)) + "%"});
    }

    public static ItemQueryIterator<IDeliverableHandle> deliverableByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgDeliverableByProjectArea == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            query.orderByAsc((IField)model.creationDate());
            fgDeliverableByProjectArea = query;
        }
        return new ItemQueryIterator<IDeliverableHandle>(auditableCommon, fgDeliverableByProjectArea, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<IDeliverableHandle> activeDeliverableByProjectArea(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea) {
        if (fgActiveDeliverableByProjectArea == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.archived()._isFalse()));
            query.orderByAsc((IField)model.creationDate());
            fgActiveDeliverableByProjectArea = query;
        }
        return new ItemQueryIterator<IDeliverableHandle>(auditableCommon, fgActiveDeliverableByProjectArea, new Object[]{projectArea}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<IDeliverableHandle> deliverableByName(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, String name) {
        if (fgDeliverableByName == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.name()._eq((IString)query.newStringArg())));
            fgDeliverableByName = query;
        }
        return new ItemQueryIterator<IDeliverableHandle>(auditableCommon, fgDeliverableByName, new Object[]{projectArea, name}, QueryUtils.getContextIds(projectArea));
    }

    public static ItemQueryIterator<IDeliverableHandle> deliverableByArtifact(IAuditableCommon auditableCommon, IItemHandle artifact) {
        if (fgDeliverableByArtifact == null) {
            BaseDeliverableQueryModel.DeliverableQueryModel model = BaseDeliverableQueryModel.DeliverableQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.artifact()._eq(query.newItemHandleArg()));
            fgDeliverableByArtifact = query;
        }
        return new ItemQueryIterator<IDeliverableHandle>(auditableCommon, fgDeliverableByArtifact, new Object[]{artifact});
    }

    public static ItemQueryIterator<IItemHandle> handleByUUID(IAuditableCommon auditableCommon, IItemType itemType, UUID uuid) {
        Assert.isNotNull((Object)uuid);
        IDynamicItemQueryModel model = itemType.getQueryModel();
        IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
        IUUIDField itemIdfield = (IUUIDField)model.getField(IItem.ITEM_ID_PROPERTY);
        query.filter(itemIdfield._eq((IUUID)query.newUUIDArg()));
        return new ItemQueryIterator<IItemHandle>(auditableCommon, query, new Object[]{uuid});
    }

    public static DataQueryIterator<String> distinctWorkItemTags(IAuditableCommon auditableCommon, IAttribute attribute) {
        IDataQuery query;
        BaseWorkItemQueryModel.WorkItemQueryModel model;
        if (fgDistinctWorkItemTagsByProjectArea == null) {
            model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg()));
            query.select((ISelectionElement)model.internalTags()).distinct();
            fgDistinctWorkItemTagsByProjectArea = query;
        }
        if (fgWorkItemMediumStringCustomAttributeValues == null) {
            model = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
            query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.mediumStringExtensions().key()._eq((IString)query.newStringArg())));
            query.select((ISelectionElement)model.mediumStringExtensions().value()).distinct();
            fgWorkItemMediumStringCustomAttributeValues = query;
        }
        if (IWorkItem.TAGS_PROPERTY.equals(attribute.getIdentifier())) {
            return new DataQueryIterator<String>(auditableCommon, fgDistinctWorkItemTagsByProjectArea, new Object[]{attribute.getProjectArea()}, QueryUtils.getContextIds(attribute.getProjectArea()));
        }
        Assert.isLegal((!attribute.isBuiltIn() && "tags".equals(attribute.getAttributeType()) ? 1 : 0) != 0);
        return new DataQueryIterator<String>(auditableCommon, fgWorkItemMediumStringCustomAttributeValues, new Object[]{attribute.getProjectArea(), attribute.getIdentifier()}, QueryUtils.getContextIds(attribute.getProjectArea()));
    }

    public static DataQueryIterator<String> approvalDescriptorNames(IAuditableCommon auditableCommon) {
        if (fgApprovalDescriptorNames == null) {
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT);
            query.select((ISelectionElement)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT.internalApprovalDescriptors().name()).distinct().orderByAsc((IField)BaseWorkItemQueryModel.WorkItemQueryModel.ROOT.internalApprovalDescriptors().name());
            fgApprovalDescriptorNames = query;
        }
        return new DataQueryIterator<String>(auditableCommon, fgApprovalDescriptorNames);
    }

    public static DataQueryIterator<Integer> teamAreaMemberCount(IAuditableCommon auditableCommon, IProjectAreaHandle projectArea, IContributorHandle contributor) {
        if (fgTeamAreaMemberCount == null) {
            BaseTeamAreaQueryModel.TeamAreaQueryModel model = BaseTeamAreaQueryModel.TeamAreaQueryModel.ROOT;
            IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
            query.filter(model.projectArea()._eq(query.newItemHandleArg())._and(model.contributors()._contains(query.newItemHandleArg())));
            query.distinct();
            query.select(query.count());
            fgTeamAreaMemberCount = query;
        }
        return new DataQueryIterator<Integer>(auditableCommon, fgTeamAreaMemberCount, new Object[]{projectArea, contributor}, QueryUtils.getContextIds(projectArea));
    }

    public static DataQueryIterator<Timestamp> lastModified(IAuditableCommon auditableCommon, IItemType itemType) {
        IDataQuery query = WorkItemQueries.createLastModifiedQuery(auditableCommon, itemType);
        return new DataQueryIterator<Timestamp>(auditableCommon, query);
    }

    public static IDataQuery createLastModifiedQuery(IAuditableCommon auditableCommon, IItemType itemType) {
        IDynamicItemQueryModel queryModel = itemType.getQueryModel();
        IField modifiedField = queryModel.getField(IItem.MODIFIED_PROPERTY);
        IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)queryModel);
        query.select(query.max(modifiedField));
        return query;
    }

    private static String escapeLikeParameter(String prefix) {
        return prefix.replace("%", "\\%").replace("_", "\\_");
    }
}

