/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.util.Messages;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceValue
implements Comparable<SequenceValue> {
    private static final int BASE = 64;
    private static final String SEQUENCE_VALUE_SEPARATOR = " ";
    private static final String SEQUENCE_VALUE_NEWITEM = null;
    private static final String SEQUENCE_VALUE_INITIAL = "O00000";
    private static final String SEQUENCE_VALUE_ONE = "000001";
    private static final String SEQUENCE_VALUE_ACCEPTED_LEGACY = "000000";
    public static final SequenceValue INITIAL = new SequenceValue("O00000");
    public static final SequenceValue NEW = new SequenceValue(SEQUENCE_VALUE_NEWITEM);
    public static final Factory FACTORY = new Factory();
    private final String fSequenceValue;

    private SequenceValue(CharSequence sequenceValue) {
        this.fSequenceValue = sequenceValue != null ? sequenceValue.toString() : null;
    }

    public boolean isNew() {
        return this.fSequenceValue == SEQUENCE_VALUE_NEWITEM;
    }

    public String serializeSequenceValue(IItemHandle sequenceScope) {
        return this.serializeSequenceValue(sequenceScope.getItemId().getUuidValue());
    }

    public String serializeSequenceValue(String sequenceScope) {
        Assert.isLegal((sequenceScope.indexOf(SEQUENCE_VALUE_SEPARATOR) == -1 ? 1 : 0) != 0);
        return this.isNew() ? null : String.valueOf(sequenceScope) + SEQUENCE_VALUE_SEPARATOR + this.fSequenceValue;
    }

    public String getRawValue() {
        return this.fSequenceValue;
    }

    @Override
    public int compareTo(SequenceValue o) {
        if (this.fSequenceValue == null || o.fSequenceValue == null) {
            return (this.fSequenceValue == null ? 1 : 0) - (o.fSequenceValue == null ? 1 : 0);
        }
        return SequenceValue.compare(this.fSequenceValue, o.fSequenceValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SequenceValue)) {
            return false;
        }
        return this.compareTo((SequenceValue)obj) == 0;
    }

    private static int valueOf(char character) {
        return character - 48;
    }

    private static char toChar(int value) {
        return (char)(48 + value);
    }

    private static int compare(CharSequence left, CharSequence right) {
        int length = Math.min(left.length(), right.length());
        int i = 0;
        while (i < length) {
            int difference = left.charAt(i) - right.charAt(i);
            if (difference != 0) {
                return difference;
            }
            ++i;
        }
        return left.length() - right.length();
    }

    private static CharSequence add(CharSequence left, CharSequence right) {
        boolean overflow = false;
        StringBuilder result = new StringBuilder();
        int i = Math.max(left.length(), right.length()) - 1;
        while (i >= 0) {
            int v1 = left.length() > i ? SequenceValue.valueOf(left.charAt(i)) : 0;
            int v2 = right.length() > i ? SequenceValue.valueOf(right.charAt(i)) : 0;
            int value = v1 + v2 + (overflow ? 1 : 0);
            overflow = value >= 64;
            result.append(SequenceValue.toChar(value - (overflow ? 64 : 0)));
            --i;
        }
        if (overflow) {
            WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("SequenceValue.OVERFLOW"), (Object)left, (Object[])new Object[]{right}), new Exception());
        }
        result.reverse();
        return result;
    }

    private static CharSequence subtract(CharSequence minuend, CharSequence subtrahend) {
        Assert.isLegal((SequenceValue.compare(minuend, subtrahend) >= 0 ? 1 : 0) != 0);
        boolean borrow = false;
        StringBuilder result = new StringBuilder();
        int i = Math.max(minuend.length(), subtrahend.length()) - 1;
        while (i >= 0) {
            int v1 = minuend.length() > i ? SequenceValue.valueOf(minuend.charAt(i)) : 0;
            int v2 = subtrahend.length() > i ? SequenceValue.valueOf(subtrahend.charAt(i)) : 0;
            int value = v1 - v2 - (borrow ? 1 : 0);
            borrow = value < 0;
            result.append(SequenceValue.toChar((borrow ? 64 : 0) + value));
            --i;
        }
        Assert.isTrue((!borrow ? 1 : 0) != 0);
        result.reverse();
        return result;
    }

    private static CharSequence divideBy2(CharSequence dividend) {
        int push = 0;
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < dividend.length()) {
            int value = SequenceValue.valueOf(dividend.charAt(i));
            result.append(SequenceValue.toChar((push << 5) + (value >> 1)));
            push = value & 1;
            ++i;
        }
        if (push > 0) {
            result.append(SequenceValue.toChar(32));
        }
        return result;
    }

    /* synthetic */ SequenceValue(CharSequence charSequence, SequenceValue sequenceValue) {
        this(charSequence);
    }

    public static class Factory {
        public SequenceValue valueOf(String sequenceValue, IItemHandle sequenceScope) {
            return this.valueOf(sequenceValue, sequenceScope.getItemId().getUuidValue());
        }

        public SequenceValue valueOf(String sequenceValue, String sequenceScope) {
            try {
                String[] parts;
                if (sequenceValue != null && sequenceValue.length() > 0 && (parts = sequenceValue.split(SequenceValue.SEQUENCE_VALUE_SEPARATOR)).length == 2 && parts[0].equals(sequenceScope)) {
                    return SequenceValue.SEQUENCE_VALUE_ACCEPTED_LEGACY.equals(parts[1]) ? NEW : new SequenceValue(parts[1], null);
                }
            }
            catch (IllegalArgumentException e) {
                WorkItemCommonPlugin.log(Messages.getString("SequenceValue.ILLEGAL_SEQ_VALUE"), e);
            }
            return NEW;
        }

        public SequenceValue valueOf(Double doubleValue) {
            if (doubleValue == null || doubleValue.isNaN()) {
                return NEW;
            }
            long integerPart = (long)Math.floor(Math.abs(doubleValue));
            StringBuilder positiveValue = new StringBuilder();
            int i = 5;
            while (i >= 0) {
                positiveValue.append(SequenceValue.toChar((int)(integerPart >> i * 6 & 0x3FL)));
                --i;
            }
            double fractionPart = Math.abs(doubleValue) - (double)integerPart;
            while (fractionPart != 0.0) {
                int digitPart = (int)Math.floor(fractionPart *= 64.0);
                positiveValue.append(SequenceValue.toChar(digitPart & 0x3F));
                fractionPart -= (double)digitPart;
            }
            CharSequence converted = Math.signum(doubleValue) >= 0.0 ? SequenceValue.add(SequenceValue.SEQUENCE_VALUE_INITIAL, positiveValue) : SequenceValue.subtract(SequenceValue.SEQUENCE_VALUE_INITIAL, positiveValue);
            return new SequenceValue(converted, null);
        }

        public SequenceValue successor(SequenceValue value) {
            Assert.isTrue((!value.isNew() ? 1 : 0) != 0);
            return new SequenceValue(SequenceValue.add(value.fSequenceValue, SequenceValue.SEQUENCE_VALUE_ONE), null);
        }

        public SequenceValue predecessor(SequenceValue value) {
            Assert.isTrue((!value.isNew() ? 1 : 0) != 0);
            return new SequenceValue(SequenceValue.subtract(value.fSequenceValue, SequenceValue.SEQUENCE_VALUE_ONE), null);
        }

        public SequenceValue between(SequenceValue value1, SequenceValue value2) {
            Assert.isTrue((!value1.isNew() ? 1 : 0) != 0);
            Assert.isTrue((!value2.isNew() ? 1 : 0) != 0);
            Assert.isTrue((!value1.equals(value2) ? 1 : 0) != 0);
            String v1 = value1.fSequenceValue;
            String v2 = value2.fSequenceValue;
            if (SequenceValue.compare(v1, v2) > 0) {
                v1 = value2.fSequenceValue;
                v2 = value1.fSequenceValue;
            }
            return new SequenceValue(SequenceValue.add(v1, SequenceValue.divideBy2(SequenceValue.subtract(v2, v1))), null);
        }
    }
}

