/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.util.QueryIterator;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemQueryIterator<T extends IItemHandle>
extends QueryIterator<T> {
    private int fPageSize;
    private IAuditableCommon fAuditableCommon;
    private IItemQuery fQuery;
    private Object[] fParameters;
    private UUID[] fContextIds;
    private IItemQueryPage fPage;
    private Iterator<T> fIterator;

    public ItemQueryIterator(IAuditableCommon auditableCommon, IItemQuery query) {
        this(auditableCommon, query, IQueryService.EMPTY_PARAMETERS, null);
    }

    public ItemQueryIterator(IAuditableCommon auditableCommon, IItemQuery query, Object[] parameters) {
        this(auditableCommon, query, parameters, null);
    }

    public ItemQueryIterator(IAuditableCommon auditableCommon, IItemQuery query, Object[] parameters, UUID[] contextIds) {
        this(auditableCommon, query, parameters, 512, contextIds);
    }

    public ItemQueryIterator(IAuditableCommon auditableCommon, IItemQuery query, Object[] parameters, int pageSize, UUID[] contextIds) {
        this.fAuditableCommon = auditableCommon;
        this.fQuery = query;
        this.fParameters = parameters;
        this.fPageSize = pageSize;
        this.fContextIds = contextIds;
    }

    @Override
    public boolean hasNext(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fIterator.hasNext();
    }

    @Override
    public T next(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return (T)((IItemHandle)this.fIterator.next());
    }

    public int getResultSize(IProgressMonitor monitor) throws TeamRepositoryException {
        this.update(monitor);
        return this.fPage.getResultSize();
    }

    private void update(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fPage == null) {
            this.fPage = this.fAuditableCommon.queryItemsInContext(this.fQuery, this.fParameters, this.fPageSize, this.fContextIds, monitor);
            this.fIterator = this.fPage.getItemHandles().iterator();
        }
        while (!this.fIterator.hasNext() && this.fPage.hasNext()) {
            this.fPage = (IItemQueryPage)this.fAuditableCommon.fetchPage(this.fPage.getToken(), this.fPage.getNextStartPosition(), this.fPageSize, monitor);
            this.fIterator = this.fPage.getItemHandles().iterator();
        }
    }
}

