/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.workitem.common.internal.model.ModelPackage;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFHelper {
    public static void merge(EObject to, EObject from) {
        EMFHelper.merge(to, from, null);
    }

    public static void merge(EObject to, EObject from, List exclude) {
        Assert.isTrue((to.eClass() == from.eClass() ? 1 : 0) != 0);
        Object features = from.eClass().getEAllStructuralFeatures();
        if (to instanceof WorkItem) {
            features = new ArrayList(features);
            features.remove(ModelPackage.eINSTANCE.getWorkItem_CustomAttributes());
            features.add(0, ModelPackage.eINSTANCE.getWorkItem_CustomAttributes());
            features.remove(ModelPackage.eINSTANCE.getWorkItem_ProjectArea());
            features.add(0, ModelPackage.eINSTANCE.getWorkItem_ProjectArea());
            int approvalsIndex = features.indexOf(ModelPackage.eINSTANCE.getWorkItem_InternalApprovals());
            int descriptorsIndex = features.indexOf(ModelPackage.eINSTANCE.getWorkItem_InternalApprovalDescriptors());
            if (approvalsIndex < descriptorsIndex) {
                features.remove(ModelPackage.eINSTANCE.getWorkItem_InternalApprovalDescriptors());
                features.add(approvalsIndex, ModelPackage.eINSTANCE.getWorkItem_InternalApprovalDescriptors());
            }
        }
        Iterator iter = features.iterator();
        while (iter.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)iter.next();
            if (exclude != null && exclude.contains(feature) || !to.eIsSet(feature) && !from.eIsSet(feature)) continue;
            EMFHelper.merge(feature, to, from);
        }
    }

    private static void merge(EStructuralFeature feature, EObject to, EObject from) {
        boolean contained = feature instanceof EReference && ((EReference)feature).isContainment();
        boolean recursive = feature instanceof EAttribute || contained;
        Object oldValue = to.eGet(feature);
        Object newValue = from.eGet(feature);
        if (feature.isMany() && oldValue instanceof EMap) {
            EMap oldMap = (EMap)oldValue;
            EMap newMap = (EMap)newValue;
            for (Object newKey : newMap.keySet()) {
                if (oldMap.containsKey(newKey)) {
                    Object oldItem = oldMap.get(newKey);
                    Object newItem = newMap.get(newKey);
                    if (oldItem instanceof EObject && newItem instanceof EObject && !(oldItem instanceof IItemHandle) && !(newItem instanceof IItemHandle)) {
                        EMFHelper.merge((EObject)oldItem, (EObject)newItem);
                        continue;
                    }
                    if (oldItem instanceof List && newItem instanceof List) {
                        EMFHelper.mergeList((List)oldItem, (List)newItem, contained, recursive);
                        continue;
                    }
                    if (EMFHelper.equals(oldItem, newItem, recursive, null)) continue;
                    oldMap.put(newKey, contained ? EMFHelper.copy(newItem) : newItem);
                    continue;
                }
                Object value = newMap.get(newKey);
                oldMap.put(newKey, contained ? EMFHelper.copy(value) : value);
            }
            ArrayList removals = new ArrayList();
            for (Object oldKey : oldMap.keySet()) {
                if (newMap.containsKey(oldKey)) continue;
                removals.add(oldKey);
            }
            for (Object key : removals) {
                oldMap.removeKey(key);
            }
        } else if (feature.isMany() && oldValue instanceof List) {
            EMFHelper.mergeList((List)oldValue, (List)newValue, contained, recursive);
        } else if (!EMFHelper.equals(oldValue, newValue, recursive, null)) {
            to.eSet(feature, contained ? EMFHelper.copy(newValue) : newValue);
        }
    }

    private static void mergeList(List oldList, List newList, boolean contained, boolean recursive) {
        if (oldList.size() > newList.size()) {
            List removals = oldList.subList(newList.size(), oldList.size());
            removals.clear();
        }
        if (oldList.size() < newList.size()) {
            List additions = newList.subList(oldList.size(), newList.size());
            EMFHelper.addAll(oldList, contained ? EMFHelper.copy(additions) : additions);
        }
        int i = 0;
        while (i < newList.size()) {
            Object oldItem = oldList.get(i);
            Object newItem = newList.get(i);
            if (oldItem instanceof EObject && newItem instanceof EObject && !(oldItem instanceof IItemHandle) && !(newItem instanceof IItemHandle)) {
                EMFHelper.merge((EObject)oldItem, (EObject)newItem);
            } else if (!EMFHelper.equals(oldItem, newItem, recursive, null)) {
                EMFHelper.set(oldList, i, contained ? EMFHelper.copy(newItem) : newItem);
            }
            ++i;
        }
    }

    private static void addAll(List target, Collection additions) {
        for (Object addition : additions) {
            if (addition instanceof Helper) {
                UUID uuid = ((Helper)addition).getInternalId();
                target.add(addition);
                ((Helper)addition).setInternalId(uuid);
                continue;
            }
            if (target instanceof EObjectEList && target.contains(addition)) {
                target.add(EMFHelper.copy(addition));
                continue;
            }
            target.add(addition);
        }
    }

    private static void set(List target, int i, Object element) {
        if (element instanceof Helper) {
            UUID uuid = ((Helper)element).getInternalId();
            target.set(i, element);
            ((Helper)element).setInternalId(uuid);
        } else if (target instanceof EObjectEList && target.contains(element)) {
            target.set(i, EMFHelper.copy(element));
        } else {
            target.set(i, element);
        }
    }

    public static void set(EObject object, EStructuralFeature feature, Object value) {
        if (value instanceof Helper) {
            UUID uuid = ((Helper)value).getInternalId();
            object.eSet(feature, value);
            ((Helper)value).setInternalId(uuid);
        } else if (value instanceof List) {
            ArrayList<UUID> uuids = new ArrayList<UUID>();
            for (Object element : (List)value) {
                if (element instanceof Helper) {
                    uuids.add(((Helper)element).getInternalId());
                    continue;
                }
                uuids.add(null);
            }
            object.eSet(feature, value);
            int i = 0;
            while (i < uuids.size()) {
                Object element = ((List)value).get(i);
                if (element instanceof Helper) {
                    ((Helper)element).setInternalId((UUID)uuids.get(i));
                }
                ++i;
            }
        } else {
            object.eSet(feature, value);
        }
    }

    public static Object copy(Object from) {
        if (from instanceof Collection) {
            return EMFHelper.copy((Collection)from);
        }
        if (!(from instanceof EObject)) {
            return from;
        }
        EObject copy = EcoreUtil.copy((EObject)((EObject)from));
        if (copy instanceof Item) {
            Item itemCopy = (Item)copy;
            itemCopy.setWorkingCopy(((Item)from).isWorkingCopy());
            if (copy instanceof Auditable) {
                Auditable auditableCopy = (Auditable)itemCopy;
                Auditable auditableFrom = (Auditable)from;
                auditableCopy.setWorkingCopyMergePredecessor(auditableFrom.getWorkingCopyMergePredecessor());
                auditableCopy.setWorkingCopyPredecessor(auditableFrom.getWorkingCopyPredecessor());
            }
        }
        return copy;
    }

    public static Collection copy(Collection from) {
        ArrayList<Object> copy = new ArrayList<Object>(from.size());
        Iterator iter = from.iterator();
        while (iter.hasNext()) {
            copy.add(EMFHelper.copy(iter.next()));
        }
        return copy;
    }

    public static boolean equals(Object left, Object right) {
        return EMFHelper.equals(left, right, true, null);
    }

    public static boolean equals(Object left, Object right, Set<EStructuralFeature> excludedFeatures) {
        return EMFHelper.equals(left, right, true, excludedFeatures);
    }

    private static boolean equals(Object left, Object right, boolean recursive, Set<EStructuralFeature> excludedFeatures) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (!recursive && left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        if (recursive && left instanceof EObject && right instanceof EObject) {
            EObject leftObject = (EObject)left;
            EObject rightObject = (EObject)right;
            if (leftObject.eClass() != rightObject.eClass()) {
                return false;
            }
            for (EStructuralFeature feature : leftObject.eClass().getEAllStructuralFeatures()) {
                if (excludedFeatures != null && excludedFeatures.contains(feature)) continue;
                boolean innerRecursive = feature instanceof EAttribute || feature instanceof EReference && ((EReference)feature).isContainment();
                Object leftValue = leftObject.eGet(feature);
                Object rightValue = rightObject.eGet(feature);
                if (feature.isMany() && leftValue instanceof List) {
                    List leftList = (List)leftValue;
                    List rightList = (List)rightValue;
                    if (leftList.size() != rightList.size()) {
                        return false;
                    }
                    int i = 0;
                    while (i < rightList.size()) {
                        Object rightItem;
                        Object leftItem = leftList.get(i);
                        if (!EMFHelper.equals(leftItem, rightItem = rightList.get(i), innerRecursive, excludedFeatures)) {
                            return false;
                        }
                        ++i;
                    }
                    continue;
                }
                if (EMFHelper.equals(leftValue, rightValue, innerRecursive, excludedFeatures)) continue;
                return false;
            }
            return true;
        }
        return left.equals(right);
    }
}

