/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditablesHelper {
    private static final String PLUGIN_ID = "com.ibm.team.workitem.common";
    private static final String ENFORCE_ACCESS_PROFILES_OPTION = "/behavior/enforceCustomProfiles";
    public static final boolean ENFORCE_ACCESS_PROFILES = !Boolean.toString(false).equals(Utils.getDebugOption("com.ibm.team.workitem.common/behavior/enforceCustomProfiles"));
    private static final String USE_CUSTOM_ACCESS_PROFILES_OPTION = "/behavior/useCustomProfiles";
    public static final boolean USE_CUSTOM_ACCESS_PROFILES = !Boolean.toString(false).equals(Utils.getDebugOption("com.ibm.team.workitem.common/behavior/useCustomProfiles"));
    private static final String ENFORCE_PROJECT_AREA_NOT_NULL_OPTION = "/behavior/enforceProjectAreaNotNull";
    public static final boolean ENFORCE_PROJECT_AREA_NOT_NULL = !Boolean.toString(false).equals(Utils.getDebugOption("com.ibm.team.workitem.common/behavior/enforceProjectAreaNotNull"));
    public static final Collection<String> AUDITABLE_SMALL_PROFILE = Arrays.asList(IItem.ITEM_ID_PROPERTY, IItem.STATE_ID_PROPERTY, IItem.MODIFIED_PROPERTY, IItem.CONTEXT_ID_PROPERTY);
    public static final Collection<String> AUDITABLE_LARGE_PROFILE = AuditablesHelper.union(AUDITABLE_SMALL_PROFILE, new String[]{IItem.MODIFIED_BY_PROPERTY, IAuditable.PREDECESSOR_STATE_PROPERTY, IAuditable.MERGE_PREDECESSOR_STATE_PROPERTY});

    public static void handleAccessProfileViolation(IAuditable item) {
        throw new IllegalStateException("Feature not contained in access profile " + ItemProfile.computeProfile(item).toString());
    }

    public static Collection<String> union(Collection<String> base, String[] extension) {
        return AuditablesHelper.union(base, Arrays.asList(extension));
    }

    public static Collection<String> union(Collection<String> base, Collection<String> extension) {
        ArrayList<String> union = new ArrayList<String>(base);
        union.addAll(extension);
        return Collections.unmodifiableCollection(union);
    }

    public static Collection<String> union(Collection<String> base, Collection<String> extension1, String[] extension2) {
        ArrayList<String> union = new ArrayList<String>(base);
        union.addAll(extension1);
        union.addAll(Arrays.asList(extension2));
        return Collections.unmodifiableCollection(union);
    }

    public static Collection<String> allProperties(IItemType itemType) {
        return ((ItemType)itemType).propertyNames();
    }

    public static Collection<String> getProperties(ItemProfile<?> profile, IItemType itemType) {
        AuditablesHelper.assertItemType(profile, itemType);
        return profile.getProperties();
    }

    public static String[] getPropertiesArray(ItemProfile<?> profile, IItemType itemType) {
        AuditablesHelper.assertItemType(profile, itemType);
        return profile.getPropertiesArray();
    }

    public static Collection<String> getProcessPropertiesFromIds(Class<?> clazz, String ... ids) {
        ArrayList<String> properties = new ArrayList<String>(ids.length);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            properties.add(ProcessCommon.getPropertyName(clazz, (String)id));
            ++n2;
        }
        return properties;
    }

    private static void assertItemType(ItemProfile<?> profile, IItemType itemType) {
        if (IProcessArea.ITEM_TYPE.equals(profile.getItemType())) {
            Assert.isTrue((IProjectArea.ITEM_TYPE.equals(itemType) || ITeamArea.ITEM_TYPE.equals(itemType) || profile.getItemType().equals(itemType) ? 1 : 0) != 0);
        } else {
            Assert.isTrue((boolean)profile.getItemType().equals(itemType));
        }
    }

    public static Collection<String> addDependencies(IItemType itemType, Collection<String> properties) {
        if (IWorkItem.ITEM_TYPE.equals(itemType)) {
            Collection<String> allProperties = AuditablesHelper.allProperties(itemType);
            boolean hasCustomAttributes = false;
            HashSet<String> profile = new HashSet<String>();
            for (String property : properties) {
                if (allProperties.contains(property)) {
                    profile.add(property);
                    continue;
                }
                hasCustomAttributes = true;
            }
            if (hasCustomAttributes) {
                profile.addAll(IWorkItem.CUSTOM_ATTRIBUTE_PROPERTIES);
            }
            return profile;
        }
        return properties;
    }
}

