/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.workitem.common.internal.template.Messages;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.IWorkItemTemplateDescriptor;
import com.ibm.team.workitem.common.template.IWorkItemTemplateHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemTemplateHandle
implements IWorkItemTemplateHandle {
    private final IProjectAreaHandle fProjectArea;
    private String fIdentifier;
    private String fName;
    private String fDescription;
    private IContributorHandle fOwner;
    private List<IAttributeVariable> fVariables;

    public WorkItemTemplateHandle(String id, IProjectAreaHandle projectArea) {
        if (projectArea == null) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateHandle.ERROR_ON_INITIALIZATION_NULL_PROJECT_AREA"));
        }
        this.setId(id);
        this.fProjectArea = projectArea;
    }

    public WorkItemTemplateHandle(IWorkItemTemplateDescriptor desc) {
        this(desc != null ? desc.getId() : null, desc != null ? desc.getProjectArea() : null);
        if (desc != null) {
            this.setName(desc.getName());
            this.setDescription(desc.getDescription());
            this.fVariables = new ArrayList<IAttributeVariable>(desc.getVariables());
        }
    }

    public void setId(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("WorkItemTemplateHandle.ERROR_ON_INITIALIZATION_ILLEGAL_IDENTIFIER"));
        }
        this.fIdentifier = identifier;
    }

    @Override
    public String getId() {
        return this.fIdentifier;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        if (name != null && name.length() > 0) {
            this.fName = name;
        }
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String description) {
        if (description != null && description.length() > 0) {
            this.fDescription = description;
        }
    }

    @Override
    public IContributorHandle getOwner() {
        return this.fOwner;
    }

    public void setOwner(IContributorHandle owner) {
        this.fOwner = owner;
    }

    @Override
    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    @Override
    public List<IAttributeVariable> getVariables() {
        return this.fVariables != null ? Collections.unmodifiableList(this.fVariables) : Collections.emptyList();
    }

    public void addVariables(IAttributeVariable ... variables) {
        if (variables != null && variables.length > 0) {
            if (this.fVariables == null) {
                this.fVariables = new ArrayList<IAttributeVariable>();
            }
            IAttributeVariable[] iAttributeVariableArray = variables;
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                IAttributeVariable cur = iAttributeVariableArray[n2];
                if (cur != null && !this.fVariables.contains(cur)) {
                    this.fVariables.add(cur);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean hasVariables() {
        return this.fVariables != null && this.fVariables.size() > 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fDescription == null ? 0 : this.fDescription.hashCode());
        result = 31 * result + (this.fIdentifier == null ? 0 : this.fIdentifier.hashCode());
        result = 31 * result + (this.fProjectArea == null ? 0 : this.fProjectArea.hashCode());
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + this.getVariables().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WorkItemTemplateHandle other = (WorkItemTemplateHandle)obj;
        if (this.fDescription == null ? other.fDescription != null : !this.fDescription.equals(other.fDescription)) {
            return false;
        }
        if (this.fIdentifier == null ? other.fIdentifier != null : !this.fIdentifier.equals(other.fIdentifier)) {
            return false;
        }
        if (this.fProjectArea == null ? other.fProjectArea != null : !this.fProjectArea.getItemId().equals((Object)other.fProjectArea.getItemId())) {
            return false;
        }
        if (this.fName == null ? other.fName != null : !this.fName.equals(other.fName)) {
            return false;
        }
        return this.getVariables().equals(other.getVariables());
    }
}

