/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.query.BaseContributorQueryModel;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.utils.DateUtils;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.identifiers.AttributeFacade;
import com.ibm.team.workitem.common.internal.identifiers.IInternalAttributeIdentifiers;
import com.ibm.team.workitem.common.internal.identifiers.IInternalTypeIdentifiers;
import com.ibm.team.workitem.common.internal.identifiers.IPublicAttribute;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierMapping;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierRegistry;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.internal.workflow.InternalWorkflowKeys;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IDeliverableHandle;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemTemplateFacade
extends AttributeFacade {
    private static final IProgressMonitor MONITOR = new NullProgressMonitor();
    private static final List<String> IGNORED_ATTRIBUTES = Arrays.asList(IInternalAttributeIdentifiers.WORKITEM_IDENTIFIER.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_CREATION_DATE.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_MODIFIED.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_MODIFIED_BY.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_PROJECT_AREA.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_TYPE.getStringIdentifier(), IInternalAttributeIdentifiers.WORKITEM_APPROVALS.getScopedIdentifier());

    public WorkItemTemplateFacade(Class<IdentifierRegistry> registry, IProjectAreaHandle projectArea, IWorkItemCommon itemCommon) throws TeamRepositoryException {
        super(registry, projectArea, itemCommon, MONITOR);
    }

    @Override
    public Object getInternalValue(Identifier<IPublicAttribute> identifier, String pubValue) {
        if (pubValue == null) {
            return null;
        }
        Identifier intAttrId = this.getInternalIdentifier(identifier);
        Identifier intTypeId = this.getAttributeType(intAttrId);
        if (intTypeId != null) {
            try {
                if (intAttrId.getType().isAssignableFrom(ILink.class)) {
                    String linkId = intAttrId.getStringIdentifier();
                    String endPointId = linkId.substring(linkId.lastIndexOf(46) + 1);
                    ILinkType linkType = ILinkTypeRegistry.INSTANCE.getLinkType(linkId.substring(0, linkId.lastIndexOf(46)));
                    if (IdentifierMapping.getLinkId(linkType.getSourceEndPointDescriptor()).equals(endPointId)) {
                        return linkType.getSourceEndPointDescriptor();
                    }
                    return linkType.getTargetEndPointDescriptor();
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.CATEGORY)) {
                    String[] namePath = pubValue.split("/");
                    return this.getItemCommon().findCategoryByNamePath((IProjectAreaHandle)this.getProjectArea(MONITOR), Arrays.asList(namePath), MONITOR);
                }
                if (intTypeId.equals(IInternalTypeIdentifiers.ITERATION)) {
                    IDevelopmentLineHandle[] developmentLines = this.getProjectArea(MONITOR).getDevelopmentLines();
                    if (developmentLines != null) {
                        IDevelopmentLineHandle[] iDevelopmentLineHandleArray = developmentLines;
                        int n = developmentLines.length;
                        int linkType = 0;
                        while (linkType < n) {
                            IDevelopmentLineHandle curLineHan = iDevelopmentLineHandleArray[linkType];
                            IDevelopmentLine curLine = this.getAuditableCommon().fetchCurrentAuditable((IAuditableHandle)curLineHan, ItemProfile.DEVELOPMENT_LINE_DEFAULT, MONITOR);
                            IIterationHandle[] iterations = curLine.getIterations();
                            if (iterations != null) {
                                IIterationHandle[] iIterationHandleArray = iterations;
                                int n2 = iterations.length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    IIterationHandle curIterHan = iIterationHandleArray[n3];
                                    IIteration curIter = this.getAuditableCommon().fetchCurrentAuditable((IAuditableHandle)curIterHan, ItemProfile.ITERATION_DEFAULT, MONITOR);
                                    if (curIter.getId().equals(pubValue)) {
                                        return curIter;
                                    }
                                    ++n3;
                                }
                            }
                            ++linkType;
                        }
                    }
                } else if (intTypeId.equals(IInternalTypeIdentifiers.CONTRIBUTOR)) {
                    IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)BaseContributorQueryModel.ContributorQueryModel.ROOT);
                    query.filter(BaseContributorQueryModel.ContributorQueryModel.ROOT.userId()._eq(pubValue));
                    ItemQueryIterator queryIterator = new ItemQueryIterator(this.getItemCommon().getAuditableCommon(), query, new Object[0]);
                    if (queryIterator.hasNext(MONITOR)) {
                        return queryIterator.next(MONITOR);
                    }
                } else if (intTypeId.equals(IInternalTypeIdentifiers.PRIORITY)) {
                    Identifier<IPriority> target = Identifier.create(IPriority.class, pubValue);
                    List list = this.getItemCommon().findPriorities((IProjectAreaHandle)this.getProjectArea(MONITOR), MONITOR);
                    if (list != null) {
                        for (IPriority curPri : list) {
                            if (!target.equals(curPri.getIdentifier2())) continue;
                            return curPri.getIdentifier2().getStringIdentifier();
                        }
                    }
                } else {
                    if (intTypeId.equals(IInternalTypeIdentifiers.DELIVERABLE)) {
                        return this.getItemCommon().findDeliverableByName((IProjectAreaHandle)this.getProjectArea(MONITOR), pubValue, IDeliverable.DEFAULT_PROFILE, MONITOR);
                    }
                    if (intTypeId.equals(IInternalTypeIdentifiers.SEVERITY)) {
                        Identifier<ISeverity> target = Identifier.create(ISeverity.class, pubValue);
                        List list = this.getItemCommon().findSeverities((IProjectAreaHandle)this.getProjectArea(MONITOR), MONITOR);
                        if (list != null) {
                            for (ISeverity curSev : list) {
                                if (!target.equals(curSev.getIdentifier2())) continue;
                                return curSev.getIdentifier2().getStringIdentifier();
                            }
                        }
                    } else if (intTypeId.equals(IInternalTypeIdentifiers.TEAM_AREA)) {
                        List teamAreas = this.getProjectArea(MONITOR).getTeamAreas();
                        if (teamAreas != null) {
                            for (ITeamAreaHandle cur : teamAreas) {
                                ITeamArea curTeam = this.getAuditableCommon().fetchCurrentAuditable((IAuditableHandle)cur, ItemProfile.TEAM_AREA_DEFAULT, MONITOR);
                                if (!pubValue.equals(curTeam.getName())) continue;
                                return curTeam;
                            }
                        }
                    } else {
                        if (intTypeId.equals(IInternalTypeIdentifiers.TAGS)) {
                            return new SeparatedStringList(pubValue);
                        }
                        if (intTypeId.equals(IInternalTypeIdentifiers.LARGE_HTML) || intTypeId.equals(IInternalTypeIdentifiers.MEDIUM_HTML) || intTypeId.equals(IInternalTypeIdentifiers.LARGE_HTML) || intTypeId.equals(IInternalTypeIdentifiers.MEDIUM_STRING) || intTypeId.equals(IInternalTypeIdentifiers.LARGE_STRING)) {
                            return pubValue;
                        }
                        if (intTypeId.equals(IInternalTypeIdentifiers.TIMESTAMP)) {
                            return DateUtils.parseTimeRFC3339((String)pubValue);
                        }
                        if (intTypeId.equals(IInternalTypeIdentifiers.BOOLEAN)) {
                            return Boolean.parseBoolean(pubValue);
                        }
                        if (intTypeId.equals(IInternalTypeIdentifiers.FLOAT)) {
                            return Float.valueOf(Float.parseFloat(pubValue));
                        }
                        if (intTypeId.equals(IInternalTypeIdentifiers.LONG)) {
                            return Long.parseLong(pubValue);
                        }
                        if (intTypeId.equals(IInternalTypeIdentifiers.INTEGER)) {
                            return Integer.parseInt(pubValue);
                        }
                    }
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
            }
            catch (ParseException parseException) {}
        }
        return null;
    }

    @Override
    public String getPublicValue(Identifier<IPublicAttribute> identifier, Object internalValue) {
        if (internalValue == null) {
            return null;
        }
        Identifier typeId = this.getAttributeType(this.getInternalIdentifier(identifier));
        if (typeId != null) {
            try {
                if (typeId.equals(IInternalTypeIdentifiers.CATEGORY)) {
                    ICategoryHandle cat = (ICategoryHandle)internalValue;
                    return this.getItemCommon().resolveHierarchicalName(cat, MONITOR);
                }
                if (identifier.equals(IInternalTypeIdentifiers.ITERATION)) {
                    IIterationHandle handle = (IIterationHandle)internalValue;
                    IIteration iter = this.getAuditableCommon().fetchCurrentAuditable((IAuditableHandle)handle, ItemProfile.ITERATION_DEFAULT, MONITOR);
                    return iter.getId();
                }
                if (typeId.equals(IInternalTypeIdentifiers.CONTRIBUTOR)) {
                    IContributorHandle handle = (IContributorHandle)internalValue;
                    IContributor con = this.getAuditableCommon().fetchCurrentAuditable((IAuditableHandle)handle, ItemProfile.CONTRIBUTOR_DEFAULT, MONITOR);
                    return con.getUserId();
                }
                if (typeId.equals(IInternalTypeIdentifiers.PRIORITY)) {
                    Identifier pri = (Identifier)internalValue;
                    return pri.getStringIdentifier();
                }
                if (typeId.equals(IInternalTypeIdentifiers.DELIVERABLE)) {
                    IDeliverableHandle handle = (IDeliverableHandle)internalValue;
                    IDeliverable del = this.getAuditableCommon().fetchCurrentAuditable(handle, IDeliverable.DEFAULT_PROFILE, MONITOR);
                    return del.getName();
                }
                if (typeId.equals(IInternalTypeIdentifiers.SEVERITY)) {
                    Identifier sev = (Identifier)internalValue;
                    return sev.getStringIdentifier();
                }
                if (typeId.equals(IInternalTypeIdentifiers.TEAM_AREA)) {
                    ITeamAreaHandle handle = (ITeamAreaHandle)internalValue;
                    ITeamArea team = this.getAuditableCommon().fetchCurrentAuditable((IAuditableHandle)handle, ItemProfile.TEAM_AREA_DEFAULT, MONITOR);
                    return team.getName();
                }
                if (typeId.equals(IInternalTypeIdentifiers.TAGS)) {
                    SeparatedStringList tagList = (SeparatedStringList)internalValue;
                    return tagList.getSeparatedString();
                }
                if (typeId.equals(IInternalTypeIdentifiers.LARGE_HTML) || typeId.equals(IInternalTypeIdentifiers.MEDIUM_HTML) || typeId.equals(IInternalTypeIdentifiers.LARGE_HTML) || typeId.equals(IInternalTypeIdentifiers.MEDIUM_STRING) || typeId.equals(IInternalTypeIdentifiers.LARGE_STRING)) {
                    return (String)internalValue;
                }
                if (typeId.equals(IInternalTypeIdentifiers.TIMESTAMP)) {
                    return DateUtils.formatTimeRFC3339((Date)((Timestamp)internalValue));
                }
                if (typeId.equals(IInternalTypeIdentifiers.BOOLEAN)) {
                    return ((Boolean)internalValue).toString();
                }
                if (typeId.equals(IInternalTypeIdentifiers.FLOAT)) {
                    return ((Float)internalValue).toString();
                }
                if (typeId.equals(IInternalTypeIdentifiers.LONG)) {
                    return ((Long)internalValue).toString();
                }
                if (typeId.equals(IInternalTypeIdentifiers.INTEGER)) {
                    return ((Integer)internalValue).toString();
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
        return null;
    }

    public static boolean isDefaultValue(IWorkItemCommon workItemCommon, IAttribute attribute, IWorkItem newState, Object value) throws TeamRepositoryException {
        if ("duration".equals(attribute.getAttributeType()) && value instanceof Long) {
            return (Long)value == 0L || (Long)value == -1L;
        }
        if (IWorkItem.STATE_PROPERTY.equals(attribute.getIdentifier())) {
            Identifier<IState> state;
            Identifier<IWorkflowAction> startActionId;
            IWorkflowInfo workflowInfo = workItemCommon.findWorkflowInfo(newState, null);
            return workflowInfo != null && (startActionId = workflowInfo.getStartActionId()) != null && (state = workflowInfo.getActionResultState(startActionId)) != null && state.getStringIdentifier().equals(value);
        }
        if (IWorkItem.RESOLUTION_PROPERTY.equals(attribute.getIdentifier())) {
            Identifier<IResolution>[] resolutionIds;
            Identifier<IWorkflowAction> startActionId;
            if (value == null || "".equals(value) || InternalWorkflowKeys.LEGACY_ECLIPSEWAY_RESOLUTION_UNRESOLVED.getStringIdentifier().equals(value)) {
                return true;
            }
            IWorkflowInfo workflowInfo = workItemCommon.findWorkflowInfo(newState, null);
            if (workflowInfo != null && (startActionId = workflowInfo.getStartActionId()) != null && (resolutionIds = workflowInfo.getResolutionIds(startActionId)).length > 0) {
                Identifier<IResolution> defaultResolution = resolutionIds[0];
                return defaultResolution.getStringIdentifier().equals(value);
            }
            return false;
        }
        if (value instanceof AbstractCollection) {
            Object next;
            if ("subscriptions".equals(attribute.getAttributeType()) && ((AbstractCollection)value).size() == 1 && (next = ((AbstractCollection)value).iterator().next()) instanceof IItemHandle && ((IItemHandle)next).sameItemId((IItemHandle)workItemCommon.getAuditableCommon().getUser())) {
                return true;
            }
            return ((AbstractCollection)value).size() == 0;
        }
        Object defaultValue = attribute.getDefaultValue(workItemCommon.getAuditableCommon(), newState, null);
        if (defaultValue instanceof String && value instanceof String) {
            return defaultValue.equals(value);
        }
        if (defaultValue instanceof IItemHandle && value instanceof IItemHandle) {
            IItemHandle dfltItem = (IItemHandle)defaultValue;
            IItemHandle newValue = (IItemHandle)value;
            return dfltItem.getItemId().equals((Object)newValue.getItemId());
        }
        return value == defaultValue || value != null && value.equals(defaultValue);
    }

    public static boolean isTemplateAttribute(IAttribute attribute) throws TeamRepositoryException {
        if (attribute == null || attribute.isInternal() || attribute.isReadOnly()) {
            return false;
        }
        return !IGNORED_ATTRIBUTES.contains(attribute.getIdentifier());
    }
}

