/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.rcp.dto.impl;

import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.rcp.dto.ExceptionDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.StatusResultDTO;
import com.ibm.team.workitem.common.internal.rcp.dto.impl.Messages;
import com.ibm.team.workitem.common.internal.rcp.dto.impl.SaveResultDTOImpl;
import com.ibm.team.workitem.common.internal.util.WorkItemProcessUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class SaveResultDTOCustomImpl
extends SaveResultDTOImpl {
    private static final int INTERNAL_CODE = 1;

    public IStatus getStatus() {
        StatusResultDTO participantStatus;
        int processSeverity;
        int severity;
        ArrayList<Object> statuses = new ArrayList<Object>();
        if (this.getReconcileReport() != null) {
            statuses.add(new Status(4, "com.ibm.team.workitem.common", 1, Messages.getString("SaveResultDTOCustomImpl.SAVE_CONFLICT"), null));
        }
        if (this.getOperationReport() != null && (severity = this.getStatusSeverity(processSeverity = this.getOperationReport().getSeverity())) != 0) {
            statuses.add(new Status(severity, "com.ibm.team.workitem.common", 1, this.getDescription(this.getOperationReport()), null));
        }
        if ((participantStatus = this.getInternalParticipantStatus()) != null && participantStatus.getSeverity() != 0) {
            statuses.add(new Status(participantStatus.getSeverity(), "com.ibm.team.workitem.common", participantStatus.getCode(), participantStatus.getMessage(), this.getException(participantStatus.getException())));
        }
        if (this.getUpdatedState() == null) {
            boolean addCancel = true;
            for (IStatus iStatus : statuses) {
                if (iStatus.getSeverity() != 8 && iStatus.getSeverity() != 4) continue;
                addCancel = false;
                break;
            }
            if (addCancel) {
                statuses.add(Status.CANCEL_STATUS);
            }
        }
        if (statuses.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (statuses.size() == 1) {
            return (IStatus)statuses.get(0);
        }
        return new MultiStatus("com.ibm.team.workitem.common", 1, statuses.toArray(new IStatus[statuses.size()]), Messages.getString("MultiSaveResultDTOCustomImpl.SAVE_STATUS"), null);
    }

    private Throwable getException(ExceptionDTO exceptionDTO) {
        if (exceptionDTO == null) {
            return null;
        }
        String clazzName = exceptionDTO.getClazz();
        String message = exceptionDTO.getMessage();
        ExceptionDTO causeDTO = exceptionDTO.getCause();
        Throwable cause = this.getException(causeDTO);
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> constructor = clazz.getConstructor(String.class, Throwable.class);
            Throwable exception = (Throwable)constructor.newInstance(message, cause);
            Object data = exceptionDTO.getData();
            if (exception instanceof TeamRepositoryException && data != null) {
                ((TeamRepositoryException)exception).setData(data);
            }
            return exception;
        }
        catch (Exception exception) {
            return new Exception(message, cause);
        }
    }

    private String getDescription(IOperationReport operationReport) {
        IReportInfo info = WorkItemProcessUtils.getFirstErrorInfo((IProcessReport)operationReport);
        if (info != null && info.getSummary() != null) {
            return info.getSummary();
        }
        return Messages.getString("SaveResultDTOCustomImpl.NO_DESCRIPTION");
    }

    public int getSeverity() {
        if (this.getReconcileReport() != null) {
            return 4;
        }
        int maxSeverity = 0;
        if (this.getUpdatedState() == null) {
            maxSeverity = 8;
        }
        if (this.getOperationReport() != null) {
            int processSeverity = this.getOperationReport().getSeverity();
            int severity = this.getStatusSeverity(processSeverity);
            maxSeverity = this.maxSeverity(maxSeverity, severity);
        }
        if (this.getInternalParticipantStatus() != null) {
            maxSeverity = this.maxSeverity(maxSeverity, this.getInternalParticipantStatus().getSeverity());
        }
        return maxSeverity;
    }

    private int getStatusSeverity(int processSeverity) {
        int severity;
        switch (processSeverity) {
            case 0: {
                severity = 0;
                break;
            }
            case 2: {
                severity = 2;
                break;
            }
            case 4: {
                severity = 4;
                break;
            }
            default: {
                WorkItemCommonPlugin.log("Unknown process status", new Exception());
                severity = 0;
            }
        }
        return severity;
    }

    public boolean isSuccessful() {
        int severity = this.getSeverity();
        return severity != 4 && severity != 8;
    }

    public boolean isConflictingUpdate() {
        return this.getReconcileReport() != null;
    }

    private int maxSeverity(int left, int right) {
        if (left == 4 || right == 4) {
            return 4;
        }
        return Math.max(left, right);
    }
}

