/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IManyItemQueryModel;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.model.AttributeOperation;
import java.util.List;

public class ListContainsOperation
extends AttributeOperation {
    private boolean fInvert;

    public ListContainsOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    public boolean evaluate(Object left, Object right) {
        boolean result = this.internalEvaluate(left, right);
        return this.fInvert ? !result : result;
    }

    private boolean internalEvaluate(Object left, Object right) {
        if (left instanceof List && right instanceof IItemHandle) {
            for (Object next : (List)left) {
                IItemHandle item;
                if (!(next instanceof IItemHandle) || !(item = (IItemHandle)next).sameItemId((IItemHandle)right)) continue;
                return true;
            }
        }
        return false;
    }

    public IPredicate getPredicate(ITransformationContext context) {
        IItemHandleInputArg inputArg = context.getQuery().newItemHandleArg();
        context.addParameter(context.getValue());
        IPredicate predicate = ((IManyItemQueryModel)context.getReference())._contains(inputArg);
        if (this.fInvert) {
            predicate = predicate._not();
        }
        if (context.getAttribute().isStateExtension()) {
            return context.createOldStateExtensionPredicate(predicate);
        }
        return predicate;
    }

    public boolean isNegation() {
        return this.fInvert;
    }
}

